/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.search;

import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceLocalService;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Collection;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;

public class DDMFormInstanceIndexer
extends BaseIndexer<DDMFormInstance> {
    public static final String CLASS_NAME = DDMFormInstance.class.getName();
    protected DDMFormInstanceLocalService ddmFormInstanceLocalService;
    protected IndexerRegistry indexerRegistry;
    protected IndexWriterHelper indexWriterHelper;
    private static final Log _log = LogFactoryUtil.getLog(DDMFormInstanceIndexer.class);

    public DDMFormInstanceIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"companyId", "entryClassName", "entryClassPK", "uid"});
        this.setPermissionAware(true);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    protected void doDelete(DDMFormInstance ddmFormInstance) throws Exception {
        this.deleteDocument(ddmFormInstance.getCompanyId(), ddmFormInstance.getFormInstanceId());
    }

    protected Document doGetDocument(DDMFormInstance ddmFormInstance) throws Exception {
        return this.getBaseModelDocument(CLASS_NAME, (BaseModel)ddmFormInstance);
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) throws Exception {
        return this.createSummary(document, "title", "description");
    }

    protected void doReindex(DDMFormInstance ddmFormInstance) throws Exception {
        this.indexWriterHelper.updateDocument(this.getSearchEngineId(), ddmFormInstance.getCompanyId(), this.getDocument(ddmFormInstance), this.isCommitImmediately());
        this.reindexRecords(ddmFormInstance);
    }

    protected void doReindex(String className, long classPK) throws Exception {
        DDMFormInstance ddmFormInstance = this.ddmFormInstanceLocalService.getFormInstance(classPK);
        this.doReindex(ddmFormInstance);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexFormInstances(companyId);
    }

    protected void reindexFormInstances(long companyId) throws Exception {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this.ddmFormInstanceLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(ddmFormInstance -> {
            block3: {
                try {
                    Document document = this.getDocument(ddmFormInstance);
                    if (document != null) {
                        indexableActionableDynamicQuery.addDocuments(new Document[]{document});
                    }
                }
                catch (PortalException pe) {
                    if (!_log.isWarnEnabled()) break block3;
                    _log.warn((Object)("Unable to index form instance record " + ddmFormInstance.getFormInstanceId()), (Throwable)pe);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }

    protected void reindexRecords(DDMFormInstance ddmFormInstance) throws Exception {
        Indexer indexer = this.indexerRegistry.nullSafeGetIndexer(DDMFormInstanceRecord.class);
        indexer.reindex((Collection)ddmFormInstance.getFormInstanceRecords());
    }
}

