/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.io;

import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldValueJSONDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, property={"ddm.form.values.deserializer.type=json"}, service={DDMFormValuesDeserializer.class})
public class DDMFormValuesJSONDeserializer
implements DDMFormValuesDeserializer {
    private static final Log _log = LogFactoryUtil.getLog(DDMFormValuesJSONDeserializer.class);
    private final Map<String, DDMFormFieldValueJSONDeserializer> _ddmFormFieldValueJSONDeserializers = new ConcurrentHashMap<String, DDMFormFieldValueJSONDeserializer>();
    private JSONFactory _jsonFactory;

    public DDMFormValuesDeserializerDeserializeResponse deserialize(DDMFormValuesDeserializerDeserializeRequest ddmFormValuesDeserializerDeserializeRequest) {
        DDMFormValues ddmFormValues;
        block2: {
            ddmFormValues = null;
            try {
                String content = ddmFormValuesDeserializerDeserializeRequest.getContent();
                DDMForm ddmForm = ddmFormValuesDeserializerDeserializeRequest.getDDMForm();
                JSONObject jsonObject = this._jsonFactory.createJSONObject(content);
                ddmFormValues = new DDMFormValues(ddmForm);
                this.setDDMFormValuesAvailableLocales(jsonObject.getJSONArray("availableLanguageIds"), ddmFormValues);
                this.setDDMFormValuesDefaultLocale(jsonObject.getString("defaultLanguageId"), ddmFormValues);
                this.setDDMFormFieldValues(jsonObject.getJSONArray("fieldValues"), ddmForm, ddmFormValues);
                this.setDDMFormLocalizedValuesDefaultLocale(ddmFormValues);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)e, (Throwable)e);
            }
        }
        DDMFormValuesDeserializerDeserializeResponse.Builder builder = DDMFormValuesDeserializerDeserializeResponse.Builder.newBuilder(ddmFormValues);
        return builder.build();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addDDMFormFieldValueJSONDeserializer(DDMFormFieldValueJSONDeserializer ddmFormFieldValueJSONDeserializer, Map<String, Object> properties) {
        String type = MapUtil.getString(properties, (String)"ddm.form.field.type.name");
        if (Validator.isNull((String)type)) {
            return;
        }
        this._ddmFormFieldValueJSONDeserializers.put(type, ddmFormFieldValueJSONDeserializer);
    }

    protected Set<Locale> getAvailableLocales(JSONArray jsonArray) {
        HashSet<Locale> availableLocales = new HashSet<Locale>();
        if (jsonArray == null) {
            return availableLocales;
        }
        for (int i = 0; i < jsonArray.length(); ++i) {
            Locale availableLocale = LocaleUtil.fromLanguageId((String)jsonArray.getString(i));
            availableLocales.add(availableLocale);
        }
        return availableLocales;
    }

    protected DDMFormFieldValue getDDMFormFieldValue(JSONObject jsonObject, Map<String, DDMFormField> ddmFormFieldsMap) {
        DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue();
        ddmFormFieldValue.setInstanceId(jsonObject.getString("instanceId"));
        ddmFormFieldValue.setName(jsonObject.getString("name"));
        this.setDDMFormFieldValueValue(jsonObject, ddmFormFieldsMap.get(jsonObject.getString("name")), ddmFormFieldValue);
        this.setNestedDDMFormFieldValues(jsonObject.getJSONArray("nestedFieldValues"), ddmFormFieldsMap, ddmFormFieldValue);
        return ddmFormFieldValue;
    }

    protected DDMFormFieldValueJSONDeserializer getDDMFormFieldValueJSONDeserializer(DDMFormField ddmFormField) {
        if (ddmFormField == null) {
            return null;
        }
        return this._ddmFormFieldValueJSONDeserializers.get(ddmFormField.getType());
    }

    protected List<DDMFormFieldValue> getDDMFormFieldValues(JSONArray jsonArray, Map<String, DDMFormField> ddmFormFieldsMap) {
        ArrayList<DDMFormFieldValue> ddmFormFieldValues = new ArrayList<DDMFormFieldValue>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            DDMFormFieldValue ddmFormFieldValue = this.getDDMFormFieldValue(jsonArray.getJSONObject(i), ddmFormFieldsMap);
            ddmFormFieldValues.add(ddmFormFieldValue);
        }
        return ddmFormFieldValues;
    }

    protected LocalizedValue getLocalizedValue(JSONObject jsonObject) {
        LocalizedValue localizedValue = new LocalizedValue();
        Iterator itr = jsonObject.keys();
        while (itr.hasNext()) {
            String languageId = (String)itr.next();
            if (!LanguageUtil.isAvailableLocale((String)languageId)) continue;
            localizedValue.addString(LocaleUtil.fromLanguageId((String)languageId), jsonObject.getString(languageId));
        }
        return localizedValue;
    }

    protected Value getValue(DDMFormField ddmFormField, JSONObject jsonObject) {
        DDMFormFieldValueJSONDeserializer ddmFormFieldValueJSONDeserializer = this.getDDMFormFieldValueJSONDeserializer(ddmFormField);
        if (ddmFormFieldValueJSONDeserializer != null) {
            return ddmFormFieldValueJSONDeserializer.deserialize(ddmFormField, String.valueOf(jsonObject.get("value")));
        }
        JSONObject valueJSONObject = jsonObject.getJSONObject("value");
        if (this.isLocalized(valueJSONObject)) {
            return this.getLocalizedValue(valueJSONObject);
        }
        return new UnlocalizedValue(jsonObject.getString("value"));
    }

    protected boolean isLocalized(JSONObject jsonObject) {
        if (jsonObject == null) {
            return false;
        }
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (ArrayUtil.contains((Object[])PropsValues.LOCALES, (Object)key)) continue;
            return false;
        }
        return true;
    }

    protected void removeDDMFormFieldValueJSONDeserializer(DDMFormFieldValueJSONDeserializer ddmFormFieldValueJSONDeserializer, Map<String, Objects> properties) {
        String type = MapUtil.getString(properties, (String)"ddm.form.field.type.name");
        this._ddmFormFieldValueJSONDeserializers.remove(type);
    }

    protected void setDDMFormFieldValueLocalizedValueDefaultLocale(DDMFormFieldValue ddmFormFieldValue, Locale defaultLocale) {
        Value value = ddmFormFieldValue.getValue();
        if (value != null && value.isLocalized()) {
            value.setDefaultLocale(defaultLocale);
        }
        for (DDMFormFieldValue nestedDDMFormFieldValue : ddmFormFieldValue.getNestedDDMFormFieldValues()) {
            this.setDDMFormFieldValueLocalizedValueDefaultLocale(nestedDDMFormFieldValue, defaultLocale);
        }
    }

    protected void setDDMFormFieldValues(JSONArray jsonArray, DDMForm ddmForm, DDMFormValues ddmFormValues) {
        List<DDMFormFieldValue> ddmFormFieldValues = this.getDDMFormFieldValues(jsonArray, ddmForm.getDDMFormFieldsMap(true));
        ddmFormValues.setDDMFormFieldValues(ddmFormFieldValues);
    }

    protected void setDDMFormFieldValueValue(JSONObject jsonObject, DDMFormField ddmFormField, DDMFormFieldValue ddmFormFieldValue) {
        String valueString = jsonObject.getString("value", null);
        if (valueString == null) {
            return;
        }
        Value value = this.getValue(ddmFormField, jsonObject);
        ddmFormFieldValue.setValue(value);
    }

    protected void setDDMFormLocalizedValuesDefaultLocale(DDMFormValues ddmFormValues) {
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormValues.getDDMFormFieldValues()) {
            this.setDDMFormFieldValueLocalizedValueDefaultLocale(ddmFormFieldValue, ddmFormValues.getDefaultLocale());
        }
    }

    protected void setDDMFormValuesAvailableLocales(JSONArray jsonArray, DDMFormValues ddmFormValues) {
        ddmFormValues.setAvailableLocales(this.getAvailableLocales(jsonArray));
    }

    protected void setDDMFormValuesDefaultLocale(String defaultLanguageId, DDMFormValues ddmFormValues) {
        Locale defaultLocale = LocaleUtil.fromLanguageId((String)defaultLanguageId);
        ddmFormValues.setDefaultLocale(defaultLocale);
        Set availableLocales = ddmFormValues.getAvailableLocales();
        if (availableLocales != null && !availableLocales.contains(defaultLocale)) {
            availableLocales.add(defaultLocale);
        }
    }

    @Reference(unbind="-")
    protected void setJSONFactory(JSONFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
    }

    protected void setNestedDDMFormFieldValues(JSONArray jsonArray, Map<String, DDMFormField> ddmFormFieldsMap, DDMFormFieldValue ddmFormFieldValue) {
        if (jsonArray == null || jsonArray.length() == 0) {
            return;
        }
        List<DDMFormFieldValue> nestedDDMFormFieldValues = this.getDDMFormFieldValues(jsonArray, ddmFormFieldsMap);
        ddmFormFieldValue.setNestedDDMFormFields(nestedDDMFormFieldValues);
    }
}

