/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.impl;

import com.liferay.dynamic.data.mapping.internal.search.util.DDMSearchHelper;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.security.permission.DDMPermissionSupport;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.dynamic.data.mapping.service.base.DDMTemplateServiceBaseImpl;
import com.liferay.dynamic.data.mapping.service.persistence.DDMTemplatePersistence;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=ddm", "json.web.service.context.path=DDMTemplate"}, service={AopService.class})
public class DDMTemplateServiceImpl
extends DDMTemplateServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(DDMTemplateServiceImpl.class);
    private static volatile ModelResourcePermission<DDMTemplate> _ddmTemplateModelResourcePermission = ModelResourcePermissionFactory.getInstance(DDMTemplateServiceImpl.class, (String)"_ddmTemplateModelResourcePermission", DDMTemplate.class);
    @Reference
    private DDMPermissionSupport _ddmPermissionSupport;
    @Reference
    private DDMSearchHelper _ddmSearchHelper;
    @Reference
    private Portal _portal;

    public DDMTemplate addTemplate(long groupId, long classNameId, long classPK, long resourceClassNameId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, String mode, String language, String script, ServiceContext serviceContext) throws PortalException {
        this._ddmPermissionSupport.checkAddTemplatePermission(this.getPermissionChecker(), groupId, classNameId, resourceClassNameId);
        return this.ddmTemplateLocalService.addTemplate(this.getUserId(), groupId, classNameId, classPK, resourceClassNameId, null, nameMap, descriptionMap, type, mode, language, script, false, false, null, null, serviceContext);
    }

    public DDMTemplate addTemplate(long groupId, long classNameId, long classPK, long resourceClassNameId, String templateKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, String mode, String language, String script, boolean cacheable, boolean smallImage, String smallImageURL, File smallImageFile, ServiceContext serviceContext) throws PortalException {
        this._ddmPermissionSupport.checkAddTemplatePermission(this.getPermissionChecker(), groupId, classNameId, resourceClassNameId);
        return this.ddmTemplateLocalService.addTemplate(this.getUserId(), groupId, classNameId, classPK, resourceClassNameId, templateKey, nameMap, descriptionMap, type, mode, language, script, cacheable, smallImage, smallImageURL, smallImageFile, serviceContext);
    }

    public DDMTemplate copyTemplate(long templateId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, ServiceContext serviceContext) throws PortalException {
        DDMTemplate template = this.ddmTemplatePersistence.findByPrimaryKey(templateId);
        this._ddmPermissionSupport.checkAddTemplatePermission(this.getPermissionChecker(), serviceContext.getScopeGroupId(), template.getClassNameId(), template.getResourceClassName());
        return this.ddmTemplateLocalService.copyTemplate(this.getUserId(), templateId, nameMap, descriptionMap, serviceContext);
    }

    public DDMTemplate copyTemplate(long templateId, ServiceContext serviceContext) throws PortalException {
        DDMTemplate template = this.ddmTemplatePersistence.findByPrimaryKey(templateId);
        this._ddmPermissionSupport.checkAddTemplatePermission(this.getPermissionChecker(), serviceContext.getScopeGroupId(), template.getClassNameId(), template.getResourceClassName());
        return this.ddmTemplateLocalService.copyTemplate(this.getUserId(), templateId, serviceContext);
    }

    public List<DDMTemplate> copyTemplates(long classNameId, long oldClassPK, long resourceClassNameId, long newClassPK, String type, ServiceContext serviceContext) throws PortalException {
        this._ddmPermissionSupport.checkAddTemplatePermission(this.getPermissionChecker(), serviceContext.getScopeGroupId(), classNameId, resourceClassNameId);
        return this.ddmTemplateLocalService.copyTemplates(this.getUserId(), classNameId, oldClassPK, newClassPK, type, serviceContext);
    }

    public void deleteTemplate(long templateId) throws PortalException {
        _ddmTemplateModelResourcePermission.check(this.getPermissionChecker(), templateId, "DELETE");
        this.ddmTemplateLocalService.deleteTemplate(templateId);
    }

    public DDMTemplate fetchTemplate(long groupId, long classNameId, String templateKey) throws PortalException {
        DDMTemplate ddmTemplate = this.ddmTemplateLocalService.fetchTemplate(groupId, classNameId, templateKey);
        if (ddmTemplate != null) {
            _ddmTemplateModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)ddmTemplate, "VIEW");
        }
        return ddmTemplate;
    }

    public DDMTemplate getTemplate(long templateId) throws PortalException {
        _ddmTemplateModelResourcePermission.check(this.getPermissionChecker(), templateId, "VIEW");
        return this.ddmTemplatePersistence.findByPrimaryKey(templateId);
    }

    public DDMTemplate getTemplate(long groupId, long classNameId, String templateKey) throws PortalException {
        DDMTemplate ddmTemplate = this.ddmTemplateLocalService.getTemplate(groupId, classNameId, templateKey);
        _ddmTemplateModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)ddmTemplate, "VIEW");
        return ddmTemplate;
    }

    public DDMTemplate getTemplate(long groupId, long classNameId, String templateKey, boolean includeAncestorTemplates) throws PortalException {
        DDMTemplate ddmTemplate = this.ddmTemplateLocalService.getTemplate(groupId, classNameId, templateKey, includeAncestorTemplates);
        _ddmTemplateModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)ddmTemplate, "VIEW");
        return ddmTemplate;
    }

    public List<DDMTemplate> getTemplates(long companyId, long groupId, long classNameId, long resourceClassNameId, int status) {
        return this.getTemplates(companyId, new long[]{groupId}, classNameId, 0L, resourceClassNameId, null, null, status);
    }

    public List<DDMTemplate> getTemplates(long companyId, long groupId, long classNameId, long classPK, long resourceClassNameId, boolean includeAncestorTemplates, int status) throws PortalException {
        ArrayList<DDMTemplate> ddmTemplates = new ArrayList<DDMTemplate>();
        ddmTemplates.addAll(this.getTemplates(companyId, new long[]{groupId}, classNameId, classPK, resourceClassNameId, null, null, status));
        if (!includeAncestorTemplates) {
            return ddmTemplates;
        }
        ddmTemplates.addAll(this.getTemplates(companyId, this._portal.getAncestorSiteGroupIds(groupId), classNameId, classPK, resourceClassNameId, null, null, status));
        return ddmTemplates;
    }

    public List<DDMTemplate> getTemplates(long companyId, long groupId, long classNameId, long classPK, long resourceClassNameId, int status) {
        return this.getTemplates(companyId, new long[]{groupId}, classNameId, classPK, resourceClassNameId, null, null, status);
    }

    public List<DDMTemplate> getTemplates(long companyId, long groupId, long classNameId, long classPK, long resourceClassNameId, String type, int status) {
        return this.getTemplates(companyId, new long[]{groupId}, classNameId, classPK, resourceClassNameId, type, null, status);
    }

    public List<DDMTemplate> getTemplates(long companyId, long groupId, long classNameId, long classPK, long resourceClassNameId, String type, String mode, int status) {
        return this.getTemplates(companyId, new long[]{groupId}, classNameId, classPK, resourceClassNameId, type, mode, status);
    }

    public List<DDMTemplate> getTemplatesByClassPK(long companyId, long groupId, long classPK, long resourceClassNameId, int status) {
        return this.getTemplates(companyId, new long[]{groupId}, 0L, classPK, resourceClassNameId, null, null, status);
    }

    public List<DDMTemplate> getTemplatesByStructureClassNameId(long groupId, long structureClassNameId, int status, int start, int end, OrderByComparator<DDMTemplate> orderByComparator) {
        return this.ddmTemplateFinder.filterFindByG_SC_S(groupId, structureClassNameId, status, start, end, orderByComparator);
    }

    public int getTemplatesByStructureClassNameIdCount(long groupId, long structureClassNameId, int status) {
        return this.ddmTemplateFinder.filterCountByG_SC_S(groupId, structureClassNameId, status);
    }

    public void revertTemplate(long templateId, String version, ServiceContext serviceContext) throws PortalException {
        _ddmTemplateModelResourcePermission.check(this.getPermissionChecker(), templateId, "UPDATE");
        this.ddmTemplateLocalService.revertTemplate(this.getUserId(), templateId, version, serviceContext);
    }

    public List<DDMTemplate> search(long companyId, long groupId, long classNameId, long classPK, long resourceClassNameId, String keywords, String type, String mode, int status, int start, int end, OrderByComparator<DDMTemplate> orderByComparator) {
        try {
            SearchContext searchContext = this._ddmSearchHelper.buildTemplateSearchContext(companyId, groupId, this.getUserId(), classNameId, classPK, resourceClassNameId, keywords, keywords, type, mode, null, status, start, end, orderByComparator);
            return this._ddmSearchHelper.doSearch(searchContext, DDMTemplate.class, arg_0 -> ((DDMTemplatePersistence)this.ddmTemplatePersistence).findByPrimaryKey(arg_0));
        }
        catch (PrincipalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return Collections.emptyList();
        }
    }

    public List<DDMTemplate> search(long companyId, long groupId, long classNameId, long classPK, long resourceClassNameId, String name, String description, String type, String mode, String language, int status, boolean andOperator, int start, int end, OrderByComparator<DDMTemplate> orderByComparator) {
        try {
            SearchContext searchContext = this._ddmSearchHelper.buildTemplateSearchContext(companyId, groupId, this.getUserId(), classNameId, classPK, resourceClassNameId, name, description, type, mode, language, status, start, end, orderByComparator);
            return this._ddmSearchHelper.doSearch(searchContext, DDMTemplate.class, arg_0 -> ((DDMTemplatePersistence)this.ddmTemplatePersistence).findByPrimaryKey(arg_0));
        }
        catch (PrincipalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return Collections.emptyList();
        }
    }

    public List<DDMTemplate> search(long companyId, long[] groupIds, long[] classNameIds, long[] classPKs, long resourceClassNameId, String keywords, String type, String mode, int status, int start, int end, OrderByComparator<DDMTemplate> orderByComparator) {
        try {
            SearchContext searchContext = this._ddmSearchHelper.buildTemplateSearchContext(companyId, groupIds, this.getUserId(), classNameIds, classPKs, resourceClassNameId, keywords, keywords, type, mode, null, status, start, end, orderByComparator);
            return this._ddmSearchHelper.doSearch(searchContext, DDMTemplate.class, arg_0 -> ((DDMTemplateLocalService)this.ddmTemplateLocalService).fetchTemplate(arg_0));
        }
        catch (PrincipalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return Collections.emptyList();
        }
    }

    public List<DDMTemplate> search(long companyId, long[] groupIds, long[] classNameIds, long[] classPKs, long resourceClassNameId, String name, String description, String type, String mode, String language, int status, boolean andOperator, int start, int end, OrderByComparator<DDMTemplate> orderByComparator) {
        try {
            SearchContext searchContext = this._ddmSearchHelper.buildTemplateSearchContext(companyId, groupIds, this.getUserId(), classNameIds, classPKs, resourceClassNameId, name, description, type, mode, language, status, start, end, orderByComparator);
            return this._ddmSearchHelper.doSearch(searchContext, DDMTemplate.class, arg_0 -> ((DDMTemplatePersistence)this.ddmTemplatePersistence).findByPrimaryKey(arg_0));
        }
        catch (PrincipalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return Collections.emptyList();
        }
    }

    public int searchCount(long companyId, long groupId, long classNameId, long classPK, long resourceClassNameId, String keywords, String type, String mode, int status) {
        try {
            SearchContext searchContext = this._ddmSearchHelper.buildTemplateSearchContext(companyId, groupId, this.getUserId(), classNameId, classPK, resourceClassNameId, keywords, keywords, type, mode, null, status, -1, -1, null);
            return this._ddmSearchHelper.doSearchCount(searchContext, DDMTemplate.class);
        }
        catch (PrincipalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return 0;
        }
    }

    public int searchCount(long companyId, long groupId, long classNameId, long classPK, long resourceClassNameId, String name, String description, String type, String mode, String language, int status, boolean andOperator) {
        try {
            SearchContext searchContext = this._ddmSearchHelper.buildTemplateSearchContext(companyId, groupId, this.getUserId(), classNameId, classPK, resourceClassNameId, name, description, type, mode, null, status, -1, -1, null);
            return this._ddmSearchHelper.doSearchCount(searchContext, DDMTemplate.class);
        }
        catch (PrincipalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return 0;
        }
    }

    public int searchCount(long companyId, long[] groupIds, long[] classNameIds, long[] classPKs, long resourceClassNameId, String keywords, String type, String mode, int status) {
        try {
            SearchContext searchContext = this._ddmSearchHelper.buildTemplateSearchContext(companyId, groupIds, this.getUserId(), classNameIds, classPKs, resourceClassNameId, keywords, keywords, type, mode, null, status, -1, -1, null);
            return this._ddmSearchHelper.doSearchCount(searchContext, DDMTemplate.class);
        }
        catch (PrincipalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return 0;
        }
    }

    public int searchCount(long companyId, long[] groupIds, long[] classNameIds, long[] classPKs, long resourceClassNameId, String name, String description, String type, String mode, String language, int status, boolean andOperator) {
        try {
            SearchContext searchContext = this._ddmSearchHelper.buildTemplateSearchContext(companyId, groupIds, this.getUserId(), classNameIds, classPKs, resourceClassNameId, name, description, type, mode, language, status, -1, -1, null);
            return this._ddmSearchHelper.doSearchCount(searchContext, DDMTemplate.class);
        }
        catch (PrincipalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return 0;
        }
    }

    public DDMTemplate updateTemplate(long templateId, long classPK, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, String mode, String language, String script, boolean cacheable, boolean smallImage, String smallImageURL, File smallImageFile, ServiceContext serviceContext) throws PortalException {
        _ddmTemplateModelResourcePermission.check(this.getPermissionChecker(), templateId, "UPDATE");
        return this.ddmTemplateLocalService.updateTemplate(this.getUserId(), templateId, classPK, nameMap, descriptionMap, type, mode, language, script, cacheable, smallImage, smallImageURL, smallImageFile, serviceContext);
    }

    public DDMTemplate updateTemplate(long templateId, long classPK, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, String mode, String language, String script, boolean cacheable, ServiceContext serviceContext) throws PortalException {
        _ddmTemplateModelResourcePermission.check(this.getPermissionChecker(), templateId, "UPDATE");
        return this.ddmTemplateLocalService.updateTemplate(this.getUserId(), templateId, classPK, nameMap, descriptionMap, type, mode, language, script, cacheable, serviceContext);
    }

    protected List<DDMTemplate> getTemplates(long companyId, long[] groupIds, long classNameId, long classPK, long resourceClassNameId, String type, String mode, int status) {
        return this.ddmTemplateFinder.filterFindByC_G_C_C_R_T_M_S(companyId, groupIds, classNameId, classPK, resourceClassNameId, type, mode, status, -1, -1, null);
    }
}

