/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.search.spi.model.index.contributor;

import com.liferay.dynamic.data.mapping.model.DDMStructureLayout;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.dynamic.data.mapping.model.DDMStructureLayout"}, service={ModelDocumentContributor.class})
public class DDMStructureLayoutModelDocumentContributor
implements ModelDocumentContributor<DDMStructureLayout> {
    @Reference
    protected ClassNameLocalService classNameLocalService;

    public void contribute(Document document, DDMStructureLayout ddmStructureLayout) {
        String[] nameLanguageIds;
        String[] descriptionLanguageIds;
        document.addKeyword("classNameId", this.classNameLocalService.getClassNameId(DDMStructureLayout.class));
        Locale defaultLocale = LocaleUtil.getSiteDefault();
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)defaultLocale);
        for (String descriptionLanguageId : descriptionLanguageIds = this.getLanguageIds(defaultLanguageId, ddmStructureLayout.getDescription())) {
            document.addText(LocalizationUtil.getLocalizedName((String)"description", (String)descriptionLanguageId), ddmStructureLayout.getDescription(descriptionLanguageId));
        }
        for (String nameLanguageId : nameLanguageIds = this.getLanguageIds(defaultLanguageId, ddmStructureLayout.getName())) {
            document.addText(LocalizationUtil.getLocalizedName((String)"name", (String)nameLanguageId), ddmStructureLayout.getName(nameLanguageId));
        }
        document.addLocalizedKeyword("localized_name", LocalizationUtil.populateLocalizationMap((Map)ddmStructureLayout.getNameMap(), (String)ddmStructureLayout.getDefaultLanguageId(), (long)ddmStructureLayout.getGroupId()), true, true);
        document.addKeyword("structureVersionId", ddmStructureLayout.getStructureVersionId());
    }

    protected String[] getLanguageIds(String defaultLanguageId, String content) {
        String[] languageIds = LocalizationUtil.getAvailableLanguageIds((String)content);
        if (languageIds.length == 0) {
            languageIds = new String[]{defaultLanguageId};
        }
        return languageIds;
    }
}

