/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.impl;

import com.liferay.dynamic.data.mapping.exception.NoSuchFormInstanceVersionException;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceVersion;
import com.liferay.dynamic.data.mapping.service.base.DDMFormInstanceVersionLocalServiceBaseImpl;
import com.liferay.dynamic.data.mapping.util.comparator.FormInstanceVersionVersionComparator;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.Collections;
import java.util.List;

public class DDMFormInstanceVersionLocalServiceImpl
extends DDMFormInstanceVersionLocalServiceBaseImpl {
    public void deleteByFormInstanceId(long ddmFormInstanceId) {
        this.ddmFormInstanceVersionPersistence.removeByFormInstanceId(ddmFormInstanceId);
    }

    public DDMFormInstanceVersion getFormInstanceVersion(long ddmFormInstanceVersionId) throws PortalException {
        return this.ddmFormInstanceVersionPersistence.findByPrimaryKey(ddmFormInstanceVersionId);
    }

    public DDMFormInstanceVersion getFormInstanceVersion(long ddmFormInstanceId, String version) throws PortalException {
        return this.ddmFormInstanceVersionPersistence.findByF_V(ddmFormInstanceId, version);
    }

    public List<DDMFormInstanceVersion> getFormInstanceVersions(long ddmFormInstanceId) {
        return this.ddmFormInstanceVersionPersistence.findByFormInstanceId(ddmFormInstanceId);
    }

    public List<DDMFormInstanceVersion> getFormInstanceVersions(long ddmFormInstanceId, int start, int end, OrderByComparator<DDMFormInstanceVersion> orderByComparator) {
        return this.ddmFormInstanceVersionPersistence.findByFormInstanceId(ddmFormInstanceId, start, end, orderByComparator);
    }

    public int getFormInstanceVersionsCount(long ddmFormInstanceId) {
        return this.ddmFormInstanceVersionPersistence.countByFormInstanceId(ddmFormInstanceId);
    }

    public DDMFormInstanceVersion getLatestFormInstanceVersion(long ddmFormInstanceId) throws PortalException {
        List ddmFormInstanceVersions = this.ddmFormInstanceVersionPersistence.findByFormInstanceId(ddmFormInstanceId);
        if (ddmFormInstanceVersions.isEmpty()) {
            throw new NoSuchFormInstanceVersionException("No form instance versions found for form instance ID " + ddmFormInstanceId);
        }
        ddmFormInstanceVersions = ListUtil.copy((List)ddmFormInstanceVersions);
        Collections.sort(ddmFormInstanceVersions, new FormInstanceVersionVersionComparator());
        return (DDMFormInstanceVersion)ddmFormInstanceVersions.get(0);
    }

    public DDMFormInstanceVersion getLatestFormInstanceVersion(long formInstanceId, int status) throws PortalException {
        List formInstanceVersions = this.ddmFormInstanceVersionPersistence.findByF_S(formInstanceId, status);
        if (formInstanceVersions.isEmpty()) {
            throw new NoSuchFormInstanceVersionException(StringBundler.concat((Object[])new Object[]{"No form instance versions found for form instance ID ", formInstanceId, " with status ", status}));
        }
        formInstanceVersions = ListUtil.copy((List)formInstanceVersions);
        Collections.sort(formInstanceVersions, new FormInstanceVersionVersionComparator());
        return (DDMFormInstanceVersion)formInstanceVersions.get(0);
    }
}

