/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.impl;

import com.liferay.dynamic.data.mapping.exception.DataProviderInstanceNameException;
import com.liferay.dynamic.data.mapping.exception.NoSuchDataProviderInstanceException;
import com.liferay.dynamic.data.mapping.exception.RequiredDataProviderInstanceException;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializerTracker;
import com.liferay.dynamic.data.mapping.model.DDMDataProviderInstance;
import com.liferay.dynamic.data.mapping.service.base.DDMDataProviderInstanceLocalServiceBaseImpl;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.validator.DDMFormValuesValidator;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.util.GroupThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DDMDataProviderInstanceLocalServiceImpl
extends DDMDataProviderInstanceLocalServiceBaseImpl {
    @ServiceReference(type=DDMFormValuesSerializerTracker.class)
    protected DDMFormValuesSerializerTracker ddmFormValuesSerializerTracker;
    @ServiceReference(type=DDMFormValuesValidator.class)
    protected DDMFormValuesValidator ddmFormValuesValidator;

    public DDMDataProviderInstance addDataProviderInstance(long userId, long groupId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, DDMFormValues ddmFormValues, String type, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        this.validate(nameMap, ddmFormValues);
        long dataProviderInstanceId = this.counterLocalService.increment();
        DDMDataProviderInstance dataProviderInstance = this.ddmDataProviderInstancePersistence.create(dataProviderInstanceId);
        dataProviderInstance.setUuid(serviceContext.getUuid());
        dataProviderInstance.setGroupId(groupId);
        dataProviderInstance.setCompanyId(user.getCompanyId());
        dataProviderInstance.setUserId(user.getUserId());
        dataProviderInstance.setUserName(user.getFullName());
        dataProviderInstance.setNameMap(nameMap);
        dataProviderInstance.setDescriptionMap(descriptionMap);
        dataProviderInstance.setDefinition(this.serialize(ddmFormValues));
        dataProviderInstance.setType(type);
        this.ddmDataProviderInstancePersistence.update((BaseModel)dataProviderInstance);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addDataProviderInstanceResources(dataProviderInstance, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addDataProviderInstanceResources(dataProviderInstance, serviceContext.getModelPermissions());
        }
        return dataProviderInstance;
    }

    public void deleteDataProviderInstance(DDMDataProviderInstance dataProviderInstance) throws PortalException {
        if (!GroupThreadLocal.isDeleteInProcess() && this.ddmDataProviderInstanceLinkPersistence.countByDataProviderInstanceId(dataProviderInstance.getDataProviderInstanceId()) > 0) {
            throw new RequiredDataProviderInstanceException.MustNotDeleteDataProviderInstanceReferencedByDataProviderInstanceLinks(dataProviderInstance.getDataProviderInstanceId());
        }
        this.ddmDataProviderInstancePersistence.remove((BaseModel)dataProviderInstance);
        this.resourceLocalService.deleteResource(dataProviderInstance.getCompanyId(), DDMDataProviderInstance.class.getName(), 4, dataProviderInstance.getDataProviderInstanceId());
    }

    public void deleteDataProviderInstance(long dataProviderInstanceId) throws PortalException {
        DDMDataProviderInstance dataProviderInstance = this.ddmDataProviderInstancePersistence.findByPrimaryKey(dataProviderInstanceId);
        this.ddmDataProviderInstanceLocalService.deleteDataProviderInstance(dataProviderInstance);
    }

    public void deleteDataProviderInstances(long companyId, long groupId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this.ddmDataProviderInstanceLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property groupIdProperty = PropertyFactoryUtil.forName((String)"groupId");
            dynamicQuery.add(groupIdProperty.eq((Object)groupId));
        });
        actionableDynamicQuery.setPerformActionMethod(ddmDataProviderInstance -> this.deleteDataProviderInstance((DDMDataProviderInstance)ddmDataProviderInstance));
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.performActions();
    }

    public DDMDataProviderInstance fetchDataProviderInstance(long dataProviderInstanceId) {
        return this.ddmDataProviderInstancePersistence.fetchByPrimaryKey(dataProviderInstanceId);
    }

    public DDMDataProviderInstance fetchDataProviderInstanceByUuid(String uuid) {
        List ddmDataProviderInstances = this.ddmDataProviderInstancePersistence.findByUuid(uuid);
        if (ddmDataProviderInstances.isEmpty()) {
            return null;
        }
        return (DDMDataProviderInstance)ddmDataProviderInstances.get(0);
    }

    public DDMDataProviderInstance getDataProviderInstance(long dataProviderInstanceId) throws PortalException {
        return this.ddmDataProviderInstancePersistence.findByPrimaryKey(dataProviderInstanceId);
    }

    public DDMDataProviderInstance getDataProviderInstanceByUuid(String uuid) throws PortalException {
        List ddmDataProviderInstances = this.ddmDataProviderInstancePersistence.findByUuid(uuid);
        if (ddmDataProviderInstances.isEmpty()) {
            throw new NoSuchDataProviderInstanceException("No DataProviderInstance found with uuid: " + uuid);
        }
        return (DDMDataProviderInstance)ddmDataProviderInstances.get(0);
    }

    public List<DDMDataProviderInstance> getDataProviderInstances(long[] groupIds) {
        return this.ddmDataProviderInstancePersistence.findByGroupId(groupIds);
    }

    public List<DDMDataProviderInstance> getDataProviderInstances(long[] groupIds, int start, int end) {
        return this.ddmDataProviderInstancePersistence.findByGroupId(groupIds, start, end);
    }

    public List<DDMDataProviderInstance> getDataProviderInstances(long[] groupIds, int start, int end, OrderByComparator<DDMDataProviderInstance> orderByComparator) {
        return this.ddmDataProviderInstancePersistence.findByGroupId(groupIds, start, end, orderByComparator);
    }

    public List<DDMDataProviderInstance> search(long companyId, long[] groupIds, String keywords, int start, int end, OrderByComparator<DDMDataProviderInstance> orderByComparator) {
        return this.ddmDataProviderInstanceFinder.findByKeywords(companyId, groupIds, keywords, start, end, orderByComparator);
    }

    public List<DDMDataProviderInstance> search(long companyId, long[] groupIds, String name, String description, boolean andOperator, int start, int end, OrderByComparator<DDMDataProviderInstance> orderByComparator) {
        return this.ddmDataProviderInstanceFinder.findByC_G_N_D(companyId, groupIds, name, description, andOperator, start, end, orderByComparator);
    }

    public int searchCount(long companyId, long[] groupIds, String keywords) {
        return this.ddmDataProviderInstanceFinder.countByKeywords(companyId, groupIds, keywords);
    }

    public int searchCount(long companyId, long[] groupIds, String name, String description, boolean andOperator) {
        return this.ddmDataProviderInstanceFinder.countByC_G_N_D(companyId, groupIds, name, description, andOperator);
    }

    public DDMDataProviderInstance updateDataProviderInstance(long userId, long dataProviderInstanceId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, DDMFormValues ddmFormValues, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        this.validate(nameMap, ddmFormValues);
        DDMDataProviderInstance dataProviderInstance = this.ddmDataProviderInstancePersistence.findByPrimaryKey(dataProviderInstanceId);
        dataProviderInstance.setUserId(user.getUserId());
        dataProviderInstance.setUserName(user.getFullName());
        dataProviderInstance.setNameMap(nameMap);
        dataProviderInstance.setDescriptionMap(descriptionMap);
        dataProviderInstance.setDefinition(this.serialize(ddmFormValues));
        this.ddmDataProviderInstancePersistence.update((BaseModel)dataProviderInstance);
        return dataProviderInstance;
    }

    protected void addDataProviderInstanceResources(DDMDataProviderInstance dataProviderInstance, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this.resourceLocalService.addResources(dataProviderInstance.getCompanyId(), dataProviderInstance.getGroupId(), dataProviderInstance.getUserId(), DDMDataProviderInstance.class.getName(), dataProviderInstance.getDataProviderInstanceId(), false, addGroupPermissions, addGuestPermissions);
    }

    protected void addDataProviderInstanceResources(DDMDataProviderInstance dataProviderInstance, ModelPermissions modelPermissions) throws PortalException {
        this.resourceLocalService.addModelResources(dataProviderInstance.getCompanyId(), dataProviderInstance.getGroupId(), dataProviderInstance.getUserId(), DDMDataProviderInstance.class.getName(), dataProviderInstance.getDataProviderInstanceId(), modelPermissions);
    }

    protected String serialize(DDMFormValues ddmFormValues) {
        DDMFormValuesSerializer ddmFormValuesSerializer = this.ddmFormValuesSerializerTracker.getDDMFormValuesSerializer("json");
        DDMFormValuesSerializerSerializeRequest.Builder builder = DDMFormValuesSerializerSerializeRequest.Builder.newBuilder((DDMFormValues)ddmFormValues);
        DDMFormValuesSerializerSerializeResponse ddmFormValuesSerializerSerializeResponse = ddmFormValuesSerializer.serialize(builder.build());
        return ddmFormValuesSerializerSerializeResponse.getContent();
    }

    protected void validate(Map<Locale, String> nameMap, DDMFormValues ddmFormValues) throws PortalException {
        Locale locale = LocaleUtil.getSiteDefault();
        String name = nameMap.get(locale);
        if (Validator.isNull((String)name)) {
            throw new DataProviderInstanceNameException("Name is null for locale " + locale.getDisplayName());
        }
        this.ddmFormValuesValidator.validate(ddmFormValues);
    }
}

