/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.webdav;

import com.liferay.dynamic.data.mapping.internal.webdav.DDMStructureResourceImpl;
import com.liferay.dynamic.data.mapping.internal.webdav.DDMTemplateResourceImpl;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerTracker;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateService;
import com.liferay.dynamic.data.mapping.storage.StorageType;
import com.liferay.dynamic.data.mapping.util.DDM;
import com.liferay.dynamic.data.mapping.util.DDMXML;
import com.liferay.dynamic.data.mapping.webdav.DDMWebDAV;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.webdav.BaseResourceImpl;
import com.liferay.portal.kernel.webdav.Resource;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.WebDAVRequest;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DDMWebDAV.class})
public class DDMWebDAVImpl
implements DDMWebDAV {
    private static final Log _log = LogFactoryUtil.getLog(DDMWebDAVImpl.class);
    private DDM _ddm;
    private DDMFormDeserializerTracker _ddmFormDeserializerTracker;
    private DDMStructureLocalService _ddmStructureLocalService;
    private DDMStructureService _ddmStructureService;
    private DDMTemplateLocalService _ddmTemplateLocalService;
    private DDMTemplateService _ddmTemplateService;
    private DDMXML _ddmXML;

    public int addResource(WebDAVRequest webDAVRequest, long classNameId) throws Exception {
        String[] pathArray = webDAVRequest.getPathArray();
        if (pathArray.length != 4) {
            return 403;
        }
        String type = pathArray[2];
        if (type.equals("Structures")) {
            HttpServletRequest httpServletRequest = webDAVRequest.getHttpServletRequest();
            String definition = StringUtil.read((InputStream)httpServletRequest.getInputStream());
            DDMForm ddmForm = this.getDDMForm(definition);
            DDMFormLayout ddmFormLayout = this._ddm.getDefaultDDMFormLayout(ddmForm);
            HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
            Locale defaultLocale = ddmForm.getDefaultLocale();
            nameMap.put(defaultLocale, pathArray[3]);
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAddGroupPermissions(true);
            serviceContext.setAddGuestPermissions(true);
            this._ddmStructureLocalService.addStructure(webDAVRequest.getUserId(), webDAVRequest.getGroupId(), classNameId, nameMap, null, ddmForm, ddmFormLayout, StorageType.JSON.toString(), serviceContext);
            return 201;
        }
        if (type.equals("Templates")) {
            return 403;
        }
        return 403;
    }

    public int deleteResource(WebDAVRequest webDAVRequest, String rootPath, String token, long classNameId) throws WebDAVException {
        try {
            Resource resource = this.getResource(webDAVRequest, rootPath, token, classNameId);
            if (resource == null) {
                return 404;
            }
            Object model = resource.getModel();
            if (model instanceof DDMStructure) {
                DDMStructure structure = (DDMStructure)model;
                this._ddmStructureService.deleteStructure(structure.getStructureId());
                return 204;
            }
            if (model instanceof DDMTemplate) {
                DDMTemplate template = (DDMTemplate)model;
                this._ddmTemplateService.deleteTemplate(template.getTemplateId());
                return 204;
            }
            return 403;
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return 403;
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    public Resource getResource(WebDAVRequest webDAVRequest, String rootPath, String token, long classNameId) throws WebDAVException {
        try {
            String[] pathArray = webDAVRequest.getPathArray();
            if (pathArray.length == 2) {
                String path = rootPath + webDAVRequest.getPath();
                return new BaseResourceImpl(path, "", token);
            }
            if (pathArray.length == 3) {
                String type = pathArray[2];
                return this.toResource(webDAVRequest, type, rootPath, false);
            }
            if (pathArray.length == 4) {
                String type = pathArray[2];
                String typeId = pathArray[3];
                if (type.equals("Structures")) {
                    DDMStructure structure = this._ddmStructureLocalService.fetchStructure(GetterUtil.getLong((String)typeId));
                    if (structure == null) {
                        structure = this._ddmStructureLocalService.fetchStructure(webDAVRequest.getGroupId(), classNameId, typeId);
                    }
                    if (structure == null) {
                        return null;
                    }
                    return this.toResource(webDAVRequest, structure, rootPath, false);
                }
                if (type.equals("Templates")) {
                    DDMTemplate template = this._ddmTemplateLocalService.fetchDDMTemplate(GetterUtil.getLong((String)typeId));
                    if (template == null) {
                        template = this._ddmTemplateLocalService.fetchTemplate(webDAVRequest.getGroupId(), classNameId, typeId);
                    }
                    if (template == null) {
                        return null;
                    }
                    return this.toResource(webDAVRequest, template, rootPath, false);
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    public int putResource(WebDAVRequest webDAVRequest, String rootPath, String token, long classNameId) throws WebDAVException {
        try {
            Resource resource = this.getResource(webDAVRequest, rootPath, token, classNameId);
            if (resource == null) {
                return this.addResource(webDAVRequest, classNameId);
            }
            Object model = resource.getModel();
            if (model instanceof DDMStructure) {
                DDMStructure structure = (DDMStructure)model;
                HttpServletRequest httpServletRequest = webDAVRequest.getHttpServletRequest();
                String definition = StringUtil.read((InputStream)httpServletRequest.getInputStream());
                DDMForm ddmForm = this.getDDMForm(definition);
                DDMFormLayout ddmFormLayout = this._ddm.getDefaultDDMFormLayout(ddmForm);
                this._ddmStructureService.updateStructure(structure.getGroupId(), structure.getParentStructureId(), structure.getClassNameId(), structure.getStructureKey(), structure.getNameMap(), structure.getDescriptionMap(), ddmForm, ddmFormLayout, new ServiceContext());
                return 201;
            }
            if (model instanceof DDMTemplate) {
                DDMTemplate template = (DDMTemplate)model;
                HttpServletRequest httpServletRequest = webDAVRequest.getHttpServletRequest();
                String script = StringUtil.read((InputStream)httpServletRequest.getInputStream());
                this._ddmTemplateService.updateTemplate(template.getTemplateId(), template.getClassPK(), template.getNameMap(), template.getDescriptionMap(), template.getType(), template.getMode(), template.getLanguage(), script, template.isCacheable(), template.isSmallImage(), template.getSmallImageURL(), null, new ServiceContext());
                return 201;
            }
            return 403;
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return 403;
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    public Resource toResource(WebDAVRequest webDAVRequest, DDMStructure structure, String rootPath, boolean appendPath) {
        String parentPath = rootPath + webDAVRequest.getPath();
        String name = "";
        if (appendPath) {
            name = String.valueOf(structure.getStructureId());
        }
        return new DDMStructureResourceImpl(structure, parentPath, name);
    }

    public Resource toResource(WebDAVRequest webDAVRequest, DDMTemplate template, String rootPath, boolean appendPath) {
        String parentPath = rootPath + webDAVRequest.getPath();
        String name = "";
        if (appendPath) {
            name = String.valueOf(template.getTemplateId());
        }
        return new DDMTemplateResourceImpl(template, parentPath, name);
    }

    public Resource toResource(WebDAVRequest webDAVRequest, String type, String rootPath, boolean appendPath) {
        String parentPath = rootPath + webDAVRequest.getPath();
        String name = "";
        if (appendPath) {
            name = type;
        }
        BaseResourceImpl resource = new BaseResourceImpl(parentPath, name, type);
        resource.setModel((Object)type);
        return resource;
    }

    protected DDMForm getDDMForm(String definition) throws PortalException {
        this._ddmXML.validateXML(definition);
        DDMFormDeserializer ddmFormDeserializer = this._ddmFormDeserializerTracker.getDDMFormDeserializer("xsd");
        DDMFormDeserializerDeserializeRequest.Builder builder = DDMFormDeserializerDeserializeRequest.Builder.newBuilder((String)definition);
        DDMFormDeserializerDeserializeResponse ddmFormDeserializerDeserializeResponse = ddmFormDeserializer.deserialize(builder.build());
        return ddmFormDeserializerDeserializeResponse.getDDMForm();
    }

    @Reference(unbind="-")
    protected void setDDM(DDM ddm) {
        this._ddm = ddm;
    }

    @Reference(unbind="-")
    protected void setDDMFormDeserializerTracker(DDMFormDeserializerTracker ddmFormDeserializerTracker) {
        this._ddmFormDeserializerTracker = ddmFormDeserializerTracker;
    }

    @Reference(unbind="-")
    protected void setDDMStructureLocalService(DDMStructureLocalService ddmStructureLocalService) {
        this._ddmStructureLocalService = ddmStructureLocalService;
    }

    @Reference(unbind="-")
    protected void setDDMStructureService(DDMStructureService ddmStructureService) {
        this._ddmStructureService = ddmStructureService;
    }

    @Reference(unbind="-")
    protected void setDDMTemplateLocalService(DDMTemplateLocalService ddmTemplateLocalService) {
        this._ddmTemplateLocalService = ddmTemplateLocalService;
    }

    @Reference(unbind="-")
    protected void setDDMTemplateService(DDMTemplateService ddmTemplateService) {
        this._ddmTemplateService = ddmTemplateService;
    }

    @Reference(unbind="-")
    protected void setDDMXML(DDMXML ddmXML) {
        this._ddmXML = ddmXML;
    }
}

