/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.search.spi.model.index.contributor;

import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.model.DDMTemplateVersion;
import com.liferay.dynamic.data.mapping.service.DDMTemplateVersionLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.dynamic.data.mapping.model.DDMTemplate"}, service={ModelDocumentContributor.class})
public class DDMTemplateModelDocumentContributor
implements ModelDocumentContributor<DDMTemplate> {
    @Reference
    protected DDMTemplateVersionLocalService ddmTemplateVersionLocalService;
    private static final Log _log = LogFactoryUtil.getLog(DDMTemplateModelDocumentContributor.class);

    public void contribute(Document document, DDMTemplate ddmTemplate) {
        String[] nameLanguageIds;
        String[] descriptionLanguageIds;
        block4: {
            document.addKeyword("classNameId", ddmTemplate.getClassNameId());
            document.addKeyword("classPK", ddmTemplate.getClassPK());
            document.addKeyword("resourceClassNameId", ddmTemplate.getResourceClassNameId());
            try {
                DDMTemplateVersion templateVersion = this.ddmTemplateVersionLocalService.getTemplateVersion(ddmTemplate.getTemplateId(), ddmTemplate.getVersion());
                document.addKeyword("status", templateVersion.getStatus());
                document.addKeyword("version", templateVersion.getVersion());
            }
            catch (PortalException pe) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Object)pe, (Throwable)pe);
            }
        }
        document.addKeyword("language", ddmTemplate.getLanguage());
        document.addKeyword("mode", ddmTemplate.getMode());
        document.addKeyword("type", ddmTemplate.getType());
        Locale defaultLocale = LocaleUtil.getSiteDefault();
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)defaultLocale);
        for (String descriptionLanguageId : descriptionLanguageIds = this.getLanguageIds(defaultLanguageId, ddmTemplate.getDescription())) {
            document.addText(LocalizationUtil.getLocalizedName((String)"description", (String)descriptionLanguageId), ddmTemplate.getDescription(descriptionLanguageId));
        }
        for (String nameLanguageId : nameLanguageIds = this.getLanguageIds(defaultLanguageId, ddmTemplate.getName())) {
            document.addText(LocalizationUtil.getLocalizedName((String)"name", (String)nameLanguageId), ddmTemplate.getName(nameLanguageId));
        }
    }

    protected String[] getLanguageIds(String defaultLanguageId, String content) {
        String[] languageIds = LocalizationUtil.getAvailableLanguageIds((String)content);
        if (languageIds.length == 0) {
            languageIds = new String[]{defaultLanguageId};
        }
        return languageIds;
    }
}

