/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.util;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureService;
import com.liferay.dynamic.data.mapping.util.DDMTemplateHelper;
import com.liferay.portal.kernel.bean.BeanParamUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.template.StringTemplateResource;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.TemplateVariableDefinition;
import com.liferay.portal.kernel.template.TemplateVariableGroup;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.template.TemplateContextHelper;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DDMTemplateHelper.class})
public class DDMTemplateHelperImpl
implements DDMTemplateHelper {
    private static final String _TEMPLATE_CONTENT = "# Placeholder";
    private static final String _TEMPLATE_ID = "0";
    private DDMStructureLocalService _ddmStructureLocalService;
    private DDMStructureService _ddmStructureService;
    private JSONFactory _jsonFactory;
    @Reference
    private Portal _portal;

    public DDMStructure fetchStructure(DDMTemplate template) {
        try {
            long classNameId = this._portal.getClassNameId(DDMStructure.class);
            if (template.getClassNameId() == classNameId) {
                return this._ddmStructureLocalService.fetchDDMStructure(template.getClassPK());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String getAutocompleteJSON(HttpServletRequest request, String language) throws Exception {
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        JSONObject typesJSONObject = this._jsonFactory.createJSONObject();
        JSONObject variablesJSONObject = this._jsonFactory.createJSONObject();
        for (TemplateVariableDefinition templateVariableDefinition : this.getAutocompleteTemplateVariableDefinitions(request, language)) {
            Class clazz = templateVariableDefinition.getClazz();
            if (clazz == null) {
                variablesJSONObject.put(templateVariableDefinition.getName(), "");
                continue;
            }
            if (!typesJSONObject.has(clazz.getName())) {
                typesJSONObject.put(clazz.getName(), this.getAutocompleteClassJSONObject(clazz));
            }
            variablesJSONObject.put(templateVariableDefinition.getName(), this.getAutocompleteVariableJSONObject(clazz));
        }
        jsonObject.put("types", typesJSONObject);
        jsonObject.put("variables", variablesJSONObject);
        return jsonObject.toString();
    }

    public boolean isAutocompleteEnabled(String language) {
        return language.equals("ftl") || language.equals("vm");
    }

    protected JSONObject getAutocompleteClassJSONObject(Class<?> clazz) {
        JSONObject typeJSONObject = this._jsonFactory.createJSONObject();
        for (Field field : clazz.getFields()) {
            JSONObject fieldJSONObject = this.getAutocompleteVariableJSONObject(field.getType());
            typeJSONObject.put(field.getName(), fieldJSONObject);
        }
        for (AccessibleObject accessibleObject : clazz.getMethods()) {
            Class<?>[] parameterTypes;
            JSONObject methodJSONObject = this._jsonFactory.createJSONObject();
            JSONArray parametersTypesArray = this._jsonFactory.createJSONArray();
            for (Class<?> parameterType : parameterTypes = ((Method)accessibleObject).getParameterTypes()) {
                parametersTypesArray.put(parameterType.getCanonicalName());
            }
            methodJSONObject.put("argumentTypes", parametersTypesArray);
            Class<?> returnTypeClass = ((Method)accessibleObject).getReturnType();
            methodJSONObject.put("returnType", returnTypeClass.getName());
            methodJSONObject.put("type", "Method");
            typeJSONObject.put(((Method)accessibleObject).getName(), methodJSONObject);
        }
        return typeJSONObject;
    }

    protected List<TemplateVariableDefinition> getAutocompleteTemplateVariableDefinitions(HttpServletRequest request, String language) throws Exception {
        if (!this.isAutocompleteEnabled(language)) {
            return Collections.emptyList();
        }
        LinkedHashSet<TemplateVariableDefinition> templateVariableDefinitions = new LinkedHashSet<TemplateVariableDefinition>();
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        DDMTemplate ddmTemplate = (DDMTemplate)request.getAttribute("DYNAMIC_DATA_MAPPING_TEMPLATE");
        long classPK = BeanParamUtil.getLong((Object)ddmTemplate, (HttpServletRequest)request, (String)"classPK");
        long classNameId = BeanParamUtil.getLong((Object)ddmTemplate, (HttpServletRequest)request, (String)"classNameId");
        if (classPK > 0L) {
            DDMStructure ddmStructure = this._ddmStructureService.getStructure(classPK);
            classNameId = ddmStructure.getClassNameId();
        } else if (ddmTemplate != null) {
            classNameId = ddmTemplate.getClassNameId();
        }
        Map templateVariableGroups = TemplateContextHelper.getTemplateVariableGroups((long)classNameId, (long)classPK, (String)language, (Locale)themeDisplay.getLocale());
        for (TemplateVariableGroup templateVariableGroup : templateVariableGroups.values()) {
            if (!templateVariableGroup.isAutocompleteEnabled()) continue;
            templateVariableDefinitions.addAll(templateVariableGroup.getTemplateVariableDefinitions());
        }
        StringTemplateResource templateResource = new StringTemplateResource(_TEMPLATE_ID, _TEMPLATE_CONTENT);
        Template template = TemplateManagerUtil.getTemplate((String)language, (TemplateResource)templateResource, (boolean)false);
        for (String key : template.keySet()) {
            Object value = template.get((Object)key);
            if (value == null) continue;
            TemplateVariableDefinition variableDefinition = new TemplateVariableDefinition(key, value.getClass(), key, (String)null);
            templateVariableDefinitions.add(variableDefinition);
        }
        return new ArrayList<TemplateVariableDefinition>(templateVariableDefinitions);
    }

    protected JSONObject getAutocompleteVariableJSONObject(Class<?> clazz) {
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        jsonObject.put("type", clazz.getName());
        return jsonObject;
    }

    @Reference(unbind="-")
    protected void setDDMStructureLocalService(DDMStructureLocalService ddmStructureLocalService) {
        this._ddmStructureLocalService = ddmStructureLocalService;
    }

    @Reference(unbind="-")
    protected void setDDMStructureService(DDMStructureService ddmStructureService) {
        this._ddmStructureService = ddmStructureService;
    }

    @Reference(unbind="-")
    protected void setJSONFactory(JSONFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
    }
}

