/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.render;

import com.liferay.dynamic.data.mapping.internal.util.DDMFormFieldFreeMarkerRendererHelper;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.render.DDMFormFieldRenderer;
import com.liferay.dynamic.data.mapping.render.DDMFormFieldRenderingContext;
import com.liferay.dynamic.data.mapping.storage.Field;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.util.DDMFieldsCounter;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.editor.Editor;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.AuthTokenUtil;
import com.liferay.portal.kernel.template.ClassLoaderTemplateResource;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateManager;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DDMFormFieldFreeMarkerRenderer
implements DDMFormFieldRenderer {
    private static final String _DEFAULT_NAMESPACE = "alloy";
    private static final String _DEFAULT_READ_ONLY_NAMESPACE = "readonly";
    private static final String[] _SUPPORTED_DDM_FORM_FIELD_TYPES = new String[]{"checkbox", "ddm-color", "ddm-date", "ddm-decimal", "ddm-documentlibrary", "ddm-geolocation", "ddm-image", "ddm-integer", "ddm-journal-article", "ddm-link-to-page", "ddm-number", "ddm-paragraph", "ddm-separator", "ddm-text-html", "fieldset", "option", "radio", "select", "text", "textarea"};
    private static final String _TPL_EXT = ".ftl";
    private static final String _TPL_PATH = "com/liferay/dynamic/data/mapping/dependencies/";
    private static final Log _log = LogFactoryUtil.getLog(DDMFormFieldFreeMarkerRenderer.class);
    private final TemplateResource _defaultReadOnlyTemplateResource;
    private final TemplateResource _defaultTemplateResource;

    public DDMFormFieldFreeMarkerRenderer() {
        String defaultTemplateId = "com/liferay/dynamic/data/mapping/dependencies/alloy/text.ftl";
        this._defaultTemplateResource = this.getTemplateResource(defaultTemplateId);
        String defaultReadOnlyTemplateId = "com/liferay/dynamic/data/mapping/dependencies/readonly/default.ftl";
        this._defaultReadOnlyTemplateResource = this.getTemplateResource(defaultReadOnlyTemplateId);
    }

    public String[] getSupportedDDMFormFieldTypes() {
        return _SUPPORTED_DDM_FORM_FIELD_TYPES;
    }

    public String render(DDMFormField ddmFormField, DDMFormFieldRenderingContext ddmFormFieldRenderingContext) throws PortalException {
        try {
            HttpServletRequest request = ddmFormFieldRenderingContext.getHttpServletRequest();
            HttpServletResponse response = ddmFormFieldRenderingContext.getHttpServletResponse();
            Fields fields = ddmFormFieldRenderingContext.getFields();
            String portletNamespace = ddmFormFieldRenderingContext.getPortletNamespace();
            String namespace = ddmFormFieldRenderingContext.getNamespace();
            String mode = ddmFormFieldRenderingContext.getMode();
            boolean readOnly = ddmFormFieldRenderingContext.isReadOnly();
            boolean showEmptyFieldLabel = ddmFormFieldRenderingContext.isShowEmptyFieldLabel();
            Locale locale = ddmFormFieldRenderingContext.getLocale();
            return this.getFieldHTML(request, response, ddmFormField, fields, null, portletNamespace, namespace, mode, readOnly, showEmptyFieldLabel, locale);
        }
        catch (Exception e) {
            throw new PortalException((Throwable)e);
        }
    }

    protected void addDDMFormFieldOptionHTML(HttpServletRequest request, HttpServletResponse response, DDMFormField ddmFormField, String mode, boolean readOnly, Map<String, Object> freeMarkerContext, StringBundler sb, String label, String value) throws Exception {
        HashMap<String, String> fieldStructure = new HashMap<String, String>();
        fieldStructure.put("children", "");
        fieldStructure.put("fieldNamespace", StringUtil.randomId());
        fieldStructure.put("label", label);
        fieldStructure.put("name", StringUtil.randomId());
        fieldStructure.put("value", value);
        freeMarkerContext.put("fieldStructure", fieldStructure);
        sb.append(this.processFTL(request, response, ddmFormField.getFieldNamespace(), "option", mode, readOnly, freeMarkerContext));
    }

    protected void addLayoutProperties(DDMFormField ddmFormField, Map<String, Object> fieldContext, Locale locale) {
        LocalizedValue label = ddmFormField.getLabel();
        fieldContext.put("label", label.getString(locale));
        LocalizedValue predefinedValue = ddmFormField.getPredefinedValue();
        fieldContext.put("predefinedValue", predefinedValue.getString(locale));
        LocalizedValue style = ddmFormField.getStyle();
        fieldContext.put("style", style.getString(locale));
        LocalizedValue tip = ddmFormField.getTip();
        fieldContext.put("tip", tip.getString(locale));
    }

    protected void addStructureProperties(DDMFormField ddmFormField, Map<String, Object> fieldContext) {
        fieldContext.put("dataType", ddmFormField.getDataType());
        fieldContext.put("indexType", ddmFormField.getIndexType());
        fieldContext.put("localizable", Boolean.toString(ddmFormField.isLocalizable()));
        fieldContext.put("multiple", Boolean.toString(ddmFormField.isMultiple()));
        fieldContext.put("name", ddmFormField.getName());
        fieldContext.put("readOnly", Boolean.toString(ddmFormField.isReadOnly()));
        fieldContext.put("repeatable", Boolean.toString(ddmFormField.isRepeatable()));
        fieldContext.put("required", Boolean.toString(ddmFormField.isRequired()));
        fieldContext.put("showLabel", Boolean.toString(ddmFormField.isShowLabel()));
        fieldContext.put("type", ddmFormField.getType());
    }

    protected int countFieldRepetition(String[] fieldsDisplayValues, String parentFieldName, int offset) {
        int total = 0;
        String fieldName = fieldsDisplayValues[offset];
        while (offset < fieldsDisplayValues.length) {
            String fieldNameValue = fieldsDisplayValues[offset];
            if (fieldNameValue.equals(fieldName)) {
                ++total;
            }
            if (fieldNameValue.equals(parentFieldName)) break;
            ++offset;
        }
        return total;
    }

    protected String getDDMFormFieldOptionHTML(HttpServletRequest request, HttpServletResponse response, DDMFormField ddmFormField, String mode, boolean readOnly, Locale locale, Map<String, Object> freeMarkerContext) throws Exception {
        StringBundler sb = new StringBundler();
        if (Objects.equals(ddmFormField.getType(), "select")) {
            this.addDDMFormFieldOptionHTML(request, response, ddmFormField, mode, readOnly, freeMarkerContext, sb, "", "");
        }
        DDMFormFieldOptions ddmFormFieldOptions = ddmFormField.getDDMFormFieldOptions();
        for (String value : ddmFormFieldOptions.getOptionsValues()) {
            LocalizedValue label = ddmFormFieldOptions.getOptionLabels(value);
            this.addDDMFormFieldOptionHTML(request, response, ddmFormField, mode, readOnly, freeMarkerContext, sb, label.getString(locale), value);
        }
        return sb.toString();
    }

    protected Map<String, Object> getFieldContext(HttpServletRequest request, HttpServletResponse response, String portletNamespace, String namespace, DDMFormField ddmFormField, Locale locale) {
        String name;
        Map<String, Map<String, Object>> fieldsContext = this.getFieldsContext(request, response, portletNamespace, namespace);
        Map<String, Object> fieldContext = fieldsContext.get(name = ddmFormField.getName());
        if (fieldContext != null) {
            return fieldContext;
        }
        DDMForm ddmForm = ddmFormField.getDDMForm();
        Set availableLocales = ddmForm.getAvailableLocales();
        Locale structureLocale = locale;
        if (!availableLocales.contains(locale)) {
            structureLocale = ddmForm.getDefaultLocale();
        }
        fieldContext = new HashMap<String, Object>();
        this.addLayoutProperties(ddmFormField, fieldContext, structureLocale);
        this.addStructureProperties(ddmFormField, fieldContext);
        boolean checkRequired = GetterUtil.getBoolean((Object)request.getAttribute("checkRequired"), (boolean)true);
        if (!checkRequired) {
            fieldContext.put("required", Boolean.FALSE.toString());
        }
        fieldsContext.put(name, fieldContext);
        return fieldContext;
    }

    protected String getFieldHTML(HttpServletRequest request, HttpServletResponse response, DDMFormField ddmFormField, Fields fields, DDMFormField parentDDMFormField, String portletNamespace, String namespace, String mode, boolean readOnly, boolean showEmptyFieldLabel, Locale locale) throws Exception {
        Map<String, Object> freeMarkerContext = this.getFreeMarkerContext(request, response, portletNamespace, namespace, ddmFormField, parentDDMFormField, showEmptyFieldLabel, locale);
        if (fields != null) {
            freeMarkerContext.put("fields", fields);
        }
        Map fieldStructure = (Map)freeMarkerContext.get("fieldStructure");
        int fieldRepetition = 1;
        int offset = 0;
        DDMFieldsCounter ddmFieldsCounter = this.getFieldsCounter(request, response, fields, portletNamespace, namespace);
        String name = ddmFormField.getName();
        String fieldDisplayValue = this.getFieldsDisplayValue(request, response, fields);
        Object[] fieldsDisplayValues = this.getFieldsDisplayValues(fieldDisplayValue);
        boolean fieldDisplayable = ArrayUtil.contains((Object[])fieldsDisplayValues, (Object)name);
        if (fieldDisplayable) {
            offset = this.getFieldOffset((String[])fieldsDisplayValues, name, ddmFieldsCounter.get((Object)name));
            if (offset == fieldsDisplayValues.length) {
                return "";
            }
            Map parentFieldStructure = (Map)freeMarkerContext.get("parentFieldStructure");
            String parentFieldName = (String)parentFieldStructure.get("name");
            fieldRepetition = this.countFieldRepetition((String[])fieldsDisplayValues, parentFieldName, offset);
        }
        StringBundler sb = new StringBundler(fieldRepetition);
        while (fieldRepetition > 0) {
            offset = this.getFieldOffset((String[])fieldsDisplayValues, name, ddmFieldsCounter.get((Object)name));
            String fieldNamespace = StringUtil.randomId();
            if (fieldDisplayable) {
                fieldNamespace = this.getFieldNamespace(fieldDisplayValue, ddmFieldsCounter, offset);
            }
            fieldStructure.put("fieldNamespace", fieldNamespace);
            fieldStructure.put("valueIndex", ddmFieldsCounter.get((Object)name));
            if (fieldDisplayable) {
                ddmFieldsCounter.incrementKey((Object)name);
            }
            StringBundler childrenHTMLSB = new StringBundler(2);
            childrenHTMLSB.append(this.getHTML(request, response, ddmFormField.getNestedDDMFormFields(), fields, ddmFormField, portletNamespace, namespace, mode, readOnly, showEmptyFieldLabel, locale));
            if (Objects.equals(ddmFormField.getType(), "select") || Objects.equals(ddmFormField.getType(), "radio")) {
                HashMap<String, Object> optionFreeMarkerContext = new HashMap<String, Object>(freeMarkerContext);
                optionFreeMarkerContext.put("parentFieldStructure", fieldStructure);
                childrenHTMLSB.append(this.getDDMFormFieldOptionHTML(request, response, ddmFormField, mode, readOnly, locale, optionFreeMarkerContext));
            }
            fieldStructure.put("children", childrenHTMLSB.toString());
            sb.append(this.processFTL(request, response, ddmFormField.getFieldNamespace(), ddmFormField.getType(), mode, readOnly, freeMarkerContext));
            --fieldRepetition;
        }
        return sb.toString();
    }

    protected String getFieldNamespace(String fieldDisplayValue, DDMFieldsCounter ddmFieldsCounter, int offset) {
        String[] fieldsDisplayValues = StringUtil.split((String)fieldDisplayValue);
        String fieldsDisplayValue = fieldsDisplayValues[offset];
        return StringUtil.extractLast((String)fieldsDisplayValue, (String)"_INSTANCE_");
    }

    protected int getFieldOffset(String[] fieldsDisplayValues, String name, int index) {
        int offset;
        for (offset = 0; !(offset >= fieldsDisplayValues.length || name.equals(fieldsDisplayValues[offset]) && --index < 0); ++offset) {
        }
        return offset;
    }

    protected Map<String, Map<String, Object>> getFieldsContext(HttpServletRequest request, HttpServletResponse response, String portletNamespace, String namespace) {
        String fieldsContextKey = portletNamespace + namespace + "fieldsContext";
        HashMap fieldsContext = (HashMap)request.getAttribute(fieldsContextKey);
        if (fieldsContext == null) {
            fieldsContext = new HashMap();
            request.setAttribute(fieldsContextKey, fieldsContext);
        }
        return fieldsContext;
    }

    protected DDMFieldsCounter getFieldsCounter(HttpServletRequest request, HttpServletResponse response, Fields fields, String portletNamespace, String namespace) {
        String fieldsCounterKey = portletNamespace + namespace + "fieldsCount";
        DDMFieldsCounter ddmFieldsCounter = (DDMFieldsCounter)request.getAttribute(fieldsCounterKey);
        if (ddmFieldsCounter == null) {
            ddmFieldsCounter = new DDMFieldsCounter();
            request.setAttribute(fieldsCounterKey, (Object)ddmFieldsCounter);
        }
        return ddmFieldsCounter;
    }

    protected String getFieldsDisplayValue(HttpServletRequest request, HttpServletResponse response, Fields fields) {
        Field fieldsDisplayField;
        String defaultFieldsDisplayValue = null;
        if (fields != null && (fieldsDisplayField = fields.get("_fieldsDisplay")) != null) {
            defaultFieldsDisplayValue = (String)((Object)fieldsDisplayField.getValue());
        }
        return ParamUtil.getString((HttpServletRequest)request, (String)"_fieldsDisplay", defaultFieldsDisplayValue);
    }

    protected String[] getFieldsDisplayValues(String fieldDisplayValue) {
        ArrayList<String> fieldsDisplayValues = new ArrayList<String>();
        for (String value : StringUtil.split((String)fieldDisplayValue)) {
            String fieldName = StringUtil.extractFirst((String)value, (String)"_INSTANCE_");
            fieldsDisplayValues.add(fieldName);
        }
        return fieldsDisplayValues.toArray(new String[0]);
    }

    protected Map<String, Object> getFreeMarkerContext(HttpServletRequest request, HttpServletResponse response, String portletNamespace, String namespace, DDMFormField ddmFormField, DDMFormField parentDDMFormField, boolean showEmptyFieldLabel, Locale locale) {
        HashMap<String, Object> freeMarkerContext = new HashMap<String, Object>();
        Map<String, Object> fieldContext = this.getFieldContext(request, response, portletNamespace, namespace, ddmFormField, locale);
        Map<Object, Object> parentFieldContext = new HashMap();
        if (parentDDMFormField != null) {
            parentFieldContext = this.getFieldContext(request, response, portletNamespace, namespace, parentDDMFormField, locale);
        }
        freeMarkerContext.put("ddmPortletId", "com_liferay_dynamic_data_mapping_web_portlet_DDMPortlet");
        Editor editor = DDMFormFieldFreeMarkerRendererHelper.getEditor(request);
        freeMarkerContext.put("editorName", editor.getName());
        freeMarkerContext.put("fieldStructure", fieldContext);
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            String itemSelectorAuthToken = AuthTokenUtil.getToken((HttpServletRequest)request, (long)PortalUtil.getControlPanelPlid((long)themeDisplay.getCompanyId()), (String)"com_liferay_item_selector_web_portlet_ItemSelectorPortlet");
            freeMarkerContext.put("itemSelectorAuthToken", itemSelectorAuthToken);
        }
        catch (PortalException pe) {
            _log.error((Object)"Unable to generate item selector auth token ", (Throwable)pe);
        }
        freeMarkerContext.put("namespace", namespace);
        freeMarkerContext.put("parentFieldStructure", parentFieldContext);
        freeMarkerContext.put("portletNamespace", portletNamespace);
        freeMarkerContext.put("requestedLanguageDir", LanguageUtil.get((Locale)locale, (String)"lang.dir"));
        freeMarkerContext.put("requestedLocale", locale);
        freeMarkerContext.put("showEmptyFieldLabel", showEmptyFieldLabel);
        return freeMarkerContext;
    }

    protected String getHTML(HttpServletRequest request, HttpServletResponse response, List<DDMFormField> ddmFormFields, Fields fields, DDMFormField parentDDMFormField, String portletNamespace, String namespace, String mode, boolean readOnly, boolean showEmptyFieldLabel, Locale locale) throws Exception {
        StringBundler sb = new StringBundler(ddmFormFields.size());
        for (DDMFormField ddmFormField : ddmFormFields) {
            sb.append(this.getFieldHTML(request, response, ddmFormField, fields, parentDDMFormField, portletNamespace, namespace, mode, readOnly, showEmptyFieldLabel, locale));
        }
        return sb.toString();
    }

    protected URL getResource(String name) {
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        return classLoader.getResource(name);
    }

    protected TemplateResource getTemplateResource(String resource) {
        Class<?> clazz = this.getClass();
        return new ClassLoaderTemplateResource(clazz.getClassLoader(), resource);
    }

    protected String processFTL(HttpServletRequest request, HttpServletResponse response, String fieldNamespace, String type, String mode, boolean readOnly, Map<String, Object> freeMarkerContext) throws Exception {
        if (Validator.isNull((String)fieldNamespace)) {
            fieldNamespace = _DEFAULT_NAMESPACE;
        }
        TemplateResource templateResource = this._defaultTemplateResource;
        Map fieldStructure = (Map)freeMarkerContext.get("fieldStructure");
        boolean fieldReadOnly = GetterUtil.getBoolean(fieldStructure.get("readOnly"));
        if (fieldReadOnly && Validator.isNotNull((String)mode) && StringUtil.equalsIgnoreCase((String)mode, (String)"edit") || readOnly) {
            fieldNamespace = _DEFAULT_READ_ONLY_NAMESPACE;
            templateResource = this._defaultReadOnlyTemplateResource;
        }
        String templateName = StringUtil.replaceFirst((String)type, (String)fieldNamespace.concat("-"), (String)"");
        StringBundler sb = new StringBundler(5);
        sb.append(_TPL_PATH);
        sb.append(StringUtil.toLowerCase((String)fieldNamespace));
        sb.append('/');
        sb.append(templateName);
        sb.append(_TPL_EXT);
        String resource = sb.toString();
        URL url = this.getResource(resource);
        if (url != null) {
            templateResource = this.getTemplateResource(resource);
        }
        if (templateResource == null) {
            throw new Exception("Unable to load template resource " + resource);
        }
        Template template = TemplateManagerUtil.getTemplate((String)"ftl", (TemplateResource)templateResource, (boolean)false);
        for (Map.Entry<String, Object> entry : freeMarkerContext.entrySet()) {
            template.put((Object)entry.getKey(), entry.getValue());
        }
        TemplateManager templateManager = TemplateManagerUtil.getTemplateManager((String)"ftl");
        templateManager.addTaglibSupport((Map)template, request, response);
        return this.processFTL(request, response, template);
    }

    protected String processFTL(HttpServletRequest request, HttpServletResponse response, Template template) throws Exception {
        template.prepare(request);
        UnsyncStringWriter writer = new UnsyncStringWriter();
        template.processTemplate((Writer)writer);
        return writer.toString();
    }
}

