/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.impl;

import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.model.DDMTemplateVersion;
import com.liferay.dynamic.data.mapping.service.base.DDMTemplateVersionServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;

public class DDMTemplateVersionServiceImpl
extends DDMTemplateVersionServiceBaseImpl {
    private static volatile ModelResourcePermission<DDMTemplate> _ddmTemplateModelResourcePermission = ModelResourcePermissionFactory.getInstance(DDMTemplateVersionServiceImpl.class, (String)"_ddmTemplateModelResourcePermission", DDMTemplate.class);

    public DDMTemplateVersion getLatestTemplateVersion(long templateId) throws PortalException {
        _ddmTemplateModelResourcePermission.check(this.getPermissionChecker(), templateId, "VIEW");
        return this.ddmTemplateVersionLocalService.getLatestTemplateVersion(templateId);
    }

    public DDMTemplateVersion getTemplateVersion(long templateVersionId) throws PortalException {
        DDMTemplateVersion templateVersion = this.ddmTemplateVersionLocalService.getTemplateVersion(templateVersionId);
        _ddmTemplateModelResourcePermission.check(this.getPermissionChecker(), templateVersion.getTemplateId(), "VIEW");
        return templateVersion;
    }

    public List<DDMTemplateVersion> getTemplateVersions(long templateId, int start, int end, OrderByComparator<DDMTemplateVersion> orderByComparator) throws PortalException {
        _ddmTemplateModelResourcePermission.check(this.getPermissionChecker(), templateId, "VIEW");
        return this.ddmTemplateVersionLocalService.getTemplateVersions(templateId, start, end, orderByComparator);
    }

    public int getTemplateVersionsCount(long templateId) throws PortalException {
        _ddmTemplateModelResourcePermission.check(this.getPermissionChecker(), templateId, "VIEW");
        return this.ddmTemplateVersionLocalService.getTemplateVersionsCount(templateId);
    }
}

