/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.util;

import com.liferay.dynamic.data.mapping.io.DDMFormJSONDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutJSONDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormXSDDeserializer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.dynamic.data.mapping.storage.StorageType;
import com.liferay.dynamic.data.mapping.util.DDM;
import com.liferay.dynamic.data.mapping.util.DDMXML;
import com.liferay.dynamic.data.mapping.util.DefaultDDMStructureHelper;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.upgrade.util.UpgradeProcessUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DefaultDDMStructureHelper.class})
public class DefaultDDMStructureHelperImpl
implements DefaultDDMStructureHelper {
    private DDM _ddm;
    private DDMFormJSONDeserializer _ddmFormJSONDeserializer;
    private DDMFormLayoutJSONDeserializer _ddmFormLayoutJSONDeserializer;
    private DDMFormXSDDeserializer _ddmFormXSDDeserializer;
    private DDMStructureLocalService _ddmStructureLocalService;
    private DDMTemplateLocalService _ddmTemplateLocalService;
    private DDMXML _ddmXML;
    @Reference
    private Portal _portal;

    public void addDDMStructures(long userId, long groupId, long classNameId, ClassLoader classLoader, String fileName, ServiceContext serviceContext) throws Exception {
        Locale locale = this._portal.getSiteDefaultLocale(groupId);
        List<Element> structureElements = this.getDDMStructures(classLoader, fileName, locale);
        for (Element structureElement : structureElements) {
            boolean dynamicStructure = GetterUtil.getBoolean((String)structureElement.elementText("dynamic-structure"));
            if (dynamicStructure) continue;
            String name = structureElement.elementText("name");
            String description = structureElement.elementText("description");
            String ddmStructureKey = name;
            DDMStructure ddmStructure = this._ddmStructureLocalService.fetchStructure(groupId, classNameId, ddmStructureKey);
            if (ddmStructure != null || name.equals("image-gallery-image") && !UpgradeProcessUtil.isCreateIGImageDocumentType()) continue;
            String ddmTemplateKey = name;
            HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
            HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
            for (Locale curLocale : LanguageUtil.getAvailableLocales((long)groupId)) {
                nameMap.put(curLocale, LanguageUtil.get((Locale)curLocale, (String)name));
                descriptionMap.put(curLocale, LanguageUtil.get((Locale)curLocale, (String)description));
            }
            DDMForm ddmForm = this.getDDMForm(structureElement, locale);
            DDMFormLayout ddmFormLayout = this.getDDMFormLayout(structureElement, ddmForm);
            serviceContext.setAttribute("status", (Serializable)Integer.valueOf(0));
            ddmStructure = this._ddmStructureLocalService.addStructure(userId, groupId, 0L, classNameId, ddmStructureKey, nameMap, descriptionMap, ddmForm, ddmFormLayout, StorageType.JSON.toString(), 0, serviceContext);
            Element templateElement = structureElement.element("template");
            if (templateElement == null) continue;
            String templateFileName = templateElement.elementText("file-name");
            String script = StringUtil.read((ClassLoader)classLoader, (String)(FileUtil.getPath((String)fileName) + "/" + templateFileName));
            boolean cacheable = GetterUtil.getBoolean((String)templateElement.elementText("cacheable"));
            this._ddmTemplateLocalService.addTemplate(userId, groupId, this._portal.getClassNameId(DDMStructure.class), ddmStructure.getStructureId(), ddmStructure.getClassNameId(), ddmTemplateKey, nameMap, null, "display", "create", "ftl", script, cacheable, false, "", null, serviceContext);
        }
    }

    public String getDynamicDDMStructureDefinition(ClassLoader classLoader, String fileName, String dynamicDDMStructureName, Locale locale) throws Exception {
        List<Element> structureElements = this.getDDMStructures(classLoader, fileName, locale);
        for (Element structureElement : structureElements) {
            String name;
            boolean dynamicStructure = GetterUtil.getBoolean((String)structureElement.elementText("dynamic-structure"));
            if (!dynamicStructure || !(name = structureElement.elementText("name")).equals(dynamicDDMStructureName)) continue;
            Element structureElementRootElement = structureElement.element("root");
            return structureElementRootElement.asXML();
        }
        return null;
    }

    protected DDMForm getDDMForm(Element structureElement, Locale locale) throws Exception {
        Element structureElementDefinitionElement = structureElement.element("definition");
        if (structureElementDefinitionElement != null) {
            return this._ddmFormJSONDeserializer.deserialize(structureElementDefinitionElement.getTextTrim());
        }
        Element structureElementRootElement = structureElement.element("root");
        String definition = structureElementRootElement.asXML();
        DDMForm ddmForm = this._ddmFormXSDDeserializer.deserialize(definition);
        return this._ddm.updateDDMFormDefaultLocale(ddmForm, locale);
    }

    protected DDMFormLayout getDDMFormLayout(Element structureElement, DDMForm ddmForm) throws Exception {
        Element structureElementLayoutElement = structureElement.element("layout");
        if (structureElementLayoutElement != null) {
            return this._ddmFormLayoutJSONDeserializer.deserialize(structureElementLayoutElement.getTextTrim());
        }
        return this._ddm.getDefaultDDMFormLayout(ddmForm);
    }

    protected List<Element> getDDMStructures(ClassLoader classLoader, String fileName, Locale locale) throws Exception {
        String xml = StringUtil.read((ClassLoader)classLoader, (String)fileName);
        xml = StringUtil.replace((String)xml, (String)"[$LOCALE_DEFAULT$]", (String)locale.toString());
        Document document = UnsecureSAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        return rootElement.elements("structure");
    }

    @Reference(unbind="-")
    protected void setDDM(DDM ddm) {
        this._ddm = ddm;
    }

    @Reference(unbind="-")
    protected void setDDMFormJSONDeserializer(DDMFormJSONDeserializer ddmFormJSONDeserializer) {
        this._ddmFormJSONDeserializer = ddmFormJSONDeserializer;
    }

    @Reference(unbind="-")
    protected void setDDMFormLayoutJSONDeserializer(DDMFormLayoutJSONDeserializer ddmFormLayoutJSONDeserializer) {
        this._ddmFormLayoutJSONDeserializer = ddmFormLayoutJSONDeserializer;
    }

    @Reference(unbind="-")
    protected void setDDMFormXSDDeserializer(DDMFormXSDDeserializer ddmFormXSDDeserializer) {
        this._ddmFormXSDDeserializer = ddmFormXSDDeserializer;
    }

    @Reference(unbind="-")
    protected void setDDMStructureLocalService(DDMStructureLocalService ddmStructureLocalService) {
        this._ddmStructureLocalService = ddmStructureLocalService;
    }

    @Reference(unbind="-")
    protected void setDDMTemplateLocalService(DDMTemplateLocalService ddmTemplateLocalService) {
        this._ddmTemplateLocalService = ddmTemplateLocalService;
    }

    @Reference(unbind="-")
    protected void setDDMXML(DDMXML ddmXML) {
        this._ddmXML = ddmXML;
    }
}

