/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.util;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.Field;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.util.DDM;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesToFieldsConverter;
import com.liferay.dynamic.data.mapping.util.DDMIndexer;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.filter.QueryFilter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.Format;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DDMIndexer.class})
public class DDMIndexerImpl
implements DDMIndexer {
    private static final Log _log = LogFactoryUtil.getLog(DDMIndexerImpl.class);
    private DDM _ddm;
    private DDMFormValuesToFieldsConverter _ddmFormValuesToFieldsConverter;
    private DDMStructureLocalService _ddmStructureLocalService;

    public void addAttributes(Document document, DDMStructure ddmStructure, DDMFormValues ddmFormValues) {
        Set locales = ddmFormValues.getAvailableLocales();
        Fields fields = this.toFields(ddmStructure, ddmFormValues);
        for (Field field : fields) {
            try {
                String indexType = ddmStructure.getFieldProperty(field.getName(), "indexType");
                if (Validator.isNull((String)indexType)) continue;
                for (Locale locale : locales) {
                    String name = this.encodeName(ddmStructure.getStructureId(), field.getName(), locale, indexType);
                    Serializable value = field.getValue(locale);
                    if (value instanceof BigDecimal) {
                        document.addNumberSortable(name, (BigDecimal)value);
                        continue;
                    }
                    if (value instanceof BigDecimal[]) {
                        document.addNumberSortable(name, (BigDecimal[])value);
                        continue;
                    }
                    if (value instanceof Boolean) {
                        document.addKeywordSortable(name, (Boolean)value);
                        continue;
                    }
                    if (value instanceof Boolean[]) {
                        document.addKeywordSortable(name, (Boolean[])value);
                        continue;
                    }
                    if (value instanceof Date) {
                        document.addDateSortable(name, (Date)value);
                        continue;
                    }
                    if (value instanceof Date[]) {
                        document.addDateSortable(name, (Date[])value);
                        continue;
                    }
                    if (value instanceof Double) {
                        document.addNumberSortable(name, (Double)value);
                        continue;
                    }
                    if (value instanceof Double[]) {
                        document.addNumberSortable(name, (Double[])value);
                        continue;
                    }
                    if (value instanceof Integer) {
                        document.addNumberSortable(name, (Integer)value);
                        continue;
                    }
                    if (value instanceof Integer[]) {
                        document.addNumberSortable(name, (Integer[])value);
                        continue;
                    }
                    if (value instanceof Long) {
                        document.addNumberSortable(name, (Long)value);
                        continue;
                    }
                    if (value instanceof Long[]) {
                        document.addNumberSortable(name, (Long[])value);
                        continue;
                    }
                    if (value instanceof Float) {
                        document.addNumberSortable(name, (Float)value);
                        continue;
                    }
                    if (value instanceof Float[]) {
                        document.addNumberSortable(name, (Float[])value);
                        continue;
                    }
                    if (value instanceof Number[]) {
                        Number[] numbers = (Number[])value;
                        Double[] doubles = new Double[numbers.length];
                        for (int i = 0; i < numbers.length; ++i) {
                            doubles[i] = numbers[i].doubleValue();
                        }
                        document.addNumberSortable(name, doubles);
                        continue;
                    }
                    if (value instanceof Object[]) {
                        String[] valuesString = ArrayUtil.toStringArray((Object[])((Object[])value));
                        if (indexType.equals("keyword")) {
                            document.addKeywordSortable(name, valuesString);
                            continue;
                        }
                        document.addTextSortable(name, valuesString);
                        continue;
                    }
                    String valueString = String.valueOf(value);
                    String type = field.getType();
                    if (type.equals("ddm-geolocation")) {
                        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)valueString);
                        double latitude = jsonObject.getDouble("latitude", 0.0);
                        double longitude = jsonObject.getDouble("longitude", 0.0);
                        document.addGeoLocation(name.concat("_geolocation"), latitude, longitude);
                        continue;
                    }
                    if (type.equals("select")) {
                        JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)valueString);
                        String[] stringArray = ArrayUtil.toStringArray((JSONArray)jsonArray);
                        document.addKeywordSortable(name, stringArray);
                        continue;
                    }
                    if (type.equals("ddm-text-html")) {
                        valueString = HtmlUtil.extractText((String)valueString);
                    }
                    if (indexType.equals("keyword")) {
                        document.addKeywordSortable(name, valueString);
                        continue;
                    }
                    document.addTextSortable(name, valueString);
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)e, (Throwable)e);
            }
        }
    }

    public QueryFilter createFieldValueQueryFilter(String ddmStructureFieldName, Serializable ddmStructureFieldValue, Locale locale) throws Exception {
        String fieldName;
        BooleanQueryImpl booleanQuery = new BooleanQueryImpl();
        String[] ddmStructureFieldNameParts = StringUtil.split((String)ddmStructureFieldName, (String)"__");
        DDMStructure structure = this._ddmStructureLocalService.getStructure(GetterUtil.getLong((String)ddmStructureFieldNameParts[2]));
        if (structure.hasField(fieldName = StringUtil.replaceLast((String)ddmStructureFieldNameParts[3], (String)"_".concat(LocaleUtil.toLanguageId((Locale)locale)), (String)""))) {
            ddmStructureFieldValue = this._ddm.getIndexedFieldValue(ddmStructureFieldValue, structure.getFieldType(fieldName));
        }
        booleanQuery.addRequiredTerm(ddmStructureFieldName, "\"" + ddmStructureFieldValue + "\"");
        return new QueryFilter((Query)booleanQuery);
    }

    public String encodeName(long ddmStructureId, String fieldName) {
        return this.encodeName(ddmStructureId, fieldName, null);
    }

    public String encodeName(long ddmStructureId, String fieldName, Locale locale) {
        DDMStructure ddmStructure;
        String indexType = "";
        if (ddmStructureId > 0L && (ddmStructure = this._ddmStructureLocalService.fetchDDMStructure(ddmStructureId)) != null) {
            try {
                indexType = ddmStructure.getFieldProperty(fieldName, "indexType");
            }
            catch (PortalException pe) {
                throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"Unable to obtain index tpe for field ", fieldName, " and DDM structure ID ", ddmStructureId}), pe);
            }
        }
        return this.encodeName(ddmStructureId, fieldName, locale, indexType);
    }

    public String extractIndexableAttributes(DDMStructure ddmStructure, DDMFormValues ddmFormValues, Locale locale) {
        Format dateFormat = FastDateFormatFactoryUtil.getSimpleDateFormat((String)PropsUtil.get((String)"index.date.format.pattern"));
        StringBundler sb = new StringBundler();
        Fields fields = this.toFields(ddmStructure, ddmFormValues);
        for (Field field : fields) {
            try {
                String indexType = ddmStructure.getFieldProperty(field.getName(), "indexType");
                if (Validator.isNull((String)indexType)) continue;
                Serializable value = field.getValue(locale);
                if (value instanceof Boolean || value instanceof Number) {
                    sb.append((Object)value);
                    sb.append(" ");
                    continue;
                }
                if (value instanceof Date) {
                    sb.append(dateFormat.format(value));
                    sb.append(" ");
                    continue;
                }
                if (value instanceof Date[]) {
                    Date[] dates = (Date[])value;
                    for (Date date : dates) {
                        sb.append(dateFormat.format(date));
                        sb.append(" ");
                    }
                    continue;
                }
                if (value instanceof Object[]) {
                    Object[] values = (Object[])value;
                    for (Object object : values) {
                        sb.append(object);
                        sb.append(" ");
                    }
                    continue;
                }
                String valueString = String.valueOf(value);
                String type = field.getType();
                if (type.equals("select")) {
                    JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)valueString);
                    String[] stringArray = ArrayUtil.toStringArray((JSONArray)jsonArray);
                    sb.append(stringArray);
                    sb.append(" ");
                    continue;
                }
                if (type.equals("ddm-text-html")) {
                    valueString = HtmlUtil.extractText((String)valueString);
                }
                sb.append(valueString);
                sb.append(" ");
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)e, (Throwable)e);
            }
        }
        return sb.toString();
    }

    protected String encodeName(long ddmStructureId, String fieldName, Locale locale, String indexType) {
        StringBundler sb = new StringBundler(8);
        sb.append("ddm__");
        if (Validator.isNotNull((String)indexType)) {
            sb.append(indexType);
            sb.append("__");
        }
        sb.append(ddmStructureId);
        sb.append("__");
        sb.append(fieldName);
        if (locale != null) {
            sb.append("_");
            sb.append(LocaleUtil.toLanguageId((Locale)locale));
        }
        return sb.toString();
    }

    @Reference(unbind="-")
    protected void setDDM(DDM ddm) {
        this._ddm = ddm;
    }

    @Reference(unbind="-")
    protected void setDDMFormValuesToFieldsConverter(DDMFormValuesToFieldsConverter ddmFormValuesToFieldsConverter) {
        this._ddmFormValuesToFieldsConverter = ddmFormValuesToFieldsConverter;
    }

    @Reference(unbind="-")
    protected void setDDMStructureLocalService(DDMStructureLocalService ddmStructureLocalService) {
        this._ddmStructureLocalService = ddmStructureLocalService;
    }

    protected Fields toFields(DDMStructure ddmStructure, DDMFormValues ddmFormValues) {
        try {
            return this._ddmFormValuesToFieldsConverter.convert(ddmStructure, ddmFormValues);
        }
        catch (PortalException pe) {
            _log.error((Object)"Unable to convert DDMFormValues to Fields", (Throwable)pe);
            return new Fields();
        }
    }
}

