/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.util;

import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesMerger;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true)
public class DDMFormValuesMergerImpl
implements DDMFormValuesMerger {
    public DDMFormValues merge(DDMFormValues newDDMFormValues, DDMFormValues existingDDMFormValues) {
        List<DDMFormFieldValue> mergedDDMFormFieldValues = this.mergeDDMFormFieldValues(newDDMFormValues.getDDMFormFieldValues(), existingDDMFormValues.getDDMFormFieldValues());
        existingDDMFormValues.setDDMFormFieldValues(mergedDDMFormFieldValues);
        return existingDDMFormValues;
    }

    protected DDMFormFieldValue getDDMFormFieldValueByName(List<DDMFormFieldValue> ddmFormFieldValues, String name) {
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            if (!name.equals(ddmFormFieldValue.getName())) continue;
            return ddmFormFieldValue;
        }
        return null;
    }

    protected List<DDMFormFieldValue> mergeDDMFormFieldValues(List<DDMFormFieldValue> newDDMFormFieldValues, List<DDMFormFieldValue> existingDDMFormFieldValues) {
        ArrayList<DDMFormFieldValue> mergedDDMFormFieldValues = new ArrayList<DDMFormFieldValue>(existingDDMFormFieldValues);
        for (DDMFormFieldValue newDDMFormFieldValue : newDDMFormFieldValues) {
            DDMFormFieldValue actualDDMFormFieldValue = this.getDDMFormFieldValueByName(existingDDMFormFieldValues, newDDMFormFieldValue.getName());
            if (actualDDMFormFieldValue != null) {
                this.mergeValue(newDDMFormFieldValue.getValue(), actualDDMFormFieldValue.getValue());
                List<DDMFormFieldValue> mergedNestedDDMFormFieldValues = this.mergeDDMFormFieldValues(newDDMFormFieldValue.getNestedDDMFormFieldValues(), actualDDMFormFieldValue.getNestedDDMFormFieldValues());
                newDDMFormFieldValue.setNestedDDMFormFields(mergedNestedDDMFormFieldValues);
                existingDDMFormFieldValues.remove(actualDDMFormFieldValue);
                mergedDDMFormFieldValues.remove(actualDDMFormFieldValue);
            }
            mergedDDMFormFieldValues.add(newDDMFormFieldValue);
        }
        return mergedDDMFormFieldValues;
    }

    protected void mergeValue(Value newValue, Value existingValue) {
        if (existingValue == null) {
            return;
        }
        for (Locale locale : existingValue.getAvailableLocales()) {
            String value = newValue.getString(locale);
            if (value != null) continue;
            newValue.addString(locale, existingValue.getString(locale));
        }
    }
}

