/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v2_0_1;

import com.liferay.dynamic.data.mapping.io.DDMFormJSONDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormJSONSerializer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import java.util.Objects;

public class UpgradeAutocompleteDDMTextFieldSetting
extends UpgradeProcess {
    private final DDMFormJSONDeserializer _ddmFormJSONDeserializer;
    private final DDMFormJSONSerializer _ddmFormJSONSerializer;

    public UpgradeAutocompleteDDMTextFieldSetting(DDMFormJSONDeserializer ddmFormJSONDeserializer, DDMFormJSONSerializer ddmFormJSONSerializer) {
        this._ddmFormJSONDeserializer = ddmFormJSONDeserializer;
        this._ddmFormJSONSerializer = ddmFormJSONSerializer;
    }

    protected void doUpgrade() throws Exception {
        StringBundler sb = new StringBundler(4);
        sb.append("select DDMStructure.structureId, DDMStructure.definition ");
        sb.append("from DDMFormInstance inner join DDMStructure on ");
        sb.append("DDMFormInstance.structureId = DDMStructure.structureId ");
        sb.append("where DDMStructure.definition like '%\"type\":\"text\"%'");
        try (PreparedStatement ps1 = this.connection.prepareStatement(sb.toString());
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructure set definition = ? where structureId = ?");
             ResultSet rs = ps1.executeQuery();){
            while (rs.next()) {
                String newDefinition;
                long structureId = rs.getLong(1);
                String definition = rs.getString(2);
                if (Objects.equals(definition, newDefinition = this.upgradeDDMFormInstanceStructure(definition))) continue;
                ps2.setString(1, newDefinition);
                ps2.setLong(2, structureId);
                ps2.addBatch();
            }
            ps2.executeBatch();
        }
    }

    protected boolean isAutocompleteEnabled(Map<String, Object> properties) {
        String dataSourceType = (String)properties.get("dataSourceType");
        return Validator.isNotNull((String)dataSourceType);
    }

    protected String upgradeDDMFormInstanceStructure(String definition) throws Exception {
        DDMForm ddmForm = this._ddmFormJSONDeserializer.deserialize(definition);
        for (DDMFormField ddmFormField : ddmForm.getDDMFormFields()) {
            Map properties;
            if (!Objects.equals(ddmFormField.getType(), "text") || (properties = ddmFormField.getProperties()).containsKey("autocomplete")) continue;
            properties.put("autocomplete", this.isAutocompleteEnabled(properties));
        }
        return this._ddmFormJSONSerializer.serialize(ddmForm);
    }
}

