/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.model.impl;

import com.liferay.dynamic.data.mapping.model.DDMTemplateVersion;
import com.liferay.dynamic.data.mapping.model.impl.DDMTemplateBaseImpl;
import com.liferay.dynamic.data.mapping.service.DDMTemplateVersionLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.service.ImageLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webserver.WebServerServletTokenUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.util.PropsValues;
import java.util.Locale;

public class DDMTemplateImpl
extends DDMTemplateBaseImpl {
    private String _resourceClassName;
    private String _smallImageType;

    @Override
    public String getDefaultLanguageId() {
        Document document = null;
        try {
            document = SAXReaderUtil.read((String)this.getName());
            if (document != null) {
                Element rootElement = document.getRootElement();
                return rootElement.attributeValue("default-locale");
            }
        }
        catch (Exception rootElement) {
            // empty catch block
        }
        Locale locale = LocaleUtil.getSiteDefault();
        return locale.toString();
    }

    public DDMTemplateVersion getLatestTemplateVersion() throws PortalException {
        return DDMTemplateVersionLocalServiceUtil.getLatestTemplateVersion((long)this.getTemplateId());
    }

    @Override
    public String getResourceClassName() {
        if (this._resourceClassName == null) {
            this._resourceClassName = PortalUtil.getClassName((long)this.getResourceClassNameId());
        }
        return this._resourceClassName;
    }

    public String getSmallImageType() throws PortalException {
        if (this._smallImageType == null && this.isSmallImage()) {
            Image smallImage = ImageLocalServiceUtil.getImage((long)this.getSmallImageId());
            this._smallImageType = smallImage.getType();
        }
        return this._smallImageType;
    }

    public String getTemplateImageURL(ThemeDisplay themeDisplay) {
        if (!this.isSmallImage()) {
            return null;
        }
        if (Validator.isNotNull((String)this.getSmallImageURL())) {
            return this.getSmallImageURL();
        }
        return StringBundler.concat((String[])new String[]{themeDisplay.getPathImage(), "/template?img_id=", String.valueOf(this.getSmallImageId()), "&t=", WebServerServletTokenUtil.getToken((long)this.getSmallImageId())});
    }

    public DDMTemplateVersion getTemplateVersion() throws PortalException {
        return DDMTemplateVersionLocalServiceUtil.getTemplateVersion((long)this.getTemplateId(), (String)this.getVersion());
    }

    public String getWebDavURL(ThemeDisplay themeDisplay, String webDAVToken) {
        StringBundler sb = new StringBundler(11);
        boolean secure = false;
        if (themeDisplay.isSecure() || PropsValues.WEBDAV_SERVLET_HTTPS_REQUIRED) {
            secure = true;
        }
        String portalURL = PortalUtil.getPortalURL((String)themeDisplay.getServerName(), (int)themeDisplay.getServerPort(), (boolean)secure);
        sb.append(portalURL);
        sb.append(themeDisplay.getPathContext());
        sb.append("/");
        sb.append("webdav");
        Group group = themeDisplay.getScopeGroup();
        sb.append(group.getFriendlyURL());
        sb.append("/");
        sb.append(webDAVToken);
        sb.append("/");
        sb.append("Templates");
        sb.append("/");
        sb.append(this.getTemplateId());
        return sb.toString();
    }

    @Override
    public void setResourceClassName(String resourceClassName) {
        this._resourceClassName = resourceClassName;
    }

    @Override
    public void setResourceClassNameId(long resourceClassNameId) {
        super.setResourceClassNameId(resourceClassNameId);
        this._resourceClassName = null;
    }

    public void setSmallImageType(String smallImageType) {
        this._smallImageType = smallImageType;
    }
}

