/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.model.impl;

import com.liferay.dynamic.data.mapping.exception.StructureFieldException;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.impl.DDMStructureBaseImpl;
import com.liferay.dynamic.data.mapping.service.DDMStructureLayoutLocalServiceUtil;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalServiceUtil;
import com.liferay.dynamic.data.mapping.service.DDMStructureVersionLocalServiceUtil;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PredicateFilter;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class DDMStructureImpl
extends DDMStructureBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(DDMStructureImpl.class);
    private String _className;
    private DDMForm _ddmForm;

    public DDMForm createFullHierarchyDDMForm() throws PortalException {
        DDMForm fullHierarchyDDMForm = this.getDDMForm();
        DDMStructure parentDDMStructure = this.getParentDDMStructure();
        if (parentDDMStructure != null) {
            DDMForm ancestorsDDMForm = parentDDMStructure.createFullHierarchyDDMForm();
            List ddmFormFields = fullHierarchyDDMForm.getDDMFormFields();
            ddmFormFields.addAll(0, ancestorsDDMForm.getDDMFormFields());
        }
        return fullHierarchyDDMForm;
    }

    @Override
    public String[] getAvailableLanguageIds() {
        DDMForm ddmForm = this.getDDMForm();
        Set availableLocales = ddmForm.getAvailableLocales();
        return LocaleUtil.toLanguageIds((Locale[])availableLocales.toArray(new Locale[availableLocales.size()]));
    }

    public List<String> getChildrenFieldNames(String fieldName) throws PortalException {
        DDMFormField ddmFormField = this.getDDMFormField(fieldName);
        return this.getDDMFormFieldNames(ddmFormField.getNestedDDMFormFields());
    }

    @Override
    public String getClassName() {
        if (this._className == null) {
            this._className = PortalUtil.getClassName((long)this.getClassNameId());
        }
        return this._className;
    }

    @Override
    public DDMForm getDDMForm() {
        if (this._ddmForm == null) {
            try {
                this._ddmForm = DDMStructureLocalServiceUtil.getStructureDDMForm((DDMStructure)this);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
                return new DDMForm();
            }
        }
        return new DDMForm(this._ddmForm);
    }

    public DDMFormField getDDMFormField(String fieldName) throws PortalException {
        Map<String, DDMFormField> ddmFormFieldsMap = this.getFullHierarchyDDMFormFieldsMap(true);
        DDMFormField ddmFormField = ddmFormFieldsMap.get(fieldName);
        if (ddmFormField == null) {
            throw new StructureFieldException("Unable to find field " + fieldName);
        }
        return ddmFormField;
    }

    public List<DDMFormField> getDDMFormFields(boolean includeTransientFields) {
        Map<String, DDMFormField> ddmFormFieldsMap = this.getFullHierarchyDDMFormFieldsMap(true);
        ArrayList<DDMFormField> ddmFormFields = new ArrayList<DDMFormField>(ddmFormFieldsMap.values());
        if (includeTransientFields) {
            return ddmFormFields;
        }
        return this.filterTransientDDMFormFields(ddmFormFields);
    }

    public DDMFormLayout getDDMFormLayout() throws PortalException {
        DDMStructureVersion structureVersion = this.getStructureVersion();
        DDMStructureLayout ddmStructureLayout = DDMStructureLayoutLocalServiceUtil.getStructureLayoutByStructureVersionId((long)structureVersion.getStructureVersionId());
        return ddmStructureLayout.getDDMFormLayout();
    }

    @Override
    public String getDefaultLanguageId() {
        DDMForm ddmForm = this.getDDMForm();
        return LocaleUtil.toLanguageId((Locale)ddmForm.getDefaultLocale());
    }

    public String getFieldDataType(String fieldName) throws PortalException {
        DDMFormField ddmFormField = this.getDDMFormField(fieldName);
        return ddmFormField.getDataType();
    }

    public String getFieldLabel(String fieldName, Locale locale) throws PortalException {
        DDMFormField ddmFormField = this.getDDMFormField(fieldName);
        LocalizedValue label = ddmFormField.getLabel();
        return label.getString(locale);
    }

    public String getFieldLabel(String fieldName, String locale) throws PortalException {
        return this.getFieldLabel(fieldName, LocaleUtil.fromLanguageId((String)locale));
    }

    public Set<String> getFieldNames() {
        List<DDMFormField> ddmFormFields = this.getDDMFormFields(false);
        List<String> ddmFormFieldNames = this.getDDMFormFieldNames(ddmFormFields);
        return SetUtil.fromList(ddmFormFieldNames);
    }

    public String getFieldProperty(String fieldName, String property) throws PortalException {
        DDMFormField ddmFormField = this.getDDMFormField(fieldName);
        return BeanPropertiesUtil.getString((Object)ddmFormField, (String)property);
    }

    public boolean getFieldRepeatable(String fieldName) throws PortalException {
        DDMFormField ddmFormField = this.getDDMFormField(fieldName);
        return ddmFormField.isRepeatable();
    }

    public boolean getFieldRequired(String fieldName) throws PortalException {
        DDMFormField ddmFormField = this.getDDMFormField(fieldName);
        return ddmFormField.isRequired();
    }

    public String getFieldTip(String fieldName, Locale locale) throws PortalException {
        DDMFormField ddmFormField = this.getDDMFormField(fieldName);
        LocalizedValue tip = ddmFormField.getTip();
        return tip.getString(locale);
    }

    public String getFieldTip(String fieldName, String locale) throws PortalException {
        return this.getFieldTip(fieldName, LocaleUtil.fromLanguageId((String)locale));
    }

    public String getFieldType(String fieldName) throws PortalException {
        DDMFormField ddmFormField = this.getDDMFormField(fieldName);
        return ddmFormField.getType();
    }

    public DDMForm getFullHierarchyDDMForm() {
        try {
            DDMForm fullHierarchyDDMForm = this.createFullHierarchyDDMForm();
            return new DDMForm(fullHierarchyDDMForm);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return new DDMForm();
        }
    }

    public Map<String, DDMFormField> getFullHierarchyDDMFormFieldsMap(boolean includeNestedDDMFormFields) {
        DDMForm ddmForm = this.getFullHierarchyDDMForm();
        return ddmForm.getDDMFormFieldsMap(includeNestedDDMFormFields);
    }

    public DDMStructureVersion getLatestStructureVersion() throws PortalException {
        return DDMStructureVersionLocalServiceUtil.getLatestStructureVersion((long)this.getStructureId());
    }

    public List<String> getRootFieldNames() {
        DDMForm ddmForm = this.getFullHierarchyDDMForm();
        return this.getDDMFormFieldNames(ddmForm.getDDMFormFields());
    }

    public DDMStructureVersion getStructureVersion() throws PortalException {
        return DDMStructureVersionLocalServiceUtil.getStructureVersion((long)this.getStructureId(), (String)this.getVersion());
    }

    public List<DDMTemplate> getTemplates() {
        return DDMTemplateLocalServiceUtil.getTemplates((long)this.getStructureId());
    }

    public String getUnambiguousName(List<DDMStructure> structures, long groupId, final Locale locale) throws PortalException {
        if (this.getGroupId() == groupId) {
            return this.getName(locale);
        }
        boolean hasAmbiguousName = ListUtil.exists(structures, (PredicateFilter)new PredicateFilter<DDMStructure>(){

            public boolean filter(DDMStructure structure) {
                if (structure.getStructureId() == DDMStructureImpl.this.getStructureId()) {
                    return false;
                }
                String name = structure.getName(locale);
                return name.equals(DDMStructureImpl.this.getName(locale));
            }
        });
        if (hasAmbiguousName) {
            Group group = GroupLocalServiceUtil.getGroup((long)this.getGroupId());
            return group.getUnambiguousName(this.getName(locale), locale);
        }
        return this.getName(locale);
    }

    public String getWebDavURL(ThemeDisplay themeDisplay, String webDAVToken) {
        StringBundler sb = new StringBundler(11);
        boolean secure = false;
        if (themeDisplay.isSecure() || PropsValues.WEBDAV_SERVLET_HTTPS_REQUIRED) {
            secure = true;
        }
        String portalURL = PortalUtil.getPortalURL((String)themeDisplay.getServerName(), (int)themeDisplay.getServerPort(), (boolean)secure);
        sb.append(portalURL);
        sb.append(themeDisplay.getPathContext());
        sb.append("/");
        sb.append("webdav");
        Group group = themeDisplay.getScopeGroup();
        sb.append(group.getFriendlyURL());
        sb.append("/");
        sb.append(webDAVToken);
        sb.append("/");
        sb.append("Structures");
        sb.append("/");
        sb.append(this.getStructureId());
        return sb.toString();
    }

    public boolean hasField(String fieldName) {
        Map<String, DDMFormField> ddmFormFieldsMap = this.getFullHierarchyDDMFormFieldsMap(true);
        return ddmFormFieldsMap.containsKey(fieldName);
    }

    public boolean isFieldRepeatable(String fieldName) throws PortalException {
        DDMFormField ddmFormField = this.getDDMFormField(fieldName);
        return ddmFormField.isRepeatable();
    }

    public boolean isFieldTransient(String fieldName) throws PortalException {
        DDMFormField ddmFormField = this.getDDMFormField(fieldName);
        return Validator.isNull((String)ddmFormField.getDataType());
    }

    @Override
    public void prepareLocalizedFieldsForImport(Locale defaultImportLocale) throws LocaleException {
        super.prepareLocalizedFieldsForImport(defaultImportLocale);
        try {
            this.setDefinition(DDMStructureLocalServiceUtil.prepareLocalizedDefinitionForImport((DDMStructure)this, (Locale)defaultImportLocale));
        }
        catch (Exception e) {
            throw new LocaleException(2, (Throwable)e);
        }
    }

    @Override
    public void setClassName(String className) {
        this._className = className;
    }

    @Override
    public void setDDMForm(DDMForm ddmForm) {
        this._ddmForm = ddmForm;
    }

    @Override
    public void setDefinition(String definition) {
        super.setDefinition(definition);
        this._ddmForm = null;
    }

    protected List<DDMFormField> filterTransientDDMFormFields(List<DDMFormField> ddmFormFields) {
        PredicateFilter<DDMFormField> predicateFilter = new PredicateFilter<DDMFormField>(){

            public boolean filter(DDMFormField ddmFormField) {
                return !Validator.isNull((String)ddmFormField.getDataType());
            }
        };
        return ListUtil.filter(ddmFormFields, (PredicateFilter)predicateFilter);
    }

    protected List<String> getDDMFormFieldNames(List<DDMFormField> ddmFormFields) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (DDMFormField ddmFormField : ddmFormFields) {
            fieldNames.add(ddmFormField.getName());
        }
        return fieldNames;
    }

    protected DDMStructure getParentDDMStructure() throws PortalException {
        if (this.getParentStructureId() == 0L) {
            return null;
        }
        DDMStructure parentStructure = DDMStructureLocalServiceUtil.getStructure((long)this.getParentStructureId());
        return parentStructure;
    }
}

