/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.webdav;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.webdav.BaseResourceImpl;
import com.liferay.portal.kernel.webdav.WebDAVException;
import java.io.InputStream;

public class DDMStructureResourceImpl
extends BaseResourceImpl {
    private final DDMStructure _structure;

    public DDMStructureResourceImpl(DDMStructure structure, String parentPath, String name) {
        super(parentPath, name, structure.getName(structure.getDefaultLanguageId()), structure.getCreateDate(), structure.getModifiedDate(), (long)structure.getDefinition().getBytes().length);
        this.setModel(structure);
        this.setClassName(DDMStructure.class.getName());
        this.setPrimaryKey(structure.getPrimaryKey());
        this._structure = structure;
    }

    public InputStream getContentAsStream() throws WebDAVException {
        try {
            String definition = this._structure.getDefinition();
            return new UnsyncByteArrayInputStream(definition.getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    public String getContentType() {
        return "text/xml";
    }

    public boolean isCollection() {
        return false;
    }
}

