/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v2_0_6;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpgradeDDMDataProviderInstance
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(UpgradeDDMDataProviderInstance.class);
    private Map<Long, Map<String, String>> _ddmDataProviderInstanceOutputParametersInstanceId = new HashMap<Long, Map<String, String>>();
    private Map<String, Map<String, String>> _ddmDataProviderInstanceOutputParametersUUID = new HashMap<String, Map<String, String>>();
    private final JSONFactory _jsonFactory;
    private List<Long> _updatedStructureIds = new ArrayList<Long>();
    private List<Long> _updatedStructureVersionIds = new ArrayList<Long>();

    public UpgradeDDMDataProviderInstance(JSONFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
    }

    protected void doUpgrade() throws Exception {
        StringBundler sb = new StringBundler(2);
        sb.append("update DDMDataProviderInstance set definition = ? where ");
        sb.append("dataProviderInstanceId = ?");
        try (PreparedStatement ps1 = this.connection.prepareStatement("select * from DDMDataProviderInstance");
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)sb.toString());
             ResultSet rs = ps1.executeQuery();){
            while (rs.next()) {
                ps2.setString(1, this._updateDDMDataProviderInstance(rs.getLong("dataProviderInstanceId"), rs.getString("definition"), rs.getString("uuid_")));
                ps2.setLong(2, rs.getLong("dataProviderInstanceId"));
                ps2.addBatch();
            }
            ps2.executeBatch();
            this._updateDDMStructures();
        }
    }

    private long _extractDDMDataProviderInstanceId(String json) {
        try {
            JSONArray jsonArray = this._jsonFactory.createJSONArray(json);
            return jsonArray.getLong(0);
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e, (Throwable)e);
            }
            return 0L;
        }
    }

    private String _extractDDMDataProviderInstanceOutputName(String json) {
        try {
            JSONArray jsonArray = this._jsonFactory.createJSONArray(json);
            return jsonArray.getString(0);
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e, (Throwable)e);
            }
            return "";
        }
    }

    private String _updateDDMDataProviderInstance(long ddmDataProviderInstanceId, String definition, String uuid) throws JSONException {
        String instanceId = StringUtil.randomString();
        JSONObject definitionJSONObject = this._jsonFactory.createJSONObject(definition);
        JSONArray fieldValuesJSONArray = definitionJSONObject.getJSONArray("fieldValues");
        for (int i = 0; i < fieldValuesJSONArray.length(); ++i) {
            JSONObject fieldValueJSONObject = fieldValuesJSONArray.getJSONObject(i);
            if (!StringUtil.equals((String)fieldValueJSONObject.getString("name"), (String)"outputParameters")) continue;
            String outputParameterId = StringUtil.randomString();
            JSONArray nestedFieldValuesJSONArray = fieldValueJSONObject.getJSONArray("nestedFieldValues");
            this._updateDDMDataProviderInstanceOutputParameters(ddmDataProviderInstanceId, nestedFieldValuesJSONArray, outputParameterId, uuid);
            nestedFieldValuesJSONArray.put(JSONUtil.put((String)"instanceId", (Object)instanceId).put("name", "outputParameterId").put("value", outputParameterId));
        }
        return definitionJSONObject.toString();
    }

    private void _updateDDMDataProviderInstanceOutputParameters(long ddmDataProviderInstanceId, JSONArray fieldValuesJSONArray, String outputParameterId, String uuid) {
        Map outputParameters;
        JSONObject jsonObject;
        Map<String, String> ddmDataProviderInstanceOutputParameterValues = this._ddmDataProviderInstanceOutputParametersInstanceId.get(ddmDataProviderInstanceId);
        if (ddmDataProviderInstanceOutputParameterValues == null) {
            ddmDataProviderInstanceOutputParameterValues = new HashMap<String, String>();
            this._ddmDataProviderInstanceOutputParametersInstanceId.put(ddmDataProviderInstanceId, ddmDataProviderInstanceOutputParameterValues);
            this._ddmDataProviderInstanceOutputParametersUUID.put(uuid, ddmDataProviderInstanceOutputParameterValues);
        }
        if ((jsonObject = (JSONObject)(outputParameters = JSONUtil.toJSONObjectMap((JSONArray)fieldValuesJSONArray, (String)"name")).get("outputParameterName")) != null) {
            ddmDataProviderInstanceOutputParameterValues.put(jsonObject.getString("value"), outputParameterId);
        }
    }

    private boolean _updateDDMDataProviderRules(JSONArray rulesJSONArray) {
        boolean updated = false;
        for (int i = 0; i < rulesJSONArray.length(); ++i) {
            JSONObject ruleJSONObject = rulesJSONArray.getJSONObject(i);
            JSONArray newActionsJSONArray = this._jsonFactory.createJSONArray();
            List actions = JSONUtil.toStringList((JSONArray)ruleJSONObject.getJSONArray("actions"));
            for (String action : actions) {
                if (action.startsWith("call")) {
                    String[] arguments = StringUtil.split((String)action, (String)"', '");
                    String uuid = arguments[0].substring(6);
                    Map<String, String> ddmDataProviderOutputParameters = this._ddmDataProviderInstanceOutputParametersUUID.get(uuid);
                    String actionOutputsString = arguments[2].substring(0, arguments[2].length() - 2);
                    String[] actionOutputs = StringUtil.split((String)actionOutputsString, (char)';');
                    String newActionOutputsString = "";
                    for (String actionOutput : actionOutputs) {
                        String[] actionOutputParts = StringUtil.split((String)actionOutput, (char)'=');
                        newActionOutputsString = StringBundler.concat((Object[])new Object[]{newActionOutputsString, actionOutputParts[0], Character.valueOf('='), ddmDataProviderOutputParameters.get(actionOutputParts[1]), Character.valueOf(';')});
                    }
                    if (newActionOutputsString.length() > 0) {
                        newActionOutputsString = newActionOutputsString.substring(0, newActionOutputsString.length() - 1);
                    }
                    action = StringBundler.concat((String[])new String[]{"call('", uuid, "', '", arguments[1], "', '", newActionOutputsString, "')"});
                    updated = updated || !newActionOutputsString.equals(actionOutputsString);
                }
                newActionsJSONArray.put(action);
            }
            ruleJSONObject.put("actions", newActionsJSONArray);
        }
        return updated;
    }

    private void _updateDDMStructures() throws Exception {
        StringBundler sb1 = new StringBundler(2);
        sb1.append("update DDMStructure set definition = ? where structureId ");
        sb1.append("= ?");
        PreparedStatement ps1 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)sb1.toString());
        StringBundler sb2 = new StringBundler(2);
        sb2.append("update DDMStructureVersion set definition = ? where ");
        sb2.append("structureVersionId = ?");
        PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)sb2.toString());
        StringBundler sb3 = new StringBundler(8);
        sb3.append("select structureVersionId, DDMStructure.structureId, ");
        sb3.append("DDMStructureVersion.definition from ");
        sb3.append("DDMDataProviderInstanceLink join DDMStructureVersion on ");
        sb3.append("DDMStructureVersion.structureId = ");
        sb3.append("DDMDataProviderInstanceLink.structureId left join ");
        sb3.append("DDMStructure on DDMStructure.structureId = ");
        sb3.append("DDMDataProviderInstanceLink.structureId and ");
        sb3.append("DDMStructure.version = DDMStructureVersion.version");
        PreparedStatement ps3 = this.connection.prepareStatement(sb3.toString());
        ResultSet rs3 = ps3.executeQuery();
        while (rs3.next()) {
            long structureId;
            JSONObject jsonObject = this._jsonFactory.createJSONObject(rs3.getString("definition"));
            boolean rulesUpdated = false;
            JSONArray rulesJSONArray = jsonObject.getJSONArray("rules");
            if (rulesJSONArray != null) {
                rulesUpdated = this._updateDDMDataProviderRules(rulesJSONArray);
            }
            boolean fieldsUpdated = false;
            JSONArray fieldsJSONArray = jsonObject.getJSONArray("fields");
            if (fieldsJSONArray != null) {
                fieldsUpdated = this._updateFieldsWithDataProviderAssigned(fieldsJSONArray);
            }
            long structureVersionId = rs3.getLong("structureVersionId");
            if ((rulesUpdated || fieldsUpdated) && !this._updatedStructureVersionIds.contains(structureVersionId)) {
                ps2.setString(1, jsonObject.toString());
                ps2.setLong(2, structureVersionId);
                ps2.addBatch();
                this._updatedStructureVersionIds.add(structureVersionId);
            }
            if ((structureId = rs3.getLong("structureId")) <= 0L || this._updatedStructureIds.contains(structureId)) continue;
            ps1.setString(1, jsonObject.toString());
            ps1.setLong(2, structureId);
            ps1.addBatch();
            this._updatedStructureIds.add(structureId);
        }
        ps2.executeBatch();
        ps1.executeBatch();
    }

    private boolean _updateFieldsWithDataProviderAssigned(JSONArray fieldsJSONArray) {
        boolean updated = false;
        for (int i = 0; i < fieldsJSONArray.length(); ++i) {
            long ddmDataProviderInstanceId;
            JSONObject fieldJSONObject = fieldsJSONArray.getJSONObject(i);
            if (!StringUtil.equals((String)fieldJSONObject.getString("dataSourceType"), (String)"data-provider") || !this._ddmDataProviderInstanceOutputParametersInstanceId.containsKey(ddmDataProviderInstanceId = this._extractDDMDataProviderInstanceId(fieldJSONObject.getString("ddmDataProviderInstanceId")))) continue;
            String ddmDataProviderInstanceOutputName = this._extractDDMDataProviderInstanceOutputName(fieldJSONObject.getString("ddmDataProviderInstanceOutput"));
            Map<String, String> ddmDataProviderOutputParameters = this._ddmDataProviderInstanceOutputParametersInstanceId.get(ddmDataProviderInstanceId);
            String outputParameterId = ddmDataProviderOutputParameters.get(ddmDataProviderInstanceOutputName);
            fieldJSONObject.put("ddmDataProviderInstanceOutput", "[\"" + outputParameterId + "\"]");
            updated = true;
        }
        return updated;
    }
}

