/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v1_1_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradeDataProviderInstance
extends UpgradeProcess {
    private final JSONFactory _jsonFactory;

    public UpgradeDataProviderInstance(JSONFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
    }

    protected void doUpgrade() throws Exception {
        StringBundler sb = new StringBundler(3);
        sb.append("select DDMDataProviderInstance.definition, ");
        sb.append("DDMDataProviderInstance.dataProviderInstanceId from ");
        sb.append("DDMDataProviderInstance");
        try (PreparedStatement ps1 = this.connection.prepareStatement(sb.toString());
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMDataProviderInstance set definition = ? where dataProviderInstanceId = ?");
             ResultSet rs = ps1.executeQuery();){
            while (rs.next()) {
                String definition = rs.getString(1);
                long dataProviderInstanceId = rs.getLong(2);
                String newDefinition = this.upgradeDataProviderInstanceDefinition(definition);
                ps2.setString(1, newDefinition);
                ps2.setLong(2, dataProviderInstanceId);
                ps2.addBatch();
            }
            ps2.executeBatch();
        }
    }

    protected String upgradeDataProviderInstanceDefinition(String definition) throws JSONException {
        JSONObject definitionJSONObject = this._jsonFactory.createJSONObject(definition);
        JSONArray fieldValuesJSONArray = definitionJSONObject.getJSONArray("fieldValues");
        this.upgradeDataProviderInstanceFieldValues(fieldValuesJSONArray);
        return definitionJSONObject.toString();
    }

    protected void upgradeDataProviderInstanceFieldValues(JSONArray fieldValuesJSONArray) {
        JSONObject fieldValueJSONObject = this._jsonFactory.createJSONObject();
        fieldValueJSONObject.put("instanceId", StringUtil.randomString((int)8));
        fieldValueJSONObject.put("name", "filterable");
        fieldValueJSONObject.put("value", "false");
        fieldValuesJSONArray.put(fieldValueJSONObject);
        fieldValueJSONObject = this._jsonFactory.createJSONObject();
        fieldValueJSONObject.put("instanceId", StringUtil.randomString((int)8));
        fieldValueJSONObject.put("name", "filterParameterName");
        fieldValueJSONObject.put("value", "");
        fieldValuesJSONArray.put(fieldValueJSONObject);
    }
}

