/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.impl;

import com.liferay.dynamic.data.mapping.model.DDMDataProviderInstance;
import com.liferay.dynamic.data.mapping.service.base.DDMDataProviderInstanceServiceBaseImpl;
import com.liferay.dynamic.data.mapping.service.permission.DDMDataProviderInstancePermission;
import com.liferay.dynamic.data.mapping.service.permission.DDMDataProviderPermission;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DDMDataProviderInstanceServiceImpl
extends DDMDataProviderInstanceServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(DDMDataProviderInstanceServiceImpl.class);

    public DDMDataProviderInstance addDataProviderInstance(long groupId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, DDMFormValues ddmFormValues, String type, ServiceContext serviceContext) throws PortalException {
        DDMDataProviderPermission.check(this.getPermissionChecker(), groupId, "ADD_DATA_PROVIDER_INSTANCE");
        return this.ddmDataProviderInstanceLocalService.addDataProviderInstance(this.getUserId(), groupId, nameMap, descriptionMap, ddmFormValues, type, serviceContext);
    }

    public void deleteDataProviderInstance(long dataProviderInstanceId) throws PortalException {
        DDMDataProviderInstancePermission.check(this.getPermissionChecker(), dataProviderInstanceId, "DELETE");
        this.ddmDataProviderInstanceLocalService.deleteDataProviderInstance(dataProviderInstanceId);
    }

    public DDMDataProviderInstance fetchDataProviderInstance(long dataProviderInstanceId) throws PortalException {
        DDMDataProviderInstance dataProviderInstance = this.ddmDataProviderInstanceLocalService.fetchDataProviderInstance(dataProviderInstanceId);
        if (dataProviderInstance == null) {
            return null;
        }
        DDMDataProviderInstancePermission.check(this.getPermissionChecker(), dataProviderInstance.getDataProviderInstanceId(), "VIEW");
        return dataProviderInstance;
    }

    public DDMDataProviderInstance getDataProviderInstance(long dataProviderInstanceId) throws PortalException {
        DDMDataProviderInstancePermission.check(this.getPermissionChecker(), dataProviderInstanceId, "VIEW");
        return this.ddmDataProviderInstanceLocalService.getDataProviderInstance(dataProviderInstanceId);
    }

    public List<DDMDataProviderInstance> search(long companyId, long[] groupIds, String keywords, int start, int end, OrderByComparator<DDMDataProviderInstance> orderByComparator) {
        List ddmDataProviderInstances = this.ddmDataProviderInstanceFinder.filterByKeywords(companyId, groupIds, keywords, start, end, orderByComparator);
        Stream ddmDataProviderInstanceStream = ddmDataProviderInstances.stream();
        return ddmDataProviderInstanceStream.filter(ddmDataProviderInstance -> {
            try {
                return DDMDataProviderInstancePermission.contains(this.getPermissionChecker(), ddmDataProviderInstance.getDataProviderInstanceId(), "VIEW");
            }
            catch (PortalException portalException) {
                _log.error((Object)portalException, (Throwable)portalException);
                return false;
            }
        }).map(ddmDataProviderInstance -> this._removeAuthenticationData((DDMDataProviderInstance)ddmDataProviderInstance)).collect(Collectors.toList());
    }

    public List<DDMDataProviderInstance> search(long companyId, long[] groupIds, String name, String description, boolean andOperator, int start, int end, OrderByComparator<DDMDataProviderInstance> orderByComparator) {
        return this.ddmDataProviderInstanceFinder.filterFindByC_G_N_D(companyId, groupIds, name, description, andOperator, start, end, orderByComparator);
    }

    public int searchCount(long companyId, long[] groupIds, String keywords) {
        return this.ddmDataProviderInstanceFinder.filterCountByKeywords(companyId, groupIds, keywords);
    }

    public int searchCount(long companyId, long[] groupIds, String name, String description, boolean andOperator) {
        return this.ddmDataProviderInstanceFinder.filterCountByC_G_N_D(companyId, groupIds, name, description, andOperator);
    }

    public DDMDataProviderInstance updateDataProviderInstance(long dataProviderInstanceId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, DDMFormValues ddmFormValues, ServiceContext serviceContext) throws PortalException {
        DDMDataProviderInstancePermission.check(this.getPermissionChecker(), dataProviderInstanceId, "UPDATE");
        return this.ddmDataProviderInstanceLocalService.updateDataProviderInstance(this.getUserId(), dataProviderInstanceId, nameMap, descriptionMap, ddmFormValues, serviceContext);
    }

    private JSONArray _filterFieldValues(JSONArray fieldValuesJSONArray) {
        JSONArray filteredFieldValuesJSONArray = JSONFactoryUtil.createJSONArray();
        for (JSONObject fieldValueJSONObject : fieldValuesJSONArray) {
            String fieldValueName = fieldValueJSONObject.getString("name");
            if (StringUtil.equals((String)fieldValueName, (String)"password") || StringUtil.equals((String)fieldValueName, (String)"username")) continue;
            filteredFieldValuesJSONArray.put(fieldValueJSONObject);
        }
        return filteredFieldValuesJSONArray;
    }

    private DDMDataProviderInstance _removeAuthenticationData(DDMDataProviderInstance ddmDataProviderInstance) {
        block3: {
            try {
                JSONObject definitionJSONObject = JSONFactoryUtil.createJSONObject((String)ddmDataProviderInstance.getDefinition());
                if (!definitionJSONObject.has("fieldValues")) {
                    return ddmDataProviderInstance;
                }
                JSONArray fieldValuesJSONArray = definitionJSONObject.getJSONArray("fieldValues");
                definitionJSONObject.put("fieldValues", this._filterFieldValues(fieldValuesJSONArray));
                ddmDataProviderInstance.setDefinition(definitionJSONObject.toJSONString());
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)"Unable to remove authentication data from data providers search", (Throwable)exception);
            }
        }
        return ddmDataProviderInstance;
    }
}

