/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.impl;

import com.liferay.dynamic.data.mapping.configuration.DDMGroupServiceConfiguration;
import com.liferay.dynamic.data.mapping.exception.InvalidTemplateVersionException;
import com.liferay.dynamic.data.mapping.exception.NoSuchTemplateException;
import com.liferay.dynamic.data.mapping.exception.RequiredTemplateException;
import com.liferay.dynamic.data.mapping.exception.TemplateDuplicateTemplateKeyException;
import com.liferay.dynamic.data.mapping.exception.TemplateNameException;
import com.liferay.dynamic.data.mapping.exception.TemplateScriptException;
import com.liferay.dynamic.data.mapping.exception.TemplateSmallImageNameException;
import com.liferay.dynamic.data.mapping.exception.TemplateSmallImageSizeException;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.model.DDMTemplateVersion;
import com.liferay.dynamic.data.mapping.service.base.DDMTemplateLocalServiceBaseImpl;
import com.liferay.dynamic.data.mapping.service.permission.DDMTemplatePermission;
import com.liferay.dynamic.data.mapping.util.DDMXML;
import com.liferay.petra.xml.XMLUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DDMTemplateLocalServiceImpl
extends DDMTemplateLocalServiceBaseImpl {
    @ServiceReference(type=ConfigurationProvider.class)
    protected ConfigurationProvider configurationProvider;
    @ServiceReference(type=DDMXML.class)
    protected DDMXML ddmXML;
    private static final Log _log = LogFactoryUtil.getLog(DDMTemplateLocalServiceImpl.class);

    public DDMTemplate addTemplate(long userId, long groupId, long classNameId, long classPK, long resourceClassNameId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, String mode, String language, String script, ServiceContext serviceContext) throws PortalException {
        return this.addTemplate(userId, groupId, classNameId, classPK, resourceClassNameId, null, nameMap, descriptionMap, type, mode, language, script, false, false, null, null, serviceContext);
    }

    public DDMTemplate addTemplate(long userId, long groupId, long classNameId, long classPK, long resourceClassNameId, String templateKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, String mode, String language, String script, boolean cacheable, boolean smallImage, String smallImageURL, File smallImageFile, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        templateKey = Validator.isNull((String)templateKey) ? String.valueOf(this.counterLocalService.increment()) : StringUtil.toUpperCase((String)templateKey.trim());
        script = this.formatScript(type, language, script);
        byte[] smallImageBytes = null;
        if (smallImage) {
            try {
                smallImageBytes = FileUtil.getBytes((File)smallImageFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (smallImageBytes == null || Validator.isUrl((String)smallImageURL)) {
                smallImage = false;
            }
        }
        this.validate(groupId, classNameId, templateKey, nameMap, script, smallImage, smallImageURL, smallImageFile, smallImageBytes);
        long templateId = this.counterLocalService.increment();
        DDMTemplate template = this.ddmTemplatePersistence.create(templateId);
        template.setUuid(serviceContext.getUuid());
        template.setGroupId(groupId);
        template.setCompanyId(user.getCompanyId());
        template.setUserId(user.getUserId());
        template.setUserName(user.getFullName());
        template.setVersionUserId(user.getUserId());
        template.setVersionUserName(user.getFullName());
        template.setClassNameId(classNameId);
        template.setClassPK(classPK);
        template.setResourceClassNameId(resourceClassNameId);
        template.setTemplateKey(templateKey);
        template.setVersion("1.0");
        template.setNameMap(nameMap);
        template.setDescriptionMap(descriptionMap);
        template.setType(type);
        template.setMode(mode);
        template.setLanguage(language);
        template.setScript(script);
        template.setCacheable(cacheable);
        template.setSmallImage(smallImage);
        template.setSmallImageId(this.counterLocalService.increment());
        template.setSmallImageURL(smallImageURL);
        template = (DDMTemplate)this.ddmTemplatePersistence.update((BaseModel)template);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addTemplateResources(template, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addTemplateResources(template, serviceContext.getModelPermissions());
        }
        this.saveImages(smallImage, template.getSmallImageId(), smallImageFile, smallImageBytes);
        this.addTemplateVersion(user, template, "1.0", serviceContext);
        return template;
    }

    public void addTemplateResources(DDMTemplate template, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        String resourceName = DDMTemplatePermission.getTemplateModelResourceName(template.getResourceClassNameId());
        this.resourceLocalService.addResources(template.getCompanyId(), template.getGroupId(), template.getUserId(), resourceName, template.getTemplateId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addTemplateResources(DDMTemplate template, ModelPermissions modelPermissions) throws PortalException {
        String resourceName = DDMTemplatePermission.getTemplateModelResourceName(template.getResourceClassNameId());
        this.resourceLocalService.addModelResources(template.getCompanyId(), template.getGroupId(), template.getUserId(), resourceName, template.getTemplateId(), modelPermissions);
    }

    public DDMTemplate copyTemplate(long userId, long templateId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, ServiceContext serviceContext) throws PortalException {
        DDMTemplate template = this.ddmTemplatePersistence.findByPrimaryKey(templateId);
        return this.copyTemplate(userId, template, template.getClassPK(), nameMap, descriptionMap, serviceContext);
    }

    public DDMTemplate copyTemplate(long userId, long templateId, ServiceContext serviceContext) throws PortalException {
        DDMTemplate template = this.ddmTemplatePersistence.findByPrimaryKey(templateId);
        return this.copyTemplate(userId, template, template.getClassPK(), template.getNameMap(), template.getDescriptionMap(), serviceContext);
    }

    public List<DDMTemplate> copyTemplates(long userId, long classNameId, long oldClassPK, long newClassPK, String type, ServiceContext serviceContext) throws PortalException {
        ArrayList<DDMTemplate> newTemplates = new ArrayList<DDMTemplate>();
        List oldTemplates = this.ddmTemplatePersistence.findByC_C_T(classNameId, oldClassPK, type);
        for (DDMTemplate oldTemplate : oldTemplates) {
            DDMTemplate newTemplate = this.copyTemplate(userId, oldTemplate, newClassPK, oldTemplate.getNameMap(), oldTemplate.getDescriptionMap(), serviceContext);
            newTemplates.add(newTemplate);
        }
        return newTemplates;
    }

    @SystemEvent(type=1)
    public void deleteTemplate(DDMTemplate template) throws PortalException {
        if (!CompanyThreadLocal.isDeleteInProcess() && this.ddmTemplateLinkPersistence.countByTemplateId(template.getTemplateId()) > 0) {
            throw new RequiredTemplateException.MustNotDeleteTemplateReferencedByTemplateLinks(template.getTemplateId());
        }
        this.ddmTemplatePersistence.remove((BaseModel)template);
        String resourceName = DDMTemplatePermission.getTemplateModelResourceName(template.getResourceClassNameId());
        this.resourceLocalService.deleteResource(template.getCompanyId(), resourceName, 4, template.getTemplateId());
        this.ddmTemplateVersionPersistence.removeByTemplateId(template.getTemplateId());
    }

    public void deleteTemplate(long templateId) throws PortalException {
        DDMTemplate template = this.ddmTemplatePersistence.findByPrimaryKey(templateId);
        this.ddmTemplateLocalService.deleteTemplate(template);
    }

    public void deleteTemplates(long groupId) throws PortalException {
        List templates = this.ddmTemplatePersistence.findByGroupId(groupId);
        for (DDMTemplate template : templates) {
            this.ddmTemplateLocalService.deleteTemplate(template);
        }
    }

    public void deleteTemplates(long groupId, long classNameId) throws PortalException {
        List templates = this.ddmTemplatePersistence.findByG_C(groupId, classNameId);
        for (DDMTemplate template : templates) {
            this.ddmTemplateLocalService.deleteTemplate(template);
        }
    }

    public DDMTemplate fetchTemplate(long templateId) {
        return this.ddmTemplatePersistence.fetchByPrimaryKey(templateId);
    }

    public DDMTemplate fetchTemplate(long groupId, long classNameId, String templateKey) {
        templateKey = StringUtil.toUpperCase((String)StringUtil.trim((String)templateKey));
        return this.ddmTemplatePersistence.fetchByG_C_T(groupId, classNameId, templateKey);
    }

    public DDMTemplate fetchTemplate(long groupId, long classNameId, String templateKey, boolean includeAncestorTemplates) throws PortalException {
        DDMTemplate template = this.ddmTemplatePersistence.fetchByG_C_T(groupId, classNameId, templateKey = StringUtil.toUpperCase((String)StringUtil.trim((String)templateKey)));
        if (template != null) {
            return template;
        }
        if (!includeAncestorTemplates) {
            return null;
        }
        for (long ancestorSiteGroupId : PortalUtil.getAncestorSiteGroupIds((long)groupId)) {
            template = this.ddmTemplatePersistence.fetchByG_C_T(ancestorSiteGroupId, classNameId, templateKey);
            if (template == null) continue;
            return template;
        }
        return null;
    }

    public DDMTemplate getTemplate(long templateId) throws PortalException {
        return this.ddmTemplatePersistence.findByPrimaryKey(templateId);
    }

    public DDMTemplate getTemplate(long groupId, long classNameId, String templateKey) throws PortalException {
        templateKey = StringUtil.toUpperCase((String)StringUtil.trim((String)templateKey));
        return this.ddmTemplatePersistence.findByG_C_T(groupId, classNameId, templateKey);
    }

    public DDMTemplate getTemplate(long groupId, long classNameId, String templateKey, boolean includeAncestorTemplates) throws PortalException {
        DDMTemplate template = this.ddmTemplatePersistence.fetchByG_C_T(groupId, classNameId, templateKey = StringUtil.toUpperCase((String)StringUtil.trim((String)templateKey)));
        if (template != null) {
            return template;
        }
        if (!includeAncestorTemplates) {
            throw new NoSuchTemplateException("No DDMTemplate exists with the template key " + templateKey);
        }
        for (long ancestorSiteGroupId : PortalUtil.getAncestorSiteGroupIds((long)groupId)) {
            template = this.ddmTemplatePersistence.fetchByG_C_T(ancestorSiteGroupId, classNameId, templateKey);
            if (template == null) continue;
            return template;
        }
        throw new NoSuchTemplateException("No DDMTemplate exists with the template key " + templateKey + " in the ancestor groups");
    }

    public DDMTemplate getTemplateBySmallImageId(long smallImageId) throws PortalException {
        return this.ddmTemplatePersistence.findBySmallImageId(smallImageId);
    }

    public List<DDMTemplate> getTemplates(long classPK) {
        return this.ddmTemplatePersistence.findByClassPK(classPK);
    }

    public List<DDMTemplate> getTemplates(long groupId, long classNameId) {
        return this.ddmTemplatePersistence.findByG_C(groupId, classNameId);
    }

    public List<DDMTemplate> getTemplates(long groupId, long classNameId, long classPK) {
        return this.ddmTemplatePersistence.findByG_C_C(groupId, classNameId, classPK);
    }

    public List<DDMTemplate> getTemplates(long groupId, long classNameId, long classPK, boolean includeAncestorTemplates) throws PortalException {
        ArrayList<DDMTemplate> ddmTemplates = new ArrayList<DDMTemplate>();
        ddmTemplates.addAll(this.ddmTemplatePersistence.findByG_C_C(groupId, classNameId, classPK));
        if (!includeAncestorTemplates) {
            return ddmTemplates;
        }
        ddmTemplates.addAll(this.ddmTemplatePersistence.findByG_C_C(PortalUtil.getAncestorSiteGroupIds((long)groupId), classNameId, classPK));
        return ddmTemplates;
    }

    public List<DDMTemplate> getTemplates(long groupId, long classNameId, long classPK, String type) {
        return this.ddmTemplatePersistence.findByG_C_C_T(groupId, classNameId, classPK, type);
    }

    public List<DDMTemplate> getTemplates(long groupId, long classNameId, long classPK, String type, String mode) {
        return this.ddmTemplatePersistence.findByG_C_C_T_M(groupId, classNameId, classPK, type, mode);
    }

    public List<DDMTemplate> getTemplates(long[] groupIds, long classNameId, long classPK) {
        return this.ddmTemplatePersistence.findByG_C_C(groupIds, classNameId, classPK);
    }

    public List<DDMTemplate> getTemplatesByClassPK(long groupId, long classPK) {
        return this.ddmTemplatePersistence.findByG_CPK(groupId, classPK);
    }

    public List<DDMTemplate> getTemplatesByClassPK(long groupId, long classPK, int start, int end) {
        return this.ddmTemplatePersistence.findByG_CPK(groupId, classPK, start, end);
    }

    public List<DDMTemplate> getTemplatesByClassPK(long[] groupIds, long classPK) {
        return this.ddmTemplatePersistence.findByG_CPK(groupIds, classPK);
    }

    public int getTemplatesByClassPKCount(long groupId, long classPK) {
        return this.ddmTemplatePersistence.countByG_CPK(groupId, classPK);
    }

    public List<DDMTemplate> getTemplatesByStructureClassNameId(long groupId, long structureClassNameId, int status, int start, int end, OrderByComparator<DDMTemplate> orderByComparator) {
        return this.ddmTemplateFinder.findByG_SC_S(groupId, structureClassNameId, status, start, end, orderByComparator);
    }

    public int getTemplatesByStructureClassNameIdCount(long groupId, long structureClassNameId, int status) {
        return this.ddmTemplateFinder.countByG_SC_S(groupId, structureClassNameId, status);
    }

    public int getTemplatesCount(long groupId) {
        return this.ddmTemplatePersistence.countByGroupId(groupId);
    }

    public int getTemplatesCount(long groupId, long classNameId) {
        return this.ddmTemplatePersistence.countByG_C(groupId, classNameId);
    }

    public int getTemplatesCount(long groupId, long classNameId, long classPK) {
        return this.ddmTemplatePersistence.countByG_C_C(groupId, classNameId, classPK);
    }

    public void revertTemplate(long userId, long templateId, String version, ServiceContext serviceContext) throws PortalException {
        DDMTemplateVersion templateVersion = this.ddmTemplateVersionLocalService.getTemplateVersion(templateId, version);
        if (!templateVersion.isApproved()) {
            throw new InvalidTemplateVersionException("Unable to revert from an unapproved template version");
        }
        DDMTemplate template = templateVersion.getTemplate();
        serviceContext.setAttribute("majorVersion", (Serializable)Boolean.TRUE);
        serviceContext.setAttribute("status", (Serializable)Integer.valueOf(0));
        serviceContext.setCommand("revert");
        this.ddmTemplateLocalService.updateTemplate(userId, templateId, templateVersion.getClassPK(), templateVersion.getNameMap(), templateVersion.getDescriptionMap(), template.getType(), template.getMode(), templateVersion.getLanguage(), templateVersion.getScript(), template.isCacheable(), serviceContext);
    }

    public List<DDMTemplate> search(long companyId, long groupId, long classNameId, long classPK, long resourceClassNameId, String keywords, String type, String mode, int status, int start, int end, OrderByComparator<DDMTemplate> orderByComparator) {
        return this.ddmTemplateFinder.findByKeywords(companyId, groupId, classNameId, classPK, resourceClassNameId, keywords, type, mode, status, start, end, orderByComparator);
    }

    public List<DDMTemplate> search(long companyId, long groupId, long classNameId, long classPK, long resourceClassNameId, String name, String description, String type, String mode, String language, int status, boolean andOperator, int start, int end, OrderByComparator<DDMTemplate> orderByComparator) {
        return this.ddmTemplateFinder.findByC_G_C_C_R_N_D_T_M_L_S(companyId, groupId, classNameId, classPK, resourceClassNameId, name, description, type, mode, language, status, andOperator, start, end, orderByComparator);
    }

    public List<DDMTemplate> search(long companyId, long[] groupIds, long[] classNameIds, long[] classPKs, long resourceClassNameId, String keywords, String type, String mode, int status, int start, int end, OrderByComparator<DDMTemplate> orderByComparator) {
        return this.ddmTemplateFinder.findByKeywords(companyId, groupIds, classNameIds, classPKs, resourceClassNameId, keywords, type, mode, status, start, end, orderByComparator);
    }

    public List<DDMTemplate> search(long companyId, long[] groupIds, long[] classNameIds, long[] classPKs, long resourceClassNameId, String name, String description, String type, String mode, String language, int status, boolean andOperator, int start, int end, OrderByComparator<DDMTemplate> orderByComparator) {
        return this.ddmTemplateFinder.findByC_G_C_C_R_N_D_T_M_L_S(companyId, groupIds, classNameIds, classPKs, resourceClassNameId, name, description, type, mode, language, status, andOperator, start, end, orderByComparator);
    }

    public int searchCount(long companyId, long groupId, long classNameId, long classPK, long resourceClassNameId, String keywords, String type, String mode, int status) {
        return this.ddmTemplateFinder.countByKeywords(companyId, groupId, classNameId, classPK, resourceClassNameId, keywords, type, mode, status);
    }

    public int searchCount(long companyId, long groupId, long classNameId, long classPK, long resourceClassNameId, String name, String description, String type, String mode, String language, int status, boolean andOperator) {
        return this.ddmTemplateFinder.countByC_G_C_C_R_N_D_T_M_L_S(companyId, groupId, classNameId, classPK, resourceClassNameId, name, description, type, mode, language, status, andOperator);
    }

    public int searchCount(long companyId, long[] groupIds, long[] classNameIds, long[] classPKs, long resourceClassNameId, String keywords, String type, String mode, int status) {
        return this.ddmTemplateFinder.countByKeywords(companyId, groupIds, classNameIds, classPKs, resourceClassNameId, keywords, type, mode, status);
    }

    public int searchCount(long companyId, long[] groupIds, long[] classNameIds, long[] classPKs, long resourceClassNameId, String name, String description, String type, String mode, String language, int status, boolean andOperator) {
        return this.ddmTemplateFinder.countByC_G_C_C_R_N_D_T_M_L_S(companyId, groupIds, classNameIds, classPKs, resourceClassNameId, name, description, type, mode, language, status, andOperator);
    }

    public DDMTemplate updateTemplate(long userId, long templateId, long classPK, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, String mode, String language, String script, boolean cacheable, boolean smallImage, String smallImageURL, File smallImageFile, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        script = this.formatScript(type, language, script);
        byte[] smallImageBytes = null;
        try {
            smallImageBytes = FileUtil.getBytes((File)smallImageFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        DDMTemplate template = this.ddmTemplateLocalService.getDDMTemplate(templateId);
        this.validate(template.getGroupId(), nameMap, script, smallImage, smallImageURL, smallImageFile, smallImageBytes);
        if (template.getClassPK() == 0L && classPK > 0L) {
            template.setClassPK(classPK);
        }
        DDMTemplateVersion latestTemplateVersion = this.ddmTemplateVersionLocalService.getLatestTemplateVersion(templateId);
        boolean majorVersion = GetterUtil.getBoolean((Object)serviceContext.getAttribute("majorVersion"));
        String version = this.getNextVersion(latestTemplateVersion.getVersion(), majorVersion);
        template.setVersion(version);
        template.setVersionUserId(user.getUserId());
        template.setVersionUserName(user.getFullName());
        template.setNameMap(nameMap);
        template.setDescriptionMap(descriptionMap);
        template.setType(type);
        template.setMode(mode);
        template.setLanguage(language);
        template.setScript(script);
        template.setCacheable(cacheable);
        template.setSmallImage(smallImage);
        template.setSmallImageURL(smallImageURL);
        this.saveImages(smallImage, template.getSmallImageId(), smallImageFile, smallImageBytes);
        DDMTemplateVersion ddmTemplateVersion = this.addTemplateVersion(user, template, version, serviceContext);
        if (ddmTemplateVersion.isApproved()) {
            template = (DDMTemplate)this.ddmTemplatePersistence.update((BaseModel)template);
        }
        return template;
    }

    public DDMTemplate updateTemplate(long userId, long templateId, long classPK, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, String mode, String language, String script, boolean cacheable, ServiceContext serviceContext) throws PortalException {
        DDMTemplate template = this.ddmTemplateLocalService.getDDMTemplate(templateId);
        File smallImageFile = this.getSmallImageFile(template);
        return this.updateTemplate(userId, templateId, classPK, nameMap, descriptionMap, type, mode, language, script, cacheable, template.isSmallImage(), template.getSmallImageURL(), smallImageFile, serviceContext);
    }

    protected DDMTemplateVersion addTemplateVersion(User user, DDMTemplate template, String version, ServiceContext serviceContext) {
        long templateVersionId = this.counterLocalService.increment();
        DDMTemplateVersion templateVersion = this.ddmTemplateVersionPersistence.create(templateVersionId);
        templateVersion.setGroupId(template.getGroupId());
        templateVersion.setCompanyId(template.getCompanyId());
        templateVersion.setUserId(template.getUserId());
        templateVersion.setUserName(template.getUserName());
        templateVersion.setCreateDate(template.getModifiedDate());
        templateVersion.setClassNameId(template.getClassNameId());
        templateVersion.setClassPK(template.getClassPK());
        templateVersion.setTemplateId(template.getTemplateId());
        templateVersion.setVersion(version);
        templateVersion.setName(template.getName());
        templateVersion.setDescription(template.getDescription());
        templateVersion.setLanguage(template.getLanguage());
        templateVersion.setScript(template.getScript());
        int status = GetterUtil.getInteger((Object)serviceContext.getAttribute("status"), (int)0);
        templateVersion.setStatus(status);
        templateVersion.setStatusByUserId(user.getUserId());
        templateVersion.setStatusByUserName(user.getFullName());
        templateVersion.setStatusDate(template.getModifiedDate());
        return (DDMTemplateVersion)this.ddmTemplateVersionPersistence.update((BaseModel)templateVersion);
    }

    protected DDMTemplate copyTemplate(long userId, DDMTemplate template, long classPK, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, ServiceContext serviceContext) throws PortalException {
        File smallImageFile = this.getSmallImageFile(template);
        return this.addTemplate(userId, template.getGroupId(), template.getClassNameId(), classPK, template.getResourceClassNameId(), null, nameMap, descriptionMap, template.getType(), template.getMode(), template.getLanguage(), template.getScript(), template.isCacheable(), template.isSmallImage(), template.getSmallImageURL(), smallImageFile, serviceContext);
    }

    protected String formatScript(String type, String language, String script) throws PortalException {
        if (language.equals("xsl")) {
            try {
                script = this.ddmXML.validateXML(script);
            }
            catch (PortalException pe) {
                throw new TemplateScriptException((Throwable)pe);
            }
            script = XMLUtil.formatXML((String)script);
        }
        return script;
    }

    protected DDMGroupServiceConfiguration getDDMGroupServiceConfiguration(long groupId) throws ConfigurationException {
        return (DDMGroupServiceConfiguration)this.configurationProvider.getConfiguration(DDMGroupServiceConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(groupId, "com.liferay.dynamic.data.mapping"));
    }

    protected String getNextVersion(String version, boolean majorVersion) {
        int[] versionParts = StringUtil.split((String)version, (String)".", (int)0);
        if (majorVersion) {
            versionParts[0] = versionParts[0] + 1;
            versionParts[1] = 0;
        } else {
            versionParts[1] = versionParts[1] + 1;
        }
        return versionParts[0] + "." + versionParts[1];
    }

    protected File getSmallImageFile(DDMTemplate template) {
        Image smallImage;
        File smallImageFile = null;
        if (template.isSmallImage() && Validator.isNull((String)template.getSmallImageURL()) && (smallImage = this.imageLocalService.fetchImage(template.getSmallImageId())) != null) {
            smallImageFile = FileUtil.createTempFile((String)smallImage.getType());
            try {
                FileUtil.write((File)smallImageFile, (byte[])smallImage.getTextObj());
            }
            catch (IOException ioe) {
                _log.error((Object)ioe, (Throwable)ioe);
            }
        }
        return smallImageFile;
    }

    protected void saveImages(boolean smallImage, long smallImageId, File smallImageFile, byte[] smallImageBytes) throws PortalException {
        if (smallImage) {
            if (smallImageFile != null && smallImageBytes != null) {
                this.imageLocalService.updateImage(smallImageId, smallImageBytes);
            }
        } else {
            this.imageLocalService.deleteImage(smallImageId);
        }
    }

    protected void validate(long groupId, long classNameId, String templateKey, Map<Locale, String> nameMap, String script, boolean smallImage, String smallImageURL, File smallImageFile, byte[] smallImageBytes) throws PortalException {
        DDMTemplate template = this.ddmTemplatePersistence.fetchByG_C_T(groupId, classNameId, templateKey = StringUtil.toUpperCase((String)StringUtil.trim((String)templateKey)));
        if (template != null) {
            throw new TemplateDuplicateTemplateKeyException("Template already exists with template key " + templateKey);
        }
        this.validate(groupId, nameMap, script, smallImage, smallImageURL, smallImageFile, smallImageBytes);
    }

    protected void validate(long groupId, Map<Locale, String> nameMap, String script) throws PortalException {
        this.validateName(groupId, nameMap);
        if (Validator.isNull((String)script)) {
            throw new TemplateScriptException("Script is null");
        }
    }

    protected void validate(long groupId, Map<Locale, String> nameMap, String script, boolean smallImage, String smallImageURL, File smallImageFile, byte[] smallImageBytes) throws PortalException {
        this.validate(groupId, nameMap, script);
        if (!smallImage || Validator.isNotNull((String)smallImageURL) || smallImageFile == null || smallImageBytes == null) {
            return;
        }
        String smallImageName = smallImageFile.getName();
        boolean validSmallImageExtension = false;
        DDMGroupServiceConfiguration ddmGroupServiceConfiguration = this.getDDMGroupServiceConfiguration(groupId);
        for (String smallImageExtension : ddmGroupServiceConfiguration.smallImageExtensions()) {
            if (!"*".equals(smallImageExtension) && !StringUtil.endsWith((String)smallImageName, (String)smallImageExtension)) continue;
            validSmallImageExtension = true;
            break;
        }
        if (!validSmallImageExtension) {
            throw new TemplateSmallImageNameException(smallImageName);
        }
        long smallImageMaxSize = ddmGroupServiceConfiguration.smallImageMaxSize();
        if (smallImageMaxSize > 0L && (long)smallImageBytes.length > smallImageMaxSize) {
            throw new TemplateSmallImageSizeException(StringBundler.concat((String[])new String[]{"Image ", smallImageName, " has ", String.valueOf(smallImageBytes.length), " bytes and exceeds the maximum size of ", String.valueOf(smallImageMaxSize)}));
        }
    }

    protected void validateName(long groupId, Map<Locale, String> nameMap) throws PortalException {
        String name = nameMap.get(PortalUtil.getSiteDefaultLocale((long)groupId));
        if (Validator.isNull((String)name)) {
            name = nameMap.get(LocaleUtil.getSiteDefault());
        }
        if (Validator.isNull((String)name)) {
            throw new TemplateNameException("Name is null");
        }
    }
}

