/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.dynamic.data.mapping.model.DDMContent;
import com.liferay.dynamic.data.mapping.service.DDMContentLocalService;
import com.liferay.dynamic.data.mapping.service.DDMContentLocalServiceUtil;
import com.liferay.dynamic.data.mapping.service.persistence.DDMContentPersistence;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.ParamSetter;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalServiceRegistry;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.UserPersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.util.List;
import javax.sql.DataSource;

public abstract class DDMContentLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements DDMContentLocalService,
IdentifiableOSGiService {
    @BeanReference(type=DDMContentLocalService.class)
    protected DDMContentLocalService ddmContentLocalService;
    @BeanReference(type=DDMContentPersistence.class)
    protected DDMContentPersistence ddmContentPersistence;
    @ServiceReference(type=CounterLocalService.class)
    protected CounterLocalService counterLocalService;
    @ServiceReference(type=UserLocalService.class)
    protected UserLocalService userLocalService;
    @ServiceReference(type=UserPersistence.class)
    protected UserPersistence userPersistence;
    private static final Log _log = LogFactoryUtil.getLog(DDMContentLocalServiceBaseImpl.class);
    @ServiceReference(type=PersistedModelLocalServiceRegistry.class)
    protected PersistedModelLocalServiceRegistry persistedModelLocalServiceRegistry;

    @Indexable(type=IndexableType.REINDEX)
    public DDMContent addDDMContent(DDMContent ddmContent) {
        ddmContent.setNew(true);
        return (DDMContent)this.ddmContentPersistence.update((BaseModel)ddmContent);
    }

    @Transactional(enabled=false)
    public DDMContent createDDMContent(long contentId) {
        return this.ddmContentPersistence.create(contentId);
    }

    @Indexable(type=IndexableType.DELETE)
    public DDMContent deleteDDMContent(long contentId) throws PortalException {
        return this.ddmContentPersistence.remove(contentId);
    }

    @Indexable(type=IndexableType.DELETE)
    public DDMContent deleteDDMContent(DDMContent ddmContent) {
        return (DDMContent)this.ddmContentPersistence.remove((BaseModel)ddmContent);
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(DDMContent.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.ddmContentPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.ddmContentPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.ddmContentPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.ddmContentPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.ddmContentPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public DDMContent fetchDDMContent(long contentId) {
        return this.ddmContentPersistence.fetchByPrimaryKey(contentId);
    }

    public DDMContent fetchDDMContentByUuidAndGroupId(String uuid, long groupId) {
        return this.ddmContentPersistence.fetchByUUID_G(uuid, groupId);
    }

    public DDMContent getDDMContent(long contentId) throws PortalException {
        return this.ddmContentPersistence.findByPrimaryKey(contentId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.ddmContentLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(DDMContent.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("contentId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.ddmContentLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(DDMContent.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("contentId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.ddmContentLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(DDMContent.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("contentId");
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount((PortletDataContext)portletDataContext, (StagedModelType)stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }
        };
        this.initActionableDynamicQuery((ActionableDynamicQuery)exportActionableDynamicQuery);
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                portletDataContext.addDateRangeCriteria(dynamicQuery, "modifiedDate");
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<DDMContent>(){

            public void performAction(DDMContent ddmContent) throws PortalException {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)ddmContent);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(PortalUtil.getClassNameId((String)DDMContent.class.getName())));
        return exportActionableDynamicQuery;
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        return this.ddmContentLocalService.deleteDDMContent((DDMContent)persistedModel);
    }

    public BasePersistence<DDMContent> getBasePersistence() {
        return this.ddmContentPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.ddmContentPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public List<DDMContent> getDDMContentsByUuidAndCompanyId(String uuid, long companyId) {
        return this.ddmContentPersistence.findByUuid_C(uuid, companyId);
    }

    public List<DDMContent> getDDMContentsByUuidAndCompanyId(String uuid, long companyId, int start, int end, OrderByComparator<DDMContent> orderByComparator) {
        return this.ddmContentPersistence.findByUuid_C(uuid, companyId, start, end, orderByComparator);
    }

    public DDMContent getDDMContentByUuidAndGroupId(String uuid, long groupId) throws PortalException {
        return this.ddmContentPersistence.findByUUID_G(uuid, groupId);
    }

    public List<DDMContent> getDDMContents(int start, int end) {
        return this.ddmContentPersistence.findAll(start, end);
    }

    public int getDDMContentsCount() {
        return this.ddmContentPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public DDMContent updateDDMContent(DDMContent ddmContent) {
        return (DDMContent)this.ddmContentPersistence.update((BaseModel)ddmContent);
    }

    public DDMContentLocalService getDDMContentLocalService() {
        return this.ddmContentLocalService;
    }

    public void setDDMContentLocalService(DDMContentLocalService ddmContentLocalService) {
        this.ddmContentLocalService = ddmContentLocalService;
    }

    public DDMContentPersistence getDDMContentPersistence() {
        return this.ddmContentPersistence;
    }

    public void setDDMContentPersistence(DDMContentPersistence ddmContentPersistence) {
        this.ddmContentPersistence = ddmContentPersistence;
    }

    public CounterLocalService getCounterLocalService() {
        return this.counterLocalService;
    }

    public void setCounterLocalService(CounterLocalService counterLocalService) {
        this.counterLocalService = counterLocalService;
    }

    public UserLocalService getUserLocalService() {
        return this.userLocalService;
    }

    public void setUserLocalService(UserLocalService userLocalService) {
        this.userLocalService = userLocalService;
    }

    public UserPersistence getUserPersistence() {
        return this.userPersistence;
    }

    public void setUserPersistence(UserPersistence userPersistence) {
        this.userPersistence = userPersistence;
    }

    public void afterPropertiesSet() {
        this.persistedModelLocalServiceRegistry.register("com.liferay.dynamic.data.mapping.model.DDMContent", (PersistedModelLocalService)this.ddmContentLocalService);
        DDMContentLocalServiceUtil.setService((DDMContentLocalService)this.ddmContentLocalService);
    }

    public void destroy() {
        this.persistedModelLocalServiceRegistry.unregister("com.liferay.dynamic.data.mapping.model.DDMContent");
        DDMContentLocalServiceUtil.setService(null);
    }

    public String getOSGiServiceIdentifier() {
        return DDMContentLocalService.class.getName();
    }

    protected Class<?> getModelClass() {
        return DDMContent.class;
    }

    protected String getModelClassName() {
        return DDMContent.class.getName();
    }

    protected void runSQL(String sql) {
        try {
            DataSource dataSource = this.ddmContentPersistence.getDataSource();
            DB db = DBManagerUtil.getDB();
            sql = db.buildSQL(sql);
            sql = PortalUtil.transformSQL((String)sql);
            SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate((DataSource)dataSource, (String)sql, (ParamSetter[])new ParamSetter[0]);
            sqlUpdate.update(new Object[0]);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

