/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.impl;

import com.liferay.dynamic.data.mapping.exception.NoSuchStructureLinkException;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureLink;
import com.liferay.dynamic.data.mapping.service.base.DDMStructureLinkLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.util.StringBundler;
import java.util.ArrayList;
import java.util.List;

public class DDMStructureLinkLocalServiceImpl
extends DDMStructureLinkLocalServiceBaseImpl {
    public DDMStructureLink addStructureLink(long classNameId, long classPK, long structureId) {
        long structureLinkId = this.counterLocalService.increment();
        DDMStructureLink structureLink = this.ddmStructureLinkPersistence.create(structureLinkId);
        structureLink.setClassNameId(classNameId);
        structureLink.setClassPK(classPK);
        structureLink.setStructureId(structureId);
        return (DDMStructureLink)this.ddmStructureLinkPersistence.update((BaseModel)structureLink);
    }

    public void deleteStructureLink(DDMStructureLink structureLink) {
        this.ddmStructureLinkPersistence.remove((BaseModel)structureLink);
    }

    public void deleteStructureLink(long structureLinkId) throws PortalException {
        DDMStructureLink structureLink = this.ddmStructureLinkPersistence.findByPrimaryKey(structureLinkId);
        this.deleteStructureLink(structureLink);
    }

    public void deleteStructureLink(long classNameId, long classPK, long structureId) throws PortalException {
        DDMStructureLink structureLink = this.ddmStructureLinkPersistence.findByC_C_S(classNameId, classPK, structureId);
        this.deleteDDMStructureLink(structureLink);
    }

    public void deleteStructureLinks(long classNameId, long classPK) {
        List structureLinks = this.ddmStructureLinkPersistence.findByC_C(classNameId, classPK);
        for (DDMStructureLink ddmStructureLink : structureLinks) {
            this.deleteStructureLink(ddmStructureLink);
        }
    }

    public void deleteStructureStructureLinks(long structureId) {
        List structureLinks = this.ddmStructureLinkPersistence.findByStructureId(structureId);
        for (DDMStructureLink structureLink : structureLinks) {
            this.deleteStructureLink(structureLink);
        }
    }

    public List<DDMStructureLink> getClassNameStructureLinks(long classNameId) {
        return this.ddmStructureLinkPersistence.findByClassNameId(classNameId);
    }

    public DDMStructureLink getStructureLink(long structureLinkId) throws PortalException {
        return this.ddmStructureLinkPersistence.findByPrimaryKey(structureLinkId);
    }

    public List<DDMStructureLink> getStructureLinks(long structureId) {
        return this.ddmStructureLinkPersistence.findByStructureId(structureId);
    }

    public List<DDMStructureLink> getStructureLinks(long structureId, int start, int end) {
        return this.ddmStructureLinkPersistence.findByStructureId(structureId, start, end);
    }

    public List<DDMStructureLink> getStructureLinks(long classNameId, long classPK) {
        return this.ddmStructureLinkPersistence.findByC_C(classNameId, classPK);
    }

    public List<DDMStructure> getStructureLinkStructures(long classNameId, long classPK) throws PortalException {
        ArrayList<DDMStructure> structures = new ArrayList<DDMStructure>();
        List<DDMStructureLink> structureLinks = this.getStructureLinks(classNameId, classPK);
        for (DDMStructureLink structureLink : structureLinks) {
            structures.add(structureLink.getStructure());
        }
        return structures;
    }

    public DDMStructureLink getUniqueStructureLink(long classNameId, long classPK) throws PortalException {
        List structureLinks = this.ddmStructureLinkPersistence.findByC_C(classNameId, classPK);
        if (structureLinks.isEmpty()) {
            StringBundler sb = new StringBundler(5);
            sb.append("No DDMStructureLink found for {classNameId=");
            sb.append(classNameId);
            sb.append(", classPK=");
            sb.append(classPK);
            sb.append("}");
            throw new NoSuchStructureLinkException(sb.toString());
        }
        return (DDMStructureLink)structureLinks.get(0);
    }

    public DDMStructureLink updateStructureLink(long structureLinkId, long classNameId, long classPK, long structureId) throws PortalException {
        DDMStructureLink structureLink = this.ddmStructureLinkPersistence.findByPrimaryKey(structureLinkId);
        structureLink.setClassNameId(classNameId);
        structureLink.setClassPK(classPK);
        structureLink.setStructureId(structureId);
        return (DDMStructureLink)this.ddmStructureLinkPersistence.update((BaseModel)structureLink);
    }
}

