/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.impl;

import com.liferay.dynamic.data.mapping.model.DDMStorageLink;
import com.liferay.dynamic.data.mapping.service.base.DDMStorageLinkLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.service.ServiceContext;
import java.util.List;

public class DDMStorageLinkLocalServiceImpl
extends DDMStorageLinkLocalServiceBaseImpl {
    public DDMStorageLink addStorageLink(long classNameId, long classPK, long structureId, ServiceContext serviceContext) {
        long storageLinkId = this.counterLocalService.increment();
        DDMStorageLink storageLink = this.ddmStorageLinkPersistence.create(storageLinkId);
        storageLink.setClassNameId(classNameId);
        storageLink.setClassPK(classPK);
        storageLink.setStructureId(structureId);
        return (DDMStorageLink)this.ddmStorageLinkPersistence.update((BaseModel)storageLink);
    }

    public void deleteClassStorageLink(long classPK) {
        DDMStorageLink storageLink = this.ddmStorageLinkPersistence.fetchByClassPK(classPK);
        if (storageLink != null) {
            this.deleteStorageLink(storageLink);
        }
    }

    public void deleteStorageLink(DDMStorageLink storageLink) {
        this.ddmStorageLinkPersistence.remove((BaseModel)storageLink);
    }

    public void deleteStorageLink(long storageLinkId) {
        DDMStorageLink storageLink = this.ddmStorageLinkPersistence.fetchByPrimaryKey(storageLinkId);
        if (storageLink != null) {
            this.deleteStorageLink(storageLink);
        }
    }

    public void deleteStructureStorageLinks(long structureId) {
        List storageLinks = this.ddmStorageLinkPersistence.findByStructureId(structureId);
        for (DDMStorageLink storageLink : storageLinks) {
            this.deleteStorageLink(storageLink);
        }
    }

    public DDMStorageLink getClassStorageLink(long classPK) throws PortalException {
        return this.ddmStorageLinkPersistence.findByClassPK(classPK);
    }

    public DDMStorageLink getStorageLink(long storageLinkId) throws PortalException {
        return this.ddmStorageLinkPersistence.findByPrimaryKey(storageLinkId);
    }

    public List<DDMStorageLink> getStructureStorageLinks(long structureId) {
        return this.ddmStorageLinkPersistence.findByStructureId(structureId);
    }

    public int getStructureStorageLinksCount(long structureId) {
        return this.ddmStorageLinkPersistence.countByStructureId(structureId);
    }

    public DDMStorageLink updateStorageLink(long storageLinkId, long classNameId, long classPK) throws PortalException {
        DDMStorageLink storageLink = this.ddmStorageLinkPersistence.findByPrimaryKey(storageLinkId);
        storageLink.setClassNameId(classNameId);
        storageLink.setClassPK(classPK);
        return (DDMStorageLink)this.ddmStorageLinkPersistence.update((BaseModel)storageLink);
    }
}

