/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.template;

import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.mobile.device.Device;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.template.BaseTemplateHandler;
import com.liferay.portal.kernel.template.TemplateVariableCodeHandler;
import com.liferay.portal.kernel.template.TemplateVariableGroup;
import com.liferay.portal.kernel.templateparser.TemplateNode;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class BaseDDMTemplateHandler
extends BaseTemplateHandler {
    public Map<String, TemplateVariableGroup> getTemplateVariableGroups(long classPK, String language, Locale locale) throws Exception {
        LinkedHashMap<String, TemplateVariableGroup> templateVariableGroups = new LinkedHashMap<String, TemplateVariableGroup>();
        this.addTemplateVariableGroup(templateVariableGroups, this.getGeneralVariablesTemplateVariableGroup());
        this.addTemplateVariableGroup(templateVariableGroups, this.getStructureFieldsTemplateVariableGroup(classPK, locale));
        this.addTemplateVariableGroup(templateVariableGroups, this.getUtilTemplateVariableGroup());
        return templateVariableGroups;
    }

    public boolean isDisplayTemplateHandler() {
        return false;
    }

    protected void addTemplateVariableGroup(Map<String, TemplateVariableGroup> templateVariableGroups, TemplateVariableGroup templateVariableGroup) {
        if (templateVariableGroup == null) {
            return;
        }
        templateVariableGroups.put(templateVariableGroup.getLabel(), templateVariableGroup);
    }

    protected void collectNestedFieldNameVariableName(DDMFormField parentDDMFormField, Map<String, String> fieldNameVariableNameMap) throws PortalException {
        List childrenDDMFormFields = parentDDMFormField.getNestedDDMFormFields();
        if (ListUtil.isEmpty((List)childrenDDMFormFields)) {
            return;
        }
        String parentVariableName = fieldNameVariableNameMap.get(parentDDMFormField.getName());
        for (DDMFormField childDDMFormField : childrenDDMFormFields) {
            fieldNameVariableNameMap.put(childDDMFormField.getName(), parentVariableName + "." + childDDMFormField.getName());
            this.collectNestedFieldNameVariableName(childDDMFormField, fieldNameVariableNameMap);
        }
    }

    protected Class<?> getFieldVariableClass() {
        return TemplateNode.class;
    }

    protected TemplateVariableGroup getGeneralVariablesTemplateVariableGroup() {
        TemplateVariableGroup templateVariableGroup = new TemplateVariableGroup("general-variables");
        templateVariableGroup.addVariable("device", Device.class, "device");
        templateVariableGroup.addVariable("portal-instance", Company.class, "company");
        templateVariableGroup.addVariable("portal-instance-id", null, "companyId");
        templateVariableGroup.addVariable("site-id", null, "groupId");
        templateVariableGroup.addVariable("view-mode", String.class, "viewMode");
        return templateVariableGroup;
    }

    protected TemplateVariableGroup getStructureFieldsTemplateVariableGroup(long ddmStructureId, Locale locale) throws PortalException {
        if (ddmStructureId <= 0L) {
            return null;
        }
        TemplateVariableGroup templateVariableGroup = new TemplateVariableGroup("fields");
        DDMStructure ddmStructure = DDMStructureLocalServiceUtil.getStructure((long)ddmStructureId);
        DDMForm fullHierarchyDDMForm = ddmStructure.getFullHierarchyDDMForm();
        LinkedHashMap<String, String> fieldNameVariableNameMap = new LinkedHashMap<String, String>();
        for (DDMFormField dDMFormField : fullHierarchyDDMForm.getDDMFormFields()) {
            fieldNameVariableNameMap.put(dDMFormField.getName(), dDMFormField.getName());
            this.collectNestedFieldNameVariableName(dDMFormField, fieldNameVariableNameMap);
        }
        for (Map.Entry entry : fieldNameVariableNameMap.entrySet()) {
            String fieldName = (String)entry.getKey();
            String label = ddmStructure.getFieldLabel(fieldName, locale);
            String tip = ddmStructure.getFieldTip(fieldName, locale);
            String dataType = ddmStructure.getFieldDataType(fieldName);
            boolean repeatable = ddmStructure.getFieldRepeatable(fieldName);
            if (Validator.isNull((String)dataType)) continue;
            templateVariableGroup.addFieldVariable(label, this.getFieldVariableClass(), (String)entry.getValue(), tip, dataType, repeatable, this.getTemplateVariableCodeHandler());
        }
        return templateVariableGroup;
    }

    protected abstract TemplateVariableCodeHandler getTemplateVariableCodeHandler();

    protected TemplateVariableGroup getUtilTemplateVariableGroup() {
        TemplateVariableGroup templateVariableGroup = new TemplateVariableGroup("util");
        templateVariableGroup.addVariable("permission-checker", PermissionChecker.class, "permissionChecker");
        templateVariableGroup.addVariable("random-namespace", String.class, "randomNamespace");
        templateVariableGroup.addVariable("templates-path", String.class, "templatesPath");
        return templateVariableGroup;
    }
}

