/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.permission;

import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.dynamic.data.mapping.service.permission.DDMPermissionSupportTracker;
import com.liferay.dynamic.data.mapping.util.DDMTemplatePermissionSupport;
import com.liferay.exportimport.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerCustomizerFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.BaseResourcePermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DDMTemplatePermission.class})
public class DDMTemplatePermission
extends BaseResourcePermissionChecker {
    private static final Log _log = LogFactoryUtil.getLog(DDMTemplatePermission.class);
    private static DDMPermissionSupportTracker _ddmPermissionSupportTracker;
    private static DDMTemplateLocalService _ddmTemplateLocalService;

    public static void check(PermissionChecker permissionChecker, DDMTemplate template, String actionId) throws PortalException {
        if (!DDMTemplatePermission.contains(permissionChecker, template, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, DDMTemplatePermission.getTemplateModelResourceName(template.getResourceClassNameId()), template.getTemplateId(), new String[]{actionId});
        }
    }

    public static void check(PermissionChecker permissionChecker, long groupId, DDMTemplate template, String portletId, String actionId) throws PortalException {
        if (!DDMTemplatePermission.contains(permissionChecker, groupId, template, portletId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, DDMTemplatePermission.getTemplateModelResourceName(template.getResourceClassNameId()), template.getTemplateId(), new String[]{actionId});
        }
    }

    public static void check(PermissionChecker permissionChecker, long groupId, long templateId, String portletId, String actionId) throws PortalException {
        DDMTemplate template = _ddmTemplateLocalService.getTemplate(templateId);
        if (!DDMTemplatePermission.contains(permissionChecker, groupId, template, portletId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, DDMTemplatePermission.getTemplateModelResourceName(template.getResourceClassNameId()), templateId, new String[]{actionId});
        }
    }

    public static void check(PermissionChecker permissionChecker, long templateId, String actionId) throws PortalException {
        DDMTemplate template = _ddmTemplateLocalService.getTemplate(templateId);
        if (!DDMTemplatePermission.contains(permissionChecker, template, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, DDMTemplatePermission.getTemplateModelResourceName(template.getResourceClassNameId()), templateId, new String[]{actionId});
        }
    }

    public static void checkAddTemplatePermission(PermissionChecker permissionChecker, long groupId, long classNameId, long resourceClassNameId) throws PortalException {
        if (!DDMTemplatePermission.containsAddTemplatePermission(permissionChecker, groupId, classNameId, resourceClassNameId)) {
            ServiceTrackerCustomizerFactory.ServiceWrapper<DDMTemplatePermissionSupport> templatePermissionSupportServiceWrapper = _ddmPermissionSupportTracker.getDDMTemplatePermissionSupportServiceWrapper(resourceClassNameId);
            throw new PrincipalException.MustHavePermission(permissionChecker, DDMTemplatePermission.getResourceName(templatePermissionSupportServiceWrapper, classNameId), groupId, new String[]{DDMTemplatePermission.getAddTemplateActionId(templatePermissionSupportServiceWrapper)});
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, DDMTemplate template, String actionId) throws PortalException {
        String templateModelResourceName = DDMTemplatePermission.getTemplateModelResourceName(template.getResourceClassNameId());
        return DDMTemplatePermission._contains(permissionChecker, template, templateModelResourceName, actionId);
    }

    @Deprecated
    public static boolean contains(PermissionChecker permissionChecker, DDMTemplate template, String portletId, String actionId) throws PortalException {
        return DDMTemplatePermission.contains(permissionChecker, template, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, DDMTemplate template, String portletId, String actionId) throws PortalException {
        Boolean hasPermission;
        String templateModelResourceName = DDMTemplatePermission.getTemplateModelResourceName(template.getResourceClassNameId());
        if (Validator.isNotNull((String)portletId) && (hasPermission = StagingPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)groupId, (String)templateModelResourceName, (long)template.getTemplateId(), (String)portletId, (String)actionId)) != null) {
            return hasPermission;
        }
        return DDMTemplatePermission._contains(permissionChecker, template, templateModelResourceName, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, long templateId, String portletId, String actionId) throws PortalException {
        DDMTemplate template = _ddmTemplateLocalService.getTemplate(templateId);
        return DDMTemplatePermission.contains(permissionChecker, groupId, template, portletId, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long templateId, String actionId) throws PortalException {
        DDMTemplate template = _ddmTemplateLocalService.getTemplate(templateId);
        return DDMTemplatePermission.contains(permissionChecker, template, actionId);
    }

    @Deprecated
    public static boolean contains(PermissionChecker permissionChecker, long templateId, String portletId, String actionId) throws PortalException {
        return DDMTemplatePermission.contains(permissionChecker, templateId, actionId);
    }

    public static boolean containsAddTemplatePermission(PermissionChecker permissionChecker, long groupId, long classNameId, long resourceClassNameId) throws PortalException {
        ServiceTrackerCustomizerFactory.ServiceWrapper<DDMTemplatePermissionSupport> templatePermissionSupportServiceWrapper = _ddmPermissionSupportTracker.getDDMTemplatePermissionSupportServiceWrapper(resourceClassNameId);
        String resourceName = DDMTemplatePermission.getResourceName(templatePermissionSupportServiceWrapper, classNameId);
        List portletNames = ResourceActionsUtil.getPortletNames();
        if (portletNames.contains(resourceName)) {
            return PortletPermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, null, (String)resourceName, (String)DDMTemplatePermission.getAddTemplateActionId(templatePermissionSupportServiceWrapper));
        }
        return DDMTemplatePermission.contains((PermissionChecker)permissionChecker, (String)resourceName, (long)groupId, (String)DDMTemplatePermission.getAddTemplateActionId(templatePermissionSupportServiceWrapper));
    }

    public static String getTemplateModelResourceName(long resourceClassNameId) throws PortalException {
        String className = PortalUtil.getClassName((long)resourceClassNameId);
        ServiceTrackerCustomizerFactory.ServiceWrapper<DDMTemplatePermissionSupport> templatePermissionSupportServiceWrapper = _ddmPermissionSupportTracker.getDDMTemplatePermissionSupportServiceWrapper(className);
        Map properties = templatePermissionSupportServiceWrapper.getProperties();
        boolean defaultModelResourceName = MapUtil.getBoolean((Map)properties, (String)"default.model.resource.name");
        if (defaultModelResourceName) {
            return DDMTemplate.class.getName();
        }
        return ResourceActionsUtil.getCompositeModelName((String[])new String[]{className, DDMTemplate.class.getName()});
    }

    public Boolean checkResource(PermissionChecker permissionChecker, long classPK, String actionId) {
        try {
            return DDMTemplatePermission.contains(permissionChecker, classPK, actionId);
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return false;
        }
    }

    protected static String getAddTemplateActionId(ServiceTrackerCustomizerFactory.ServiceWrapper<DDMTemplatePermissionSupport> templatePermissionSupportServiceWrapper) {
        Map properties = templatePermissionSupportServiceWrapper.getProperties();
        return MapUtil.getString((Map)properties, (String)"add.template.action.id", (String)"ADD_TEMPLATE");
    }

    protected static String getResourceName(ServiceTrackerCustomizerFactory.ServiceWrapper<DDMTemplatePermissionSupport> templatePermissionSupportServiceWrapper, long classNameId) {
        DDMTemplatePermissionSupport templatePermissionSupport = (DDMTemplatePermissionSupport)templatePermissionSupportServiceWrapper.getService();
        return templatePermissionSupport.getResourceName(classNameId);
    }

    @Reference(unbind="-")
    protected void setDDMPermissionSupportTracker(DDMPermissionSupportTracker ddmPermissionSupportTracker) {
        _ddmPermissionSupportTracker = ddmPermissionSupportTracker;
    }

    @Reference(unbind="-")
    protected void setDDMTemplateLocalService(DDMTemplateLocalService ddmTemplateLocalService) {
        _ddmTemplateLocalService = ddmTemplateLocalService;
    }

    private static boolean _contains(PermissionChecker permissionChecker, DDMTemplate template, String templateModelResourceName, String actionId) throws PortalException {
        if (permissionChecker.hasOwnerPermission(template.getCompanyId(), templateModelResourceName, template.getTemplateId(), template.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(template.getGroupId(), templateModelResourceName, template.getTemplateId(), actionId);
    }
}

