/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.storage.impl;

import com.liferay.dynamic.data.mapping.io.DDMFormValuesJSONDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesJSONSerializer;
import com.liferay.dynamic.data.mapping.model.DDMContent;
import com.liferay.dynamic.data.mapping.model.DDMStorageLink;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMContentLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStorageLinkLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.storage.BaseStorageAdapter;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.StorageAdapter;
import com.liferay.dynamic.data.mapping.storage.StorageType;
import com.liferay.dynamic.data.mapping.validator.DDMFormValuesValidator;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={StorageAdapter.class})
public class JSONStorageAdapter
extends BaseStorageAdapter {
    private DDMContentLocalService _ddmContentLocalService;
    private DDMFormValuesJSONDeserializer _ddmFormValuesJSONDeserializer;
    private DDMFormValuesJSONSerializer _ddmFormValuesJSONSerializer;
    private DDMFormValuesValidator _ddmFormValuesValidator;
    private DDMStorageLinkLocalService _ddmStorageLinkLocalService;
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private Portal _portal;

    public long doCreate(long companyId, long ddmStructureId, DDMFormValues ddmFormValues, ServiceContext serviceContext) throws Exception {
        this.validate(ddmFormValues, serviceContext);
        long classNameId = this._portal.getClassNameId(DDMContent.class.getName());
        String serializedDDMFormValues = this._ddmFormValuesJSONSerializer.serialize(ddmFormValues);
        DDMContent ddmContent = this._ddmContentLocalService.addContent(serviceContext.getUserId(), serviceContext.getScopeGroupId(), DDMStorageLink.class.getName(), null, serializedDDMFormValues, serviceContext);
        this._ddmStorageLinkLocalService.addStorageLink(classNameId, ddmContent.getPrimaryKey(), ddmStructureId, serviceContext);
        return ddmContent.getPrimaryKey();
    }

    public void doUpdate(long classPK, DDMFormValues ddmFormValues, ServiceContext serviceContext) throws Exception {
        this.validate(ddmFormValues, serviceContext);
        DDMContent ddmContent = this._ddmContentLocalService.getContent(classPK);
        ddmContent.setModifiedDate(serviceContext.getModifiedDate(null));
        String serializedDDMFormValues = this._ddmFormValuesJSONSerializer.serialize(ddmFormValues);
        ddmContent.setData(serializedDDMFormValues);
        this._ddmContentLocalService.updateContent(ddmContent.getPrimaryKey(), ddmContent.getName(), ddmContent.getDescription(), ddmContent.getData(), serviceContext);
    }

    public String getStorageType() {
        return StorageType.JSON.toString();
    }

    protected void doDeleteByClass(long classPK) throws Exception {
        this._ddmContentLocalService.deleteDDMContent(classPK);
        this._ddmStorageLinkLocalService.deleteClassStorageLink(classPK);
    }

    protected void doDeleteByDDMStructure(long ddmStructureId) throws Exception {
        List ddmStorageLinks = this._ddmStorageLinkLocalService.getStructureStorageLinks(ddmStructureId);
        for (DDMStorageLink ddmStorageLink : ddmStorageLinks) {
            this.doDeleteByClass(ddmStorageLink.getClassPK());
        }
    }

    protected DDMFormValues doGetDDMFormValues(long classPK) throws Exception {
        DDMContent ddmContent = this._ddmContentLocalService.getContent(classPK);
        DDMStorageLink ddmStorageLink = this._ddmStorageLinkLocalService.getClassStorageLink(ddmContent.getPrimaryKey());
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(ddmStorageLink.getStructureId());
        return this._ddmFormValuesJSONDeserializer.deserialize(ddmStructure.getDDMForm(), ddmContent.getData());
    }

    @Reference(unbind="-")
    protected void setDDMContentLocalService(DDMContentLocalService ddmContentLocalService) {
        this._ddmContentLocalService = ddmContentLocalService;
    }

    @Reference(unbind="-")
    protected void setDDMFormValuesJSONDeserializer(DDMFormValuesJSONDeserializer ddmFormValuesJSONDeserializer) {
        this._ddmFormValuesJSONDeserializer = ddmFormValuesJSONDeserializer;
    }

    @Reference(unbind="-")
    protected void setDDMFormValuesJSONSerializer(DDMFormValuesJSONSerializer ddmFormValuesJSONSerializer) {
        this._ddmFormValuesJSONSerializer = ddmFormValuesJSONSerializer;
    }

    @Reference(unbind="-")
    protected void setDDMFormValuesValidator(DDMFormValuesValidator ddmFormValuesValidator) {
        this._ddmFormValuesValidator = ddmFormValuesValidator;
    }

    @Reference(unbind="-")
    protected void setDDMStorageLinkLocalService(DDMStorageLinkLocalService ddmStorageLinkLocalService) {
        this._ddmStorageLinkLocalService = ddmStorageLinkLocalService;
    }

    @Reference(unbind="-")
    protected void setDDMStructureLocalService(DDMStructureLocalService ddmStructureLocalService) {
        this._ddmStructureLocalService = ddmStructureLocalService;
    }

    protected void validate(DDMFormValues ddmFormValues, ServiceContext serviceContext) throws Exception {
        boolean validateDDMFormValues = GetterUtil.getBoolean((Object)serviceContext.getAttribute("validateDDMFormValues"), (boolean)true);
        if (!validateDDMFormValues) {
            return;
        }
        this._ddmFormValuesValidator.validate(ddmFormValues);
    }
}

