/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.impl;

import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.base.DDMTemplateServiceBaseImpl;
import com.liferay.dynamic.data.mapping.service.permission.DDMTemplatePermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DDMTemplateServiceImpl
extends DDMTemplateServiceBaseImpl {
    public DDMTemplate addTemplate(long groupId, long classNameId, long classPK, long resourceClassNameId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, String mode, String language, String script, ServiceContext serviceContext) throws PortalException {
        DDMTemplatePermission.checkAddTemplatePermission(this.getPermissionChecker(), groupId, classNameId, resourceClassNameId);
        return this.ddmTemplateLocalService.addTemplate(this.getUserId(), groupId, classNameId, classPK, resourceClassNameId, null, nameMap, descriptionMap, type, mode, language, script, false, false, null, null, serviceContext);
    }

    public DDMTemplate addTemplate(long groupId, long classNameId, long classPK, long resourceClassNameId, String templateKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, String mode, String language, String script, boolean cacheable, boolean smallImage, String smallImageURL, File smallImageFile, ServiceContext serviceContext) throws PortalException {
        DDMTemplatePermission.checkAddTemplatePermission(this.getPermissionChecker(), groupId, classNameId, resourceClassNameId);
        return this.ddmTemplateLocalService.addTemplate(this.getUserId(), groupId, classNameId, classPK, resourceClassNameId, templateKey, nameMap, descriptionMap, type, mode, language, script, cacheable, smallImage, smallImageURL, smallImageFile, serviceContext);
    }

    public DDMTemplate copyTemplate(long templateId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, ServiceContext serviceContext) throws PortalException {
        DDMTemplate template = this.ddmTemplatePersistence.findByPrimaryKey(templateId);
        DDMTemplatePermission.checkAddTemplatePermission(this.getPermissionChecker(), serviceContext.getScopeGroupId(), template.getClassNameId(), template.getResourceClassNameId());
        return this.ddmTemplateLocalService.copyTemplate(this.getUserId(), templateId, nameMap, descriptionMap, serviceContext);
    }

    public DDMTemplate copyTemplate(long templateId, ServiceContext serviceContext) throws PortalException {
        DDMTemplate template = this.ddmTemplatePersistence.findByPrimaryKey(templateId);
        DDMTemplatePermission.checkAddTemplatePermission(this.getPermissionChecker(), serviceContext.getScopeGroupId(), template.getClassNameId(), template.getResourceClassNameId());
        return this.ddmTemplateLocalService.copyTemplate(this.getUserId(), templateId, serviceContext);
    }

    public List<DDMTemplate> copyTemplates(long classNameId, long oldClassPK, long resourceClassNameId, long newClassPK, String type, ServiceContext serviceContext) throws PortalException {
        DDMTemplatePermission.checkAddTemplatePermission(this.getPermissionChecker(), serviceContext.getScopeGroupId(), classNameId, resourceClassNameId);
        return this.ddmTemplateLocalService.copyTemplates(this.getUserId(), classNameId, oldClassPK, newClassPK, type, serviceContext);
    }

    public void deleteTemplate(long templateId) throws PortalException {
        DDMTemplatePermission.check(this.getPermissionChecker(), templateId, "DELETE");
        this.ddmTemplateLocalService.deleteTemplate(templateId);
    }

    public DDMTemplate fetchTemplate(long groupId, long classNameId, String templateKey) throws PortalException {
        DDMTemplate ddmTemplate = this.ddmTemplateLocalService.fetchTemplate(groupId, classNameId, templateKey);
        if (ddmTemplate != null) {
            DDMTemplatePermission.check(this.getPermissionChecker(), ddmTemplate, "VIEW");
        }
        return ddmTemplate;
    }

    public DDMTemplate getTemplate(long templateId) throws PortalException {
        DDMTemplatePermission.check(this.getPermissionChecker(), templateId, "VIEW");
        return this.ddmTemplatePersistence.findByPrimaryKey(templateId);
    }

    public DDMTemplate getTemplate(long groupId, long classNameId, String templateKey) throws PortalException {
        DDMTemplate ddmTemplate = this.ddmTemplateLocalService.getTemplate(groupId, classNameId, templateKey);
        DDMTemplatePermission.check(this.getPermissionChecker(), ddmTemplate, "VIEW");
        return ddmTemplate;
    }

    public DDMTemplate getTemplate(long groupId, long classNameId, String templateKey, boolean includeAncestorTemplates) throws PortalException {
        DDMTemplate ddmTemplate = this.ddmTemplateLocalService.getTemplate(groupId, classNameId, templateKey, includeAncestorTemplates);
        DDMTemplatePermission.check(this.getPermissionChecker(), ddmTemplate, "VIEW");
        return ddmTemplate;
    }

    public List<DDMTemplate> getTemplates(long companyId, long groupId, long classNameId, long resourceClassNameId, int status) {
        return this.getTemplates(companyId, new long[]{groupId}, classNameId, 0L, resourceClassNameId, null, null, status);
    }

    public List<DDMTemplate> getTemplates(long companyId, long groupId, long classNameId, long classPK, long resourceClassNameId, boolean includeAncestorTemplates, int status) throws PortalException {
        ArrayList<DDMTemplate> ddmTemplates = new ArrayList<DDMTemplate>();
        ddmTemplates.addAll(this.getTemplates(companyId, new long[]{groupId}, classNameId, classPK, resourceClassNameId, null, null, status));
        if (!includeAncestorTemplates) {
            return ddmTemplates;
        }
        ddmTemplates.addAll(this.getTemplates(companyId, PortalUtil.getAncestorSiteGroupIds((long)groupId), classNameId, classPK, resourceClassNameId, null, null, status));
        return ddmTemplates;
    }

    public List<DDMTemplate> getTemplates(long companyId, long groupId, long classNameId, long classPK, long resourceClassNameId, int status) {
        return this.getTemplates(companyId, new long[]{groupId}, classNameId, classPK, resourceClassNameId, null, null, status);
    }

    public List<DDMTemplate> getTemplates(long companyId, long groupId, long classNameId, long classPK, long resourceClassNameId, String type, int status) {
        return this.getTemplates(companyId, new long[]{groupId}, classNameId, classPK, resourceClassNameId, type, null, status);
    }

    public List<DDMTemplate> getTemplates(long companyId, long groupId, long classNameId, long classPK, long resourceClassNameId, String type, String mode, int status) {
        return this.getTemplates(companyId, new long[]{groupId}, classNameId, classPK, resourceClassNameId, type, mode, status);
    }

    public List<DDMTemplate> getTemplatesByClassPK(long companyId, long groupId, long classPK, long resourceClassNameId, int status) {
        return this.getTemplates(companyId, new long[]{groupId}, 0L, classPK, resourceClassNameId, null, null, status);
    }

    public List<DDMTemplate> getTemplatesByStructureClassNameId(long groupId, long structureClassNameId, int status, int start, int end, OrderByComparator<DDMTemplate> orderByComparator) {
        return this.ddmTemplateFinder.filterFindByG_SC_S(groupId, structureClassNameId, status, start, end, orderByComparator);
    }

    public int getTemplatesByStructureClassNameIdCount(long groupId, long structureClassNameId, int status) {
        return this.ddmTemplateFinder.filterCountByG_SC_S(groupId, structureClassNameId, status);
    }

    public void revertTemplate(long templateId, String version, ServiceContext serviceContext) throws PortalException {
        DDMTemplatePermission.check(this.getPermissionChecker(), templateId, "UPDATE");
        this.ddmTemplateLocalService.revertTemplate(this.getUserId(), templateId, version, serviceContext);
    }

    public List<DDMTemplate> search(long companyId, long groupId, long classNameId, long classPK, long resourceClassNameId, String keywords, String type, String mode, int status, int start, int end, OrderByComparator<DDMTemplate> orderByComparator) {
        return this.ddmTemplateFinder.filterFindByKeywords(companyId, groupId, classNameId, classPK, resourceClassNameId, keywords, type, mode, status, start, end, orderByComparator);
    }

    public List<DDMTemplate> search(long companyId, long groupId, long classNameId, long classPK, long resourceClassNameId, String name, String description, String type, String mode, String language, int status, boolean andOperator, int start, int end, OrderByComparator<DDMTemplate> orderByComparator) {
        return this.ddmTemplateFinder.filterFindByC_G_C_C_R_N_D_T_M_L_S(companyId, groupId, classNameId, classPK, resourceClassNameId, name, description, type, mode, language, status, andOperator, start, end, orderByComparator);
    }

    public List<DDMTemplate> search(long companyId, long[] groupIds, long[] classNameIds, long[] classPKs, long resourceClassNameId, String keywords, String type, String mode, int status, int start, int end, OrderByComparator<DDMTemplate> orderByComparator) {
        return this.ddmTemplateFinder.filterFindByKeywords(companyId, groupIds, classNameIds, classPKs, resourceClassNameId, keywords, type, mode, status, start, end, orderByComparator);
    }

    public List<DDMTemplate> search(long companyId, long[] groupIds, long[] classNameIds, long[] classPKs, long resourceClassNameId, String name, String description, String type, String mode, String language, int status, boolean andOperator, int start, int end, OrderByComparator<DDMTemplate> orderByComparator) {
        return this.ddmTemplateFinder.filterFindByC_G_C_C_R_N_D_T_M_L_S(companyId, groupIds, classNameIds, classPKs, resourceClassNameId, name, description, type, mode, language, status, andOperator, start, end, orderByComparator);
    }

    public int searchCount(long companyId, long groupId, long classNameId, long classPK, long resourceClassNameId, String keywords, String type, String mode, int status) {
        return this.ddmTemplateFinder.filterCountByKeywords(companyId, groupId, classNameId, classPK, resourceClassNameId, keywords, type, mode, status);
    }

    public int searchCount(long companyId, long groupId, long classNameId, long classPK, long resourceClassNameId, String name, String description, String type, String mode, String language, int status, boolean andOperator) {
        return this.ddmTemplateFinder.filterCountByC_G_C_C_R_N_D_T_M_L_S(companyId, groupId, classNameId, classPK, resourceClassNameId, name, description, type, mode, language, status, andOperator);
    }

    public int searchCount(long companyId, long[] groupIds, long[] classNameIds, long[] classPKs, long resourceClassNameId, String keywords, String type, String mode, int status) {
        return this.ddmTemplateFinder.filterCountByKeywords(companyId, groupIds, classNameIds, classPKs, resourceClassNameId, keywords, type, mode, status);
    }

    public int searchCount(long companyId, long[] groupIds, long[] classNameIds, long[] classPKs, long resourceClassNameId, String name, String description, String type, String mode, String language, int status, boolean andOperator) {
        return this.ddmTemplateFinder.filterCountByC_G_C_C_R_N_D_T_M_L_S(companyId, groupIds, classNameIds, classPKs, resourceClassNameId, name, description, type, mode, language, status, andOperator);
    }

    public DDMTemplate updateTemplate(long templateId, long classPK, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, String mode, String language, String script, boolean cacheable, boolean smallImage, String smallImageURL, File smallImageFile, ServiceContext serviceContext) throws PortalException {
        DDMTemplatePermission.check(this.getPermissionChecker(), templateId, "UPDATE");
        return this.ddmTemplateLocalService.updateTemplate(this.getUserId(), templateId, classPK, nameMap, descriptionMap, type, mode, language, script, cacheable, smallImage, smallImageURL, smallImageFile, serviceContext);
    }

    public DDMTemplate updateTemplate(long templateId, long classPK, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, String mode, String language, String script, boolean cacheable, ServiceContext serviceContext) throws PortalException {
        DDMTemplatePermission.check(this.getPermissionChecker(), templateId, "UPDATE");
        return this.ddmTemplateLocalService.updateTemplate(this.getUserId(), templateId, classPK, nameMap, descriptionMap, type, mode, language, script, cacheable, serviceContext);
    }

    protected List<DDMTemplate> getTemplates(long companyId, long[] groupIds, long classNameId, long classPK, long resourceClassNameId, String type, String mode, int status) {
        return this.ddmTemplateFinder.filterFindByC_G_C_C_R_T_M_S(companyId, groupIds, classNameId, classPK, resourceClassNameId, type, mode, status, -1, -1, null);
    }
}

