/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.mapping.service.impl;

import com.liferay.dynamic.data.mapping.exception.NoSuchTemplateVersionException;
import com.liferay.dynamic.data.mapping.model.DDMTemplateVersion;
import com.liferay.dynamic.data.mapping.service.base.DDMTemplateVersionLocalServiceBaseImpl;
import com.liferay.dynamic.data.mapping.util.comparator.TemplateVersionVersionComparator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;

import java.util.Collections;
import java.util.List;

/**
 * @author Marcellus Tavares
 */
public class DDMTemplateVersionLocalServiceImpl
	extends DDMTemplateVersionLocalServiceBaseImpl {

	@Override
	public DDMTemplateVersion getLatestTemplateVersion(long templateId)
		throws PortalException {

		List<DDMTemplateVersion> templateVersions =
			ddmTemplateVersionPersistence.findByTemplateId(templateId);

		if (templateVersions.isEmpty()) {
			throw new NoSuchTemplateVersionException(
				"No template versions found for template ID " + templateId);
		}

		templateVersions = ListUtil.copy(templateVersions);

		Collections.sort(
			templateVersions, new TemplateVersionVersionComparator());

		return templateVersions.get(0);
	}

	@Override
	public DDMTemplateVersion getTemplateVersion(long templateVersionId)
		throws PortalException {

		return ddmTemplateVersionPersistence.findByPrimaryKey(
			templateVersionId);
	}

	@Override
	public DDMTemplateVersion getTemplateVersion(
			long templateId, String version)
		throws PortalException {

		return ddmTemplateVersionPersistence.findByT_V(templateId, version);
	}

	@Override
	public List<DDMTemplateVersion> getTemplateVersions(
		long templateId, int start, int end,
		OrderByComparator<DDMTemplateVersion> orderByComparator) {

		return ddmTemplateVersionPersistence.findByTemplateId(
			templateId, start, end, orderByComparator);
	}

	@Override
	public int getTemplateVersionsCount(long templateId) {
		return ddmTemplateVersionPersistence.countByTemplateId(templateId);
	}

}