/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.mapping.internal.render;

import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.render.DDMFormFieldRenderer;
import com.liferay.dynamic.data.mapping.render.DDMFormFieldRendererRegistryUtil;
import com.liferay.dynamic.data.mapping.render.DDMFormFieldRenderingContext;
import com.liferay.dynamic.data.mapping.render.DDMFormRenderer;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.util.impl.DDMFieldsCounter;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.StringBundler;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

/**
 * @author Marcellus Tavares
 */
public class DDMFormRendererImpl implements DDMFormRenderer {

	@Override
	public String render(
			DDMForm ddmForm,
			DDMFormFieldRenderingContext ddmFormFieldRenderingContext)
		throws PortalException {

		List<DDMFormField> ddmFormFields = ddmForm.getDDMFormFields();

		StringBundler sb = new StringBundler(ddmFormFields.size());

		for (DDMFormField ddmFormField : ddmFormFields) {
			if (isDDMFormFieldSkippable(
					ddmFormField, ddmFormFieldRenderingContext)) {

				continue;
			}

			DDMFormFieldRenderer ddmFormFieldRenderer =
				DDMFormFieldRendererRegistryUtil.getDDMFormFieldRenderer(
					ddmFormField.getType());

			sb.append(
				ddmFormFieldRenderer.render(
					ddmFormField, ddmFormFieldRenderingContext));
		}

		clearDDMFieldsCounter(ddmFormFieldRenderingContext);

		return sb.toString();
	}

	protected void clearDDMFieldsCounter(
		DDMFormFieldRenderingContext ddmFormFieldRenderingContext) {

		HttpServletRequest request =
			ddmFormFieldRenderingContext.getHttpServletRequest();

		String fieldsCounterKey =
			ddmFormFieldRenderingContext.getPortletNamespace() +
				ddmFormFieldRenderingContext.getNamespace() + "fieldsCount";

		DDMFieldsCounter ddmFieldsCounter =
			(DDMFieldsCounter)request.getAttribute(fieldsCounterKey);

		if (ddmFieldsCounter != null) {
			ddmFieldsCounter.clear();
		}
	}

	protected boolean isDDMFormFieldSkippable(
		DDMFormField ddmFormField,
		DDMFormFieldRenderingContext ddmFormFieldRenderingContext) {

		if (!ddmFormFieldRenderingContext.isReadOnly() ||
			ddmFormFieldRenderingContext.isShowEmptyFieldLabel()) {

			return false;
		}

		Fields fields = ddmFormFieldRenderingContext.getFields();

		if (fields.contains(ddmFormField.getName())) {
			return false;
		}

		for (DDMFormField nestedDDMFormField :
				ddmFormField.getNestedDDMFormFields()) {

			if (!isDDMFormFieldSkippable(
					nestedDDMFormField, ddmFormFieldRenderingContext)) {

				return false;
			}
		}

		return true;
	}

}