/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.verify;

import com.liferay.dynamic.data.mapping.io.DDMFormValuesJSONDeserializer;
import com.liferay.dynamic.data.mapping.model.DDMContent;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMStorageLink;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureLink;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.model.DDMTemplateLink;
import com.liferay.dynamic.data.mapping.service.DDMContentLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStorageLinkLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLinkLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureVersionLocalService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLinkLocalService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.validator.DDMFormLayoutValidator;
import com.liferay.dynamic.data.mapping.validator.DDMFormValidator;
import com.liferay.dynamic.data.mapping.validator.DDMFormValuesValidator;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.verify.VerifyProcess;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"verify.process.name=com.liferay.dynamic.data.mapping.service"}, service={VerifyProcess.class})
public class DDMServiceVerifyProcess
extends VerifyProcess {
    private static final Log _log = LogFactoryUtil.getLog(DDMServiceVerifyProcess.class);
    private DDMContentLocalService _ddmContentLocalService;
    private DDMFormLayoutValidator _ddmFormLayoutValidator;
    private DDMFormValidator _ddmFormValidator;
    private DDMFormValuesJSONDeserializer _ddmFormValuesJSONDeserializer;
    private DDMFormValuesValidator _ddmFormValuesValidator;
    private DDMStorageLinkLocalService _ddmStorageLinkLocalService;
    private DDMStructureLinkLocalService _ddmStructureLinkLocalService;
    private DDMStructureLocalService _ddmStructureLocalService;
    private DDMTemplateLinkLocalService _ddmTemplateLinkLocalService;
    private DDMTemplateLocalService _ddmTemplateLocalService;

    protected void doVerify() throws Exception {
        this.verifyStructures();
        this.verifyStructureLinks();
        this.verifyTemplateLinks();
        this.verifyContents();
    }

    protected DDMFormValues getDDMFormValues(DDMStructure structure, DDMContent content) throws PortalException {
        return this._ddmFormValuesJSONDeserializer.deserialize(structure.getDDMForm(), content.getData());
    }

    @Reference(unbind="-")
    protected void setDDMContentLocalService(DDMContentLocalService ddmContentLocalService) {
        this._ddmContentLocalService = ddmContentLocalService;
    }

    @Reference(unbind="-")
    protected void setDDMFormLayoutValidator(DDMFormLayoutValidator ddmFormLayoutValidator) {
        this._ddmFormLayoutValidator = ddmFormLayoutValidator;
    }

    @Reference(unbind="-")
    protected void setDDMFormValidator(DDMFormValidator ddmFormValidator) {
        this._ddmFormValidator = ddmFormValidator;
    }

    @Reference(unbind="-")
    protected void setDDMFormValuesJSONDeserializer(DDMFormValuesJSONDeserializer ddmFormValuesJSONDeserializer) {
        this._ddmFormValuesJSONDeserializer = ddmFormValuesJSONDeserializer;
    }

    @Reference(unbind="-")
    protected void setDDMFormValuesValidator(DDMFormValuesValidator ddmFormValuesValidator) {
        this._ddmFormValuesValidator = ddmFormValuesValidator;
    }

    @Reference(unbind="-")
    protected void setDDMStorageLinkLocalService(DDMStorageLinkLocalService ddmStorageLinkLocalService) {
        this._ddmStorageLinkLocalService = ddmStorageLinkLocalService;
    }

    @Reference(unbind="-")
    protected void setDDMStructureLinkLocalService(DDMStructureLinkLocalService ddmStructureLinkLocalService) {
        this._ddmStructureLinkLocalService = ddmStructureLinkLocalService;
    }

    @Reference(unbind="-")
    protected void setDDMStructureLocalService(DDMStructureLocalService ddmStructureLocalService) {
        this._ddmStructureLocalService = ddmStructureLocalService;
    }

    @Reference(unbind="-")
    protected void setDDMStructureVersionLocalService(DDMStructureVersionLocalService ddmStructureVersionLocalService) {
    }

    @Reference(unbind="-")
    protected void setDDMTemplateLinkLocalService(DDMTemplateLinkLocalService ddmTemplateLinkLocalService) {
        this._ddmTemplateLinkLocalService = ddmTemplateLinkLocalService;
    }

    @Reference(unbind="-")
    protected void setDDMTemplateLocalService(DDMTemplateLocalService ddmTemplateLocalService) {
        this._ddmTemplateLocalService = ddmTemplateLocalService;
    }

    protected void verifyContent(DDMContent content) throws PortalException {
        block2: {
            DDMStorageLink ddmStorageLink = this._ddmStorageLinkLocalService.getClassStorageLink(content.getContentId());
            DDMStructure structure = this._ddmStructureLocalService.getStructure(ddmStorageLink.getStructureId());
            try {
                DDMFormValues ddmFormValues = this.getDDMFormValues(structure, content);
                this._ddmFormValuesValidator.validate(ddmFormValues);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)String.format("Stale or invalid data for DDM content %d  and structure %d causes: {%s}", content.getContentId(), structure.getStructureId(), e.getMessage()), (Throwable)e);
            }
        }
    }

    protected void verifyContents() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            ActionableDynamicQuery actionableDynamicQuery = this._ddmContentLocalService.getActionableDynamicQuery();
            actionableDynamicQuery.setPerformActionMethod(new ActionableDynamicQuery.PerformActionMethod(){

                public void performAction(Object object) throws PortalException {
                    DDMContent content = (DDMContent)object;
                    DDMServiceVerifyProcess.this.verifyContent(content);
                }
            });
            actionableDynamicQuery.performActions();
        }
    }

    protected void verifyDDMForm(DDMForm ddmForm) throws PortalException {
        this._ddmFormValidator.validate(ddmForm);
    }

    protected void verifyDDMFormLayout(DDMFormLayout ddmFormLayout) throws PortalException {
        this._ddmFormLayoutValidator.validate(ddmFormLayout);
    }

    protected void verifyStructure(DDMStructure structure) throws PortalException {
        this.verifyDDMForm(structure.getDDMForm());
        this.verifyDDMFormLayout(structure.getDDMFormLayout());
    }

    protected void verifyStructureLink(DDMStructureLink structureLink) throws PortalException {
        DDMStructure structure = this._ddmStructureLocalService.fetchStructure(structureLink.getStructureId());
        if (structure == null) {
            this._ddmStructureLinkLocalService.deleteStructureLink(structureLink.getStructureLinkId());
        }
    }

    protected void verifyStructureLinks() throws PortalException {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            ActionableDynamicQuery actionableDynamicQuery = this._ddmStructureLinkLocalService.getActionableDynamicQuery();
            actionableDynamicQuery.setPerformActionMethod(new ActionableDynamicQuery.PerformActionMethod(){

                public void performAction(Object object) throws PortalException {
                    DDMStructureLink structureLink = (DDMStructureLink)object;
                    DDMServiceVerifyProcess.this.verifyStructureLink(structureLink);
                }
            });
        }
    }

    protected void verifyStructures() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            ActionableDynamicQuery actionableDynamicQuery = this._ddmStructureLocalService.getActionableDynamicQuery();
            actionableDynamicQuery.setPerformActionMethod(new ActionableDynamicQuery.PerformActionMethod(){

                public void performAction(Object object) throws PortalException {
                    DDMStructure structure = (DDMStructure)object;
                    try {
                        DDMServiceVerifyProcess.this.verifyStructure(structure);
                    }
                    catch (PortalException pe) {
                        _log.error((Object)String.format("Invalid data for DDM structure %d causes: {%s}", structure.getStructureId(), pe.getMessage()), (Throwable)pe);
                    }
                }
            });
            actionableDynamicQuery.performActions();
        }
    }

    protected void verifyTemplateLink(DDMTemplateLink templateLink) throws PortalException {
        DDMTemplate template = this._ddmTemplateLocalService.fetchTemplate(templateLink.getTemplateId());
        if (template == null) {
            this._ddmTemplateLinkLocalService.deleteTemplateLink(templateLink.getTemplateId());
        }
    }

    protected void verifyTemplateLinks() throws PortalException {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            ActionableDynamicQuery actionableDynamicQuery = this._ddmTemplateLinkLocalService.getActionableDynamicQuery();
            actionableDynamicQuery.setPerformActionMethod(new ActionableDynamicQuery.PerformActionMethod(){

                public void performAction(Object object) throws PortalException {
                    DDMTemplateLink templateLink = (DDMTemplateLink)object;
                    DDMServiceVerifyProcess.this.verifyTemplateLink(templateLink);
                }
            });
        }
    }
}

