/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.mapping.service.impl;

import com.liferay.dynamic.data.mapping.model.DDMDataProviderInstanceLink;
import com.liferay.dynamic.data.mapping.service.base.DDMDataProviderInstanceLinkLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;

import java.util.List;

/**
 * @author Marcellus Tavares
 */
public class DDMDataProviderInstanceLinkLocalServiceImpl
	extends DDMDataProviderInstanceLinkLocalServiceBaseImpl {

	@Override
	public DDMDataProviderInstanceLink addDataProviderInstanceLink(
		long dataProviderInstanceId, long structureId) {

		long dataProviderInstanceLinkId = counterLocalService.increment();

		DDMDataProviderInstanceLink dataProviderInstanceLink =
			ddmDataProviderInstanceLinkPersistence.create(
				dataProviderInstanceLinkId);

		dataProviderInstanceLink.setDataProviderInstanceId(
			dataProviderInstanceId);
		dataProviderInstanceLink.setStructureId(structureId);

		ddmDataProviderInstanceLinkPersistence.update(dataProviderInstanceLink);

		return dataProviderInstanceLink;
	}

	@Override
	public void deleteDataProviderInstanceLink(
		DDMDataProviderInstanceLink dataProviderInstanceLink) {

		ddmDataProviderInstanceLinkPersistence.remove(dataProviderInstanceLink);
	}

	@Override
	public void deleteDataProviderInstanceLink(long dataProviderInstanceLinkId)
		throws PortalException {

		DDMDataProviderInstanceLink dataProviderInstanceLink =
			ddmDataProviderInstanceLinkPersistence.findByPrimaryKey(
				dataProviderInstanceLinkId);

		ddmDataProviderInstanceLinkPersistence.remove(dataProviderInstanceLink);
	}

	@Override
	public void deleteDataProviderInstanceLink(
			long dataProviderInstanceId, long structureId)
		throws PortalException {

		DDMDataProviderInstanceLink dataProviderInstanceLink =
			ddmDataProviderInstanceLinkPersistence.findByD_S(
				dataProviderInstanceId, structureId);

		ddmDataProviderInstanceLinkPersistence.remove(dataProviderInstanceLink);
	}

	@Override
	public void deleteDataProviderInstanceLinks(long structureId) {
		List<DDMDataProviderInstanceLink> dataProviderInstanceLinks =
			ddmDataProviderInstanceLinkPersistence.findByStructureId(
				structureId);

		for (DDMDataProviderInstanceLink dataProviderInstanceLink :
				dataProviderInstanceLinks) {

			deleteDataProviderInstanceLink(dataProviderInstanceLink);
		}
	}

	@Override
	public DDMDataProviderInstanceLink fetchDataProviderInstanceLink(
		long dataProviderInstanceId, long structureId) {

		return ddmDataProviderInstanceLinkPersistence.fetchByD_S(
			dataProviderInstanceId, structureId);
	}

	@Override
	public List<DDMDataProviderInstanceLink> getDataProviderInstanceLinks(
		long structureId) {

		return ddmDataProviderInstanceLinkPersistence.findByStructureId(
			structureId);
	}

}