/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.mapping.internal.upgrade.v1_0_1;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.portal.kernel.security.permission.ResourceActions;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringPool;

import java.sql.PreparedStatement;

/**
 * @author Rafael Praxedes
 */
public class UpgradeResourcePermission extends UpgradeProcess {

	public UpgradeResourcePermission(ResourceActions resourceActions) {
		_resourceActions = resourceActions;
	}

	@Override
	protected void doUpgrade() throws Exception {
		updateResourcePermissions(DDMStructure.class.getName());

		updateResourcePermissions(DDMTemplate.class.getName());
	}

	protected String getNewCompositeModelName(String ddmModelClassName) {
		return _resourceActions.getCompositeModelName(
			ddmModelClassName, _CLASS_NAME);
	}

	protected String getOldCompositeModelName(String ddmModelClassName) {
		return _CLASS_NAME + StringPool.DASH + ddmModelClassName;
	}

	protected void updateResourcePermissions(String ddmModelClassName)
		throws Exception {

		String newCompositeModelName = getNewCompositeModelName(
			ddmModelClassName);
		String oldCompositeModelName = getOldCompositeModelName(
			ddmModelClassName);

		try (PreparedStatement ps = connection.prepareStatement(
				"update ResourcePermission set name = ? where name = ?");
			PreparedStatement ps1 = connection.prepareStatement(
				"update ResourcePermission set primKey = ? where primKey = " +
					"?")) {

			ps.setString(1, newCompositeModelName);
			ps.setString(2, oldCompositeModelName);

			ps.executeUpdate();

			ps1.setString(1, newCompositeModelName);
			ps1.setString(2, oldCompositeModelName);

			ps1.executeUpdate();
		}
	}

	private static final String _CLASS_NAME =
		"com.liferay.journal.model.JournalArticle";

	private final ResourceActions _resourceActions;

}