/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.mapping.internal.upgrade.v1_0_0;

import com.liferay.dynamic.data.mapping.internal.upgrade.v1_0_0.util.DDMContentTable;
import com.liferay.dynamic.data.mapping.internal.upgrade.v1_0_0.util.DDMStructureTable;
import com.liferay.dynamic.data.mapping.internal.upgrade.v1_0_0.util.DDMTemplateTable;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringUtil;

/**
 * @author Marcellus Tavares
 */
public class UpgradeSchema extends UpgradeProcess {

	protected void alterTables() throws Exception {
		try (LoggingTimer loggingTimer = new LoggingTimer()) {
			alter(
				DDMContentTable.class,
				new AlterColumnName("xml", "data_ TEXT null"));
			alter(
				DDMStructureTable.class,
				new AlterColumnName("xsd", "definition TEXT null"),
				new AlterColumnType("description", "TEXT null"));
			alter(
				DDMTemplateTable.class,
				new AlterColumnType("description", "TEXT null"));
		}
	}

	@Override
	protected void doUpgrade() throws Exception {
		updateSQL();

		alterTables();
	}

	protected void updateSQL() throws Exception {
		try (LoggingTimer loggingTimer = new LoggingTimer()) {
			String template = StringUtil.read(
				UpgradeSchema.class.getResourceAsStream(
					"dependencies/update.sql"));

			runSQLTemplateString(template, false, false);
		}
	}

}