/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.mapping.internal;

import com.liferay.dynamic.data.mapping.kernel.DDMStructureLink;

/**
 * @author Rafael Praxedes
 */
public class DDMStructureLinkImpl implements DDMStructureLink {

	public DDMStructureLinkImpl(
		com.liferay.dynamic.data.mapping.model.DDMStructureLink
			ddmStructureLink) {

		_ddmStructureLink = ddmStructureLink;
	}

	@Override
	public String getClassName() {
		return _ddmStructureLink.getClassName();
	}

	@Override
	public long getClassNameId() {
		return _ddmStructureLink.getClassNameId();
	}

	@Override
	public long getClassPK() {
		return _ddmStructureLink.getClassPK();
	}

	@Override
	public long getStructureId() {
		return _ddmStructureLink.getStructureId();
	}

	@Override
	protected Object clone() {
		DDMStructureLinkImpl ddmStructureLinkImpl = new DDMStructureLinkImpl(
			(com.liferay.dynamic.data.mapping.model.DDMStructureLink)
				_ddmStructureLink.clone());

		return ddmStructureLinkImpl;
	}

	private final com.liferay.dynamic.data.mapping.model.DDMStructureLink
		_ddmStructureLink;

}