/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.persistence.impl;

import aQute.bnd.annotation.ProviderType;
import com.liferay.dynamic.data.mapping.exception.NoSuchStructureVersionException;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.model.impl.DDMStructureVersionImpl;
import com.liferay.dynamic.data.mapping.model.impl.DDMStructureVersionModelImpl;
import com.liferay.dynamic.data.mapping.service.persistence.DDMStructureVersionPersistence;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.service.persistence.CompanyProvider;
import com.liferay.portal.kernel.service.persistence.CompanyProviderWrapper;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ProviderType
public class DDMStructureVersionPersistenceImpl
extends BasePersistenceImpl<DDMStructureVersion>
implements DDMStructureVersionPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = DDMStructureVersionImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(DDMStructureVersionModelImpl.ENTITY_CACHE_ENABLED, DDMStructureVersionModelImpl.FINDER_CACHE_ENABLED, DDMStructureVersionImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(DDMStructureVersionModelImpl.ENTITY_CACHE_ENABLED, DDMStructureVersionModelImpl.FINDER_CACHE_ENABLED, DDMStructureVersionImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(DDMStructureVersionModelImpl.ENTITY_CACHE_ENABLED, DDMStructureVersionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_STRUCTUREID = new FinderPath(DDMStructureVersionModelImpl.ENTITY_CACHE_ENABLED, DDMStructureVersionModelImpl.FINDER_CACHE_ENABLED, DDMStructureVersionImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByStructureId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_STRUCTUREID = new FinderPath(DDMStructureVersionModelImpl.ENTITY_CACHE_ENABLED, DDMStructureVersionModelImpl.FINDER_CACHE_ENABLED, DDMStructureVersionImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByStructureId", new String[]{Long.class.getName()}, 2L);
    public static final FinderPath FINDER_PATH_COUNT_BY_STRUCTUREID = new FinderPath(DDMStructureVersionModelImpl.ENTITY_CACHE_ENABLED, DDMStructureVersionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByStructureId", new String[]{Long.class.getName()});
    private static final String _FINDER_COLUMN_STRUCTUREID_STRUCTUREID_2 = "ddmStructureVersion.structureId = ?";
    public static final FinderPath FINDER_PATH_FETCH_BY_S_V = new FinderPath(DDMStructureVersionModelImpl.ENTITY_CACHE_ENABLED, DDMStructureVersionModelImpl.FINDER_CACHE_ENABLED, DDMStructureVersionImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByS_V", new String[]{Long.class.getName(), String.class.getName()}, 6L);
    public static final FinderPath FINDER_PATH_COUNT_BY_S_V = new FinderPath(DDMStructureVersionModelImpl.ENTITY_CACHE_ENABLED, DDMStructureVersionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByS_V", new String[]{Long.class.getName(), String.class.getName()});
    private static final String _FINDER_COLUMN_S_V_STRUCTUREID_2 = "ddmStructureVersion.structureId = ? AND ";
    private static final String _FINDER_COLUMN_S_V_VERSION_1 = "ddmStructureVersion.version IS NULL";
    private static final String _FINDER_COLUMN_S_V_VERSION_2 = "ddmStructureVersion.version = ?";
    private static final String _FINDER_COLUMN_S_V_VERSION_3 = "(ddmStructureVersion.version IS NULL OR ddmStructureVersion.version = '')";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_S_S = new FinderPath(DDMStructureVersionModelImpl.ENTITY_CACHE_ENABLED, DDMStructureVersionModelImpl.FINDER_CACHE_ENABLED, DDMStructureVersionImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByS_S", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_S_S = new FinderPath(DDMStructureVersionModelImpl.ENTITY_CACHE_ENABLED, DDMStructureVersionModelImpl.FINDER_CACHE_ENABLED, DDMStructureVersionImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByS_S", new String[]{Long.class.getName(), Integer.class.getName()}, 3L);
    public static final FinderPath FINDER_PATH_COUNT_BY_S_S = new FinderPath(DDMStructureVersionModelImpl.ENTITY_CACHE_ENABLED, DDMStructureVersionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByS_S", new String[]{Long.class.getName(), Integer.class.getName()});
    private static final String _FINDER_COLUMN_S_S_STRUCTUREID_2 = "ddmStructureVersion.structureId = ? AND ";
    private static final String _FINDER_COLUMN_S_S_STATUS_2 = "ddmStructureVersion.status = ?";
    @ServiceReference(type=CompanyProviderWrapper.class)
    protected CompanyProvider companyProvider;
    @ServiceReference(type=EntityCache.class)
    protected EntityCache entityCache;
    @ServiceReference(type=FinderCache.class)
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_DDMSTRUCTUREVERSION = "SELECT ddmStructureVersion FROM DDMStructureVersion ddmStructureVersion";
    private static final String _SQL_SELECT_DDMSTRUCTUREVERSION_WHERE_PKS_IN = "SELECT ddmStructureVersion FROM DDMStructureVersion ddmStructureVersion WHERE structureVersionId IN (";
    private static final String _SQL_SELECT_DDMSTRUCTUREVERSION_WHERE = "SELECT ddmStructureVersion FROM DDMStructureVersion ddmStructureVersion WHERE ";
    private static final String _SQL_COUNT_DDMSTRUCTUREVERSION = "SELECT COUNT(ddmStructureVersion) FROM DDMStructureVersion ddmStructureVersion";
    private static final String _SQL_COUNT_DDMSTRUCTUREVERSION_WHERE = "SELECT COUNT(ddmStructureVersion) FROM DDMStructureVersion ddmStructureVersion WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "ddmStructureVersion.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No DDMStructureVersion exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No DDMStructureVersion exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(DDMStructureVersionPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"type"});

    public List<DDMStructureVersion> findByStructureId(long structureId) {
        return this.findByStructureId(structureId, -1, -1, null);
    }

    public List<DDMStructureVersion> findByStructureId(long structureId, int start, int end) {
        return this.findByStructureId(structureId, start, end, null);
    }

    public List<DDMStructureVersion> findByStructureId(long structureId, int start, int end, OrderByComparator<DDMStructureVersion> orderByComparator) {
        return this.findByStructureId(structureId, start, end, orderByComparator, true);
    }

    public List<DDMStructureVersion> findByStructureId(long structureId, int start, int end, OrderByComparator<DDMStructureVersion> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_STRUCTUREID;
            finderArgs = new Object[]{structureId};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_STRUCTUREID;
            finderArgs = new Object[]{structureId, start, end, orderByComparator};
        }
        List<DDMStructureVersion> list = null;
        if (retrieveFromCache && (list = (List<DDMStructureVersion>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (DDMStructureVersion ddmStructureVersion : list) {
                if (structureId == ddmStructureVersion.getStructureId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_DDMSTRUCTUREVERSION_WHERE);
            query.append(_FINDER_COLUMN_STRUCTUREID_STRUCTUREID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY ddmStructureVersion.structureVersionId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(structureId);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public DDMStructureVersion findByStructureId_First(long structureId, OrderByComparator<DDMStructureVersion> orderByComparator) throws NoSuchStructureVersionException {
        DDMStructureVersion ddmStructureVersion = this.fetchByStructureId_First(structureId, orderByComparator);
        if (ddmStructureVersion != null) {
            return ddmStructureVersion;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("structureId=");
        msg.append(structureId);
        msg.append("}");
        throw new NoSuchStructureVersionException(msg.toString());
    }

    public DDMStructureVersion fetchByStructureId_First(long structureId, OrderByComparator<DDMStructureVersion> orderByComparator) {
        List<DDMStructureVersion> list = this.findByStructureId(structureId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DDMStructureVersion findByStructureId_Last(long structureId, OrderByComparator<DDMStructureVersion> orderByComparator) throws NoSuchStructureVersionException {
        DDMStructureVersion ddmStructureVersion = this.fetchByStructureId_Last(structureId, orderByComparator);
        if (ddmStructureVersion != null) {
            return ddmStructureVersion;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("structureId=");
        msg.append(structureId);
        msg.append("}");
        throw new NoSuchStructureVersionException(msg.toString());
    }

    public DDMStructureVersion fetchByStructureId_Last(long structureId, OrderByComparator<DDMStructureVersion> orderByComparator) {
        int count = this.countByStructureId(structureId);
        if (count == 0) {
            return null;
        }
        List<DDMStructureVersion> list = this.findByStructureId(structureId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DDMStructureVersion[] findByStructureId_PrevAndNext(long structureVersionId, long structureId, OrderByComparator<DDMStructureVersion> orderByComparator) throws NoSuchStructureVersionException {
        DDMStructureVersion ddmStructureVersion = this.findByPrimaryKey(structureVersionId);
        Session session = null;
        try {
            session = this.openSession();
            DDMStructureVersion[] array = new DDMStructureVersionImpl[]{this.getByStructureId_PrevAndNext(session, ddmStructureVersion, structureId, orderByComparator, true), ddmStructureVersion, this.getByStructureId_PrevAndNext(session, ddmStructureVersion, structureId, orderByComparator, false)};
            DDMStructureVersion[] dDMStructureVersionArray = array;
            return dDMStructureVersionArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DDMStructureVersion getByStructureId_PrevAndNext(Session session, DDMStructureVersion ddmStructureVersion, long structureId, OrderByComparator<DDMStructureVersion> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_DDMSTRUCTUREVERSION_WHERE);
        query.append(_FINDER_COLUMN_STRUCTUREID_STRUCTUREID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY ddmStructureVersion.structureVersionId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(structureId);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)ddmStructureVersion)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (DDMStructureVersion)list.get(1);
        }
        return null;
    }

    public void removeByStructureId(long structureId) {
        for (DDMStructureVersion ddmStructureVersion : this.findByStructureId(structureId, -1, -1, null)) {
            this.remove((BaseModel)ddmStructureVersion);
        }
    }

    public int countByStructureId(long structureId) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_STRUCTUREID;
        Object[] finderArgs = new Object[]{structureId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_DDMSTRUCTUREVERSION_WHERE);
            query.append(_FINDER_COLUMN_STRUCTUREID_STRUCTUREID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(structureId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public DDMStructureVersion findByS_V(long structureId, String version) throws NoSuchStructureVersionException {
        DDMStructureVersion ddmStructureVersion = this.fetchByS_V(structureId, version);
        if (ddmStructureVersion == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("structureId=");
            msg.append(structureId);
            msg.append(", version=");
            msg.append(version);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)msg.toString());
            }
            throw new NoSuchStructureVersionException(msg.toString());
        }
        return ddmStructureVersion;
    }

    public DDMStructureVersion fetchByS_V(long structureId, String version) {
        return this.fetchByS_V(structureId, version, true);
    }

    public DDMStructureVersion fetchByS_V(long structureId, String version, boolean retrieveFromCache) {
        DDMStructureVersion ddmStructureVersion;
        Object[] finderArgs = new Object[]{structureId, version};
        Object result = null;
        if (retrieveFromCache) {
            result = this.finderCache.getResult(FINDER_PATH_FETCH_BY_S_V, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof DDMStructureVersion && (structureId != (ddmStructureVersion = (DDMStructureVersion)result).getStructureId() || !Objects.equals(version, ddmStructureVersion.getVersion()))) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_DDMSTRUCTUREVERSION_WHERE);
            query.append("ddmStructureVersion.structureId = ? AND ");
            boolean bindVersion = false;
            if (version == null) {
                query.append(_FINDER_COLUMN_S_V_VERSION_1);
            } else if (version.equals("")) {
                query.append(_FINDER_COLUMN_S_V_VERSION_3);
            } else {
                bindVersion = true;
                query.append(_FINDER_COLUMN_S_V_VERSION_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(structureId);
                if (bindVersion) {
                    qPos.add(version);
                }
                if ((list = q.list()).isEmpty()) {
                    this.finderCache.putResult(FINDER_PATH_FETCH_BY_S_V, finderArgs, (Object)list);
                } else {
                    DDMStructureVersion ddmStructureVersion2 = (DDMStructureVersion)list.get(0);
                    result = ddmStructureVersion2;
                    this.cacheResult(ddmStructureVersion2);
                    if (ddmStructureVersion2.getStructureId() != structureId || ddmStructureVersion2.getVersion() == null || !ddmStructureVersion2.getVersion().equals(version)) {
                        this.finderCache.putResult(FINDER_PATH_FETCH_BY_S_V, finderArgs, (Object)ddmStructureVersion2);
                    }
                }
            }
            catch (Exception e) {
                this.finderCache.removeResult(FINDER_PATH_FETCH_BY_S_V, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (DDMStructureVersion)result;
    }

    public DDMStructureVersion removeByS_V(long structureId, String version) throws NoSuchStructureVersionException {
        DDMStructureVersion ddmStructureVersion = this.findByS_V(structureId, version);
        return (DDMStructureVersion)this.remove((BaseModel)ddmStructureVersion);
    }

    public int countByS_V(long structureId, String version) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_S_V;
        Object[] finderArgs = new Object[]{structureId, version};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_DDMSTRUCTUREVERSION_WHERE);
            query.append("ddmStructureVersion.structureId = ? AND ");
            boolean bindVersion = false;
            if (version == null) {
                query.append(_FINDER_COLUMN_S_V_VERSION_1);
            } else if (version.equals("")) {
                query.append(_FINDER_COLUMN_S_V_VERSION_3);
            } else {
                bindVersion = true;
                query.append(_FINDER_COLUMN_S_V_VERSION_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(structureId);
                if (bindVersion) {
                    qPos.add(version);
                }
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<DDMStructureVersion> findByS_S(long structureId, int status) {
        return this.findByS_S(structureId, status, -1, -1, null);
    }

    public List<DDMStructureVersion> findByS_S(long structureId, int status, int start, int end) {
        return this.findByS_S(structureId, status, start, end, null);
    }

    public List<DDMStructureVersion> findByS_S(long structureId, int status, int start, int end, OrderByComparator<DDMStructureVersion> orderByComparator) {
        return this.findByS_S(structureId, status, start, end, orderByComparator, true);
    }

    public List<DDMStructureVersion> findByS_S(long structureId, int status, int start, int end, OrderByComparator<DDMStructureVersion> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_S_S;
            finderArgs = new Object[]{structureId, status};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_S_S;
            finderArgs = new Object[]{structureId, status, start, end, orderByComparator};
        }
        List<DDMStructureVersion> list = null;
        if (retrieveFromCache && (list = (List<DDMStructureVersion>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (DDMStructureVersion ddmStructureVersion : list) {
                if (structureId == ddmStructureVersion.getStructureId() && status == ddmStructureVersion.getStatus()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            query.append(_SQL_SELECT_DDMSTRUCTUREVERSION_WHERE);
            query.append("ddmStructureVersion.structureId = ? AND ");
            query.append(_FINDER_COLUMN_S_S_STATUS_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY ddmStructureVersion.structureVersionId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(structureId);
                qPos.add(status);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public DDMStructureVersion findByS_S_First(long structureId, int status, OrderByComparator<DDMStructureVersion> orderByComparator) throws NoSuchStructureVersionException {
        DDMStructureVersion ddmStructureVersion = this.fetchByS_S_First(structureId, status, orderByComparator);
        if (ddmStructureVersion != null) {
            return ddmStructureVersion;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("structureId=");
        msg.append(structureId);
        msg.append(", status=");
        msg.append(status);
        msg.append("}");
        throw new NoSuchStructureVersionException(msg.toString());
    }

    public DDMStructureVersion fetchByS_S_First(long structureId, int status, OrderByComparator<DDMStructureVersion> orderByComparator) {
        List<DDMStructureVersion> list = this.findByS_S(structureId, status, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DDMStructureVersion findByS_S_Last(long structureId, int status, OrderByComparator<DDMStructureVersion> orderByComparator) throws NoSuchStructureVersionException {
        DDMStructureVersion ddmStructureVersion = this.fetchByS_S_Last(structureId, status, orderByComparator);
        if (ddmStructureVersion != null) {
            return ddmStructureVersion;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("structureId=");
        msg.append(structureId);
        msg.append(", status=");
        msg.append(status);
        msg.append("}");
        throw new NoSuchStructureVersionException(msg.toString());
    }

    public DDMStructureVersion fetchByS_S_Last(long structureId, int status, OrderByComparator<DDMStructureVersion> orderByComparator) {
        int count = this.countByS_S(structureId, status);
        if (count == 0) {
            return null;
        }
        List<DDMStructureVersion> list = this.findByS_S(structureId, status, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DDMStructureVersion[] findByS_S_PrevAndNext(long structureVersionId, long structureId, int status, OrderByComparator<DDMStructureVersion> orderByComparator) throws NoSuchStructureVersionException {
        DDMStructureVersion ddmStructureVersion = this.findByPrimaryKey(structureVersionId);
        Session session = null;
        try {
            session = this.openSession();
            DDMStructureVersion[] array = new DDMStructureVersionImpl[]{this.getByS_S_PrevAndNext(session, ddmStructureVersion, structureId, status, orderByComparator, true), ddmStructureVersion, this.getByS_S_PrevAndNext(session, ddmStructureVersion, structureId, status, orderByComparator, false)};
            DDMStructureVersion[] dDMStructureVersionArray = array;
            return dDMStructureVersionArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DDMStructureVersion getByS_S_PrevAndNext(Session session, DDMStructureVersion ddmStructureVersion, long structureId, int status, OrderByComparator<DDMStructureVersion> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        query.append(_SQL_SELECT_DDMSTRUCTUREVERSION_WHERE);
        query.append("ddmStructureVersion.structureId = ? AND ");
        query.append(_FINDER_COLUMN_S_S_STATUS_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY ddmStructureVersion.structureVersionId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(structureId);
        qPos.add(status);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)ddmStructureVersion)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (DDMStructureVersion)list.get(1);
        }
        return null;
    }

    public void removeByS_S(long structureId, int status) {
        for (DDMStructureVersion ddmStructureVersion : this.findByS_S(structureId, status, -1, -1, null)) {
            this.remove((BaseModel)ddmStructureVersion);
        }
    }

    public int countByS_S(long structureId, int status) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_S_S;
        Object[] finderArgs = new Object[]{structureId, status};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_DDMSTRUCTUREVERSION_WHERE);
            query.append("ddmStructureVersion.structureId = ? AND ");
            query.append(_FINDER_COLUMN_S_S_STATUS_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(structureId);
                qPos.add(status);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public DDMStructureVersionPersistenceImpl() {
        this.setModelClass(DDMStructureVersion.class);
    }

    public void cacheResult(DDMStructureVersion ddmStructureVersion) {
        this.entityCache.putResult(DDMStructureVersionModelImpl.ENTITY_CACHE_ENABLED, DDMStructureVersionImpl.class, (Serializable)Long.valueOf(ddmStructureVersion.getPrimaryKey()), (Serializable)ddmStructureVersion);
        this.finderCache.putResult(FINDER_PATH_FETCH_BY_S_V, new Object[]{ddmStructureVersion.getStructureId(), ddmStructureVersion.getVersion()}, (Object)ddmStructureVersion);
        ddmStructureVersion.resetOriginalValues();
    }

    public void cacheResult(List<DDMStructureVersion> ddmStructureVersions) {
        for (DDMStructureVersion ddmStructureVersion : ddmStructureVersions) {
            if (this.entityCache.getResult(DDMStructureVersionModelImpl.ENTITY_CACHE_ENABLED, DDMStructureVersionImpl.class, (Serializable)Long.valueOf(ddmStructureVersion.getPrimaryKey())) == null) {
                this.cacheResult(ddmStructureVersion);
                continue;
            }
            ddmStructureVersion.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(DDMStructureVersionImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(DDMStructureVersion ddmStructureVersion) {
        this.entityCache.removeResult(DDMStructureVersionModelImpl.ENTITY_CACHE_ENABLED, DDMStructureVersionImpl.class, (Serializable)Long.valueOf(ddmStructureVersion.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((DDMStructureVersionModelImpl)ddmStructureVersion, true);
    }

    public void clearCache(List<DDMStructureVersion> ddmStructureVersions) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (DDMStructureVersion ddmStructureVersion : ddmStructureVersions) {
            this.entityCache.removeResult(DDMStructureVersionModelImpl.ENTITY_CACHE_ENABLED, DDMStructureVersionImpl.class, (Serializable)Long.valueOf(ddmStructureVersion.getPrimaryKey()));
            this.clearUniqueFindersCache((DDMStructureVersionModelImpl)ddmStructureVersion, true);
        }
    }

    protected void cacheUniqueFindersCache(DDMStructureVersionModelImpl ddmStructureVersionModelImpl) {
        Object[] args = new Object[]{ddmStructureVersionModelImpl.getStructureId(), ddmStructureVersionModelImpl.getVersion()};
        this.finderCache.putResult(FINDER_PATH_COUNT_BY_S_V, args, (Object)1L, false);
        this.finderCache.putResult(FINDER_PATH_FETCH_BY_S_V, args, (Object)ddmStructureVersionModelImpl, false);
    }

    protected void clearUniqueFindersCache(DDMStructureVersionModelImpl ddmStructureVersionModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{ddmStructureVersionModelImpl.getStructureId(), ddmStructureVersionModelImpl.getVersion()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_S_V, args);
            this.finderCache.removeResult(FINDER_PATH_FETCH_BY_S_V, args);
        }
        if ((ddmStructureVersionModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_S_V.getColumnBitmask()) != 0L) {
            args = new Object[]{ddmStructureVersionModelImpl.getOriginalStructureId(), ddmStructureVersionModelImpl.getOriginalVersion()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_S_V, args);
            this.finderCache.removeResult(FINDER_PATH_FETCH_BY_S_V, args);
        }
    }

    public DDMStructureVersion create(long structureVersionId) {
        DDMStructureVersionImpl ddmStructureVersion = new DDMStructureVersionImpl();
        ddmStructureVersion.setNew(true);
        ddmStructureVersion.setPrimaryKey(structureVersionId);
        ddmStructureVersion.setCompanyId(this.companyProvider.getCompanyId());
        return ddmStructureVersion;
    }

    public DDMStructureVersion remove(long structureVersionId) throws NoSuchStructureVersionException {
        return this.remove(Long.valueOf(structureVersionId));
    }

    public DDMStructureVersion remove(Serializable primaryKey) throws NoSuchStructureVersionException {
        Session session = null;
        try {
            session = this.openSession();
            DDMStructureVersion ddmStructureVersion = (DDMStructureVersion)session.get(DDMStructureVersionImpl.class, primaryKey);
            if (ddmStructureVersion == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchStructureVersionException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            DDMStructureVersion dDMStructureVersion = (DDMStructureVersion)this.remove((BaseModel)ddmStructureVersion);
            return dDMStructureVersion;
        }
        catch (NoSuchStructureVersionException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DDMStructureVersion removeImpl(DDMStructureVersion ddmStructureVersion) {
        ddmStructureVersion = this.toUnwrappedModel(ddmStructureVersion);
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)ddmStructureVersion)) {
                ddmStructureVersion = (DDMStructureVersion)session.get(DDMStructureVersionImpl.class, ddmStructureVersion.getPrimaryKeyObj());
            }
            if (ddmStructureVersion != null) {
                session.delete((Object)ddmStructureVersion);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (ddmStructureVersion != null) {
            this.clearCache(ddmStructureVersion);
        }
        return ddmStructureVersion;
    }

    public DDMStructureVersion updateImpl(DDMStructureVersion ddmStructureVersion) {
        ddmStructureVersion = this.toUnwrappedModel(ddmStructureVersion);
        boolean isNew = ddmStructureVersion.isNew();
        DDMStructureVersionModelImpl ddmStructureVersionModelImpl = (DDMStructureVersionModelImpl)ddmStructureVersion;
        Session session = null;
        try {
            session = this.openSession();
            if (ddmStructureVersion.isNew()) {
                session.save((Object)ddmStructureVersion);
                ddmStructureVersion.setNew(false);
            } else {
                ddmStructureVersion = (DDMStructureVersion)session.merge((Object)ddmStructureVersion);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (isNew || !DDMStructureVersionModelImpl.COLUMN_BITMASK_ENABLED) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else {
            Object[] args;
            if ((ddmStructureVersionModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_STRUCTUREID.getColumnBitmask()) != 0L) {
                args = new Object[]{ddmStructureVersionModelImpl.getOriginalStructureId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_STRUCTUREID, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_STRUCTUREID, args);
                args = new Object[]{ddmStructureVersionModelImpl.getStructureId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_STRUCTUREID, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_STRUCTUREID, args);
            }
            if ((ddmStructureVersionModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_S_S.getColumnBitmask()) != 0L) {
                args = new Object[]{ddmStructureVersionModelImpl.getOriginalStructureId(), ddmStructureVersionModelImpl.getOriginalStatus()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_S_S, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_S_S, args);
                args = new Object[]{ddmStructureVersionModelImpl.getStructureId(), ddmStructureVersionModelImpl.getStatus()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_S_S, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_S_S, args);
            }
        }
        this.entityCache.putResult(DDMStructureVersionModelImpl.ENTITY_CACHE_ENABLED, DDMStructureVersionImpl.class, (Serializable)Long.valueOf(ddmStructureVersion.getPrimaryKey()), (Serializable)ddmStructureVersion, false);
        this.clearUniqueFindersCache(ddmStructureVersionModelImpl, false);
        this.cacheUniqueFindersCache(ddmStructureVersionModelImpl);
        ddmStructureVersion.resetOriginalValues();
        return ddmStructureVersion;
    }

    protected DDMStructureVersion toUnwrappedModel(DDMStructureVersion ddmStructureVersion) {
        if (ddmStructureVersion instanceof DDMStructureVersionImpl) {
            return ddmStructureVersion;
        }
        DDMStructureVersionImpl ddmStructureVersionImpl = new DDMStructureVersionImpl();
        ddmStructureVersionImpl.setNew(ddmStructureVersion.isNew());
        ddmStructureVersionImpl.setPrimaryKey(ddmStructureVersion.getPrimaryKey());
        ddmStructureVersionImpl.setStructureVersionId(ddmStructureVersion.getStructureVersionId());
        ddmStructureVersionImpl.setGroupId(ddmStructureVersion.getGroupId());
        ddmStructureVersionImpl.setCompanyId(ddmStructureVersion.getCompanyId());
        ddmStructureVersionImpl.setUserId(ddmStructureVersion.getUserId());
        ddmStructureVersionImpl.setUserName(ddmStructureVersion.getUserName());
        ddmStructureVersionImpl.setCreateDate(ddmStructureVersion.getCreateDate());
        ddmStructureVersionImpl.setStructureId(ddmStructureVersion.getStructureId());
        ddmStructureVersionImpl.setVersion(ddmStructureVersion.getVersion());
        ddmStructureVersionImpl.setParentStructureId(ddmStructureVersion.getParentStructureId());
        ddmStructureVersionImpl.setName(ddmStructureVersion.getName());
        ddmStructureVersionImpl.setDescription(ddmStructureVersion.getDescription());
        ddmStructureVersionImpl.setDefinition(ddmStructureVersion.getDefinition());
        ddmStructureVersionImpl.setStorageType(ddmStructureVersion.getStorageType());
        ddmStructureVersionImpl.setType(ddmStructureVersion.getType());
        ddmStructureVersionImpl.setStatus(ddmStructureVersion.getStatus());
        ddmStructureVersionImpl.setStatusByUserId(ddmStructureVersion.getStatusByUserId());
        ddmStructureVersionImpl.setStatusByUserName(ddmStructureVersion.getStatusByUserName());
        ddmStructureVersionImpl.setStatusDate(ddmStructureVersion.getStatusDate());
        return ddmStructureVersionImpl;
    }

    public DDMStructureVersion findByPrimaryKey(Serializable primaryKey) throws NoSuchStructureVersionException {
        DDMStructureVersion ddmStructureVersion = this.fetchByPrimaryKey(primaryKey);
        if (ddmStructureVersion == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchStructureVersionException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return ddmStructureVersion;
    }

    public DDMStructureVersion findByPrimaryKey(long structureVersionId) throws NoSuchStructureVersionException {
        return this.findByPrimaryKey(Long.valueOf(structureVersionId));
    }

    public DDMStructureVersion fetchByPrimaryKey(Serializable primaryKey) {
        Serializable serializable = this.entityCache.getResult(DDMStructureVersionModelImpl.ENTITY_CACHE_ENABLED, DDMStructureVersionImpl.class, primaryKey);
        if (serializable == nullModel) {
            return null;
        }
        DDMStructureVersion ddmStructureVersion = (DDMStructureVersion)serializable;
        if (ddmStructureVersion == null) {
            Session session = null;
            try {
                session = this.openSession();
                ddmStructureVersion = (DDMStructureVersion)session.get(DDMStructureVersionImpl.class, primaryKey);
                if (ddmStructureVersion != null) {
                    this.cacheResult(ddmStructureVersion);
                } else {
                    this.entityCache.putResult(DDMStructureVersionModelImpl.ENTITY_CACHE_ENABLED, DDMStructureVersionImpl.class, primaryKey, (Serializable)nullModel);
                }
            }
            catch (Exception e) {
                this.entityCache.removeResult(DDMStructureVersionModelImpl.ENTITY_CACHE_ENABLED, DDMStructureVersionImpl.class, primaryKey);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return ddmStructureVersion;
    }

    public DDMStructureVersion fetchByPrimaryKey(long structureVersionId) {
        return this.fetchByPrimaryKey(Long.valueOf(structureVersionId));
    }

    public Map<Serializable, DDMStructureVersion> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        Session session;
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, DDMStructureVersion> map = new HashMap<Serializable, DDMStructureVersion>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            DDMStructureVersion dDMStructureVersion = this.fetchByPrimaryKey(primaryKey);
            if (dDMStructureVersion != null) {
                map.put(primaryKey, dDMStructureVersion);
            }
            return map;
        }
        HashSet<Serializable> uncachedPrimaryKeys = null;
        for (Serializable serializable : primaryKeys) {
            Serializable serializable2 = this.entityCache.getResult(DDMStructureVersionModelImpl.ENTITY_CACHE_ENABLED, DDMStructureVersionImpl.class, serializable);
            if (serializable2 == nullModel) continue;
            if (serializable2 == null) {
                if (uncachedPrimaryKeys == null) {
                    uncachedPrimaryKeys = new HashSet<Serializable>();
                }
                uncachedPrimaryKeys.add(serializable);
                continue;
            }
            map.put(serializable, (DDMStructureVersion)serializable2);
        }
        if (uncachedPrimaryKeys == null) {
            return map;
        }
        StringBundler query = new StringBundler(uncachedPrimaryKeys.size() * 2 + 1);
        query.append(_SQL_SELECT_DDMSTRUCTUREVERSION_WHERE_PKS_IN);
        for (Serializable serializable : uncachedPrimaryKeys) {
            query.append(String.valueOf(serializable));
            query.append(",");
        }
        query.setIndex(query.index() - 1);
        query.append(")");
        String string = query.toString();
        Session session2 = null;
        try {
            session = this.openSession();
            Query q = session.createQuery(string);
            for (DDMStructureVersion dDMStructureVersion : q.list()) {
                map.put(dDMStructureVersion.getPrimaryKeyObj(), dDMStructureVersion);
                this.cacheResult(dDMStructureVersion);
                uncachedPrimaryKeys.remove(dDMStructureVersion.getPrimaryKeyObj());
            }
            for (Serializable serializable : uncachedPrimaryKeys) {
                this.entityCache.putResult(DDMStructureVersionModelImpl.ENTITY_CACHE_ENABLED, DDMStructureVersionImpl.class, serializable, (Serializable)nullModel);
            }
        }
        catch (Exception e) {
            try {
                throw this.processException(e);
            }
            catch (Throwable throwable) {
                this.closeSession(session2);
                throw throwable;
            }
        }
        this.closeSession(session);
        return map;
    }

    public List<DDMStructureVersion> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<DDMStructureVersion> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<DDMStructureVersion> findAll(int start, int end, OrderByComparator<DDMStructureVersion> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<DDMStructureVersion> findAll(int start, int end, OrderByComparator<DDMStructureVersion> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (retrieveFromCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_DDMSTRUCTUREVERSION);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_DDMSTRUCTUREVERSION;
                if (pagination) {
                    sql = sql.concat(" ORDER BY ddmStructureVersion.structureVersionId ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (DDMStructureVersion ddmStructureVersion : this.findAll()) {
            this.remove((BaseModel)ddmStructureVersion);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_DDMSTRUCTUREVERSION);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return DDMStructureVersionModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
    }

    public void destroy() {
        this.entityCache.removeCache(DDMStructureVersionImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

