/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.render.impl;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.render.BaseDDMFormFieldValueRenderer;
import com.liferay.dynamic.data.mapping.render.ValueAccessor;
import com.liferay.dynamic.data.mapping.render.ValueAccessorException;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import java.util.Locale;

public class JournalArticleDDMFormFieldValueRenderer
extends BaseDDMFormFieldValueRenderer {
    public String getSupportedDDMFormFieldType() {
        return "ddm-journal-article";
    }

    protected ValueAccessor getValueAcessor(Locale locale) {
        return new ValueAccessor(locale){

            public String get(DDMFormFieldValue ddmFormFieldValue) {
                Value value = ddmFormFieldValue.getValue();
                JSONObject jsonObject = this.createJSONObject(value.getString(this.locale));
                long assetEntryId = jsonObject.getLong("assetentryid");
                try {
                    AssetEntry assetEntry = AssetEntryLocalServiceUtil.getAssetEntry((long)assetEntryId);
                    return assetEntry.getTitle(this.locale);
                }
                catch (Exception e) {
                    return LanguageUtil.format((Locale)this.locale, (String)"is-temporarily-unavailable", (Object)"content");
                }
            }

            protected JSONObject createJSONObject(String json) {
                try {
                    return JSONFactoryUtil.createJSONObject((String)json);
                }
                catch (JSONException jsone) {
                    throw new ValueAccessorException((Throwable)jsone);
                }
            }
        };
    }
}

