/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.render.impl;

import com.liferay.document.library.kernel.service.DLAppLocalServiceUtil;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.render.BaseDDMFormFieldValueRenderer;
import com.liferay.dynamic.data.mapping.render.ValueAccessor;
import com.liferay.dynamic.data.mapping.render.ValueAccessorException;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import java.util.Locale;

public class DocumentLibraryDDMFormFieldValueRenderer
extends BaseDDMFormFieldValueRenderer {
    public String getSupportedDDMFormFieldType() {
        return "ddm-documentlibrary";
    }

    protected ValueAccessor getValueAcessor(Locale locale) {
        return new ValueAccessor(locale){

            public String get(DDMFormFieldValue ddmFormFieldValue) {
                Value value = ddmFormFieldValue.getValue();
                JSONObject jsonObject = this.createJSONObject(value.getString(this.locale));
                String uuid = jsonObject.getString("uuid");
                long groupId = jsonObject.getLong("groupId");
                try {
                    FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntryByUuidAndGroupId((String)uuid, (long)groupId);
                    return fileEntry.getTitle();
                }
                catch (Exception e) {
                    return LanguageUtil.format((Locale)this.locale, (String)"is-temporarily-unavailable", (Object)"content");
                }
            }

            protected JSONObject createJSONObject(String json) {
                try {
                    return JSONFactoryUtil.createJSONObject((String)json);
                }
                catch (JSONException jsone) {
                    throw new ValueAccessorException((Throwable)jsone);
                }
            }
        };
    }
}

