/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.renderer.internal;

import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluator;
import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluatorEvaluateRequest;
import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluatorEvaluateResponse;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesRegistry;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderingContext;
import com.liferay.dynamic.data.mapping.form.renderer.internal.DDMFormFieldTemplateContextFactory;
import com.liferay.dynamic.data.mapping.form.renderer.internal.DefaultDDMFormValuesFactory;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutColumn;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutPage;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutRow;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.service.DDMStructureLayoutLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.google.places.util.GooglePlacesUtil;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.HtmlParser;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class DDMFormPagesTemplateContextFactory {
    private static final Log _log = LogFactoryUtil.getLog(DDMFormPagesTemplateContextFactory.class);
    private final DDMForm _ddmForm;
    private DDMFormEvaluator _ddmFormEvaluator;
    private DDMFormEvaluatorEvaluateResponse _ddmFormEvaluatorEvaluateResponse;
    private final Map<String, DDMFormField> _ddmFormFieldsMap;
    private DDMFormFieldTypeServicesRegistry _ddmFormFieldTypeServicesRegistry;
    private final Map<String, List<DDMFormFieldValue>> _ddmFormFieldValuesMap;
    private final DDMFormLayout _ddmFormLayout;
    private final DDMFormRenderingContext _ddmFormRenderingContext;
    private final DDMFormValues _ddmFormValues;
    private final DDMStructureLayoutLocalService _ddmStructureLayoutLocalService;
    private final DDMStructureLocalService _ddmStructureLocalService;
    private final GroupLocalService _groupLocalService;
    private final HtmlParser _htmlParser;
    private final JSONFactory _jsonFactory;
    private final Locale _locale;
    private boolean _pageEnabled;

    public DDMFormPagesTemplateContextFactory(DDMForm ddmForm, DDMFormLayout ddmFormLayout, DDMFormRenderingContext ddmFormRenderingContext, DDMStructureLayoutLocalService ddmStructureLayoutLocalService, DDMStructureLocalService ddmStructureLocalService, GroupLocalService groupLocalService, HtmlParser htmlParser, JSONFactory jsonFactory) {
        this._ddmForm = ddmForm;
        this._ddmFormLayout = ddmFormLayout;
        this._ddmFormRenderingContext = ddmFormRenderingContext;
        this._ddmStructureLayoutLocalService = ddmStructureLayoutLocalService;
        this._ddmStructureLocalService = ddmStructureLocalService;
        this._groupLocalService = groupLocalService;
        this._htmlParser = htmlParser;
        this._jsonFactory = jsonFactory;
        DDMFormValues ddmFormValues = ddmFormRenderingContext.getDDMFormValues();
        DefaultDDMFormValuesFactory defaultDDMFormValuesFactory = new DefaultDDMFormValuesFactory(ddmForm);
        if (ddmFormValues == null || ListUtil.isEmpty((List)ddmFormValues.getDDMFormFieldValues())) {
            ddmFormValues = defaultDDMFormValuesFactory.create();
        } else {
            defaultDDMFormValuesFactory.populate(ddmFormValues);
        }
        this._ddmFormValues = ddmFormValues;
        this._ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        this._ddmFormFieldValuesMap = ddmFormValues.getDDMFormFieldValuesMap(true);
        this._locale = ddmFormRenderingContext.getLocale();
    }

    public List<Object> create() {
        this._evaluate();
        return this._createPagesTemplateContext(this._ddmFormLayout.getDDMFormLayoutPages());
    }

    public void setDDMFormEvaluator(DDMFormEvaluator ddmFormEvaluator) {
        this._ddmFormEvaluator = ddmFormEvaluator;
    }

    public void setDDMFormFieldTypeServicesRegistry(DDMFormFieldTypeServicesRegistry ddmFormFieldTypeServicesRegistry) {
        this._ddmFormFieldTypeServicesRegistry = ddmFormFieldTypeServicesRegistry;
    }

    protected String getValue(DDMFormRenderingContext ddmFormRenderingContext, String value) {
        if (ddmFormRenderingContext.isViewMode()) {
            return this._htmlParser.extractText(value);
        }
        return value;
    }

    protected boolean isShowRequiredFieldsWarning(List<DDMFormLayoutRow> ddmFormLayoutRows) {
        if (!this._ddmFormRenderingContext.isShowRequiredFieldsWarning()) {
            return false;
        }
        for (DDMFormLayoutRow ddmFormLayoutRow : ddmFormLayoutRows) {
            for (DDMFormLayoutColumn ddmFormLayoutColumn : ddmFormLayoutRow.getDDMFormLayoutColumns()) {
                if (!this._containsRequiredField(ddmFormLayoutColumn.getDDMFormFieldNames())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean _containsRequiredField(List<String> ddmFormFieldNames) {
        for (String ddmFormFieldName : ddmFormFieldNames) {
            DDMFormField ddmFormField = this._ddmFormFieldsMap.get(ddmFormFieldName);
            if (!ddmFormField.isRequired()) continue;
            return true;
        }
        return false;
    }

    private List<Object> _createColumnsTemplateContext(List<DDMFormLayoutColumn> ddmFormLayoutColumns) {
        return TransformUtil.transform(ddmFormLayoutColumns, ddmFormLayoutColumn -> this._createColumnTemplateContext(ddmFormLayoutColumn.getDDMFormFieldNames(), ddmFormLayoutColumn.getSize()));
    }

    private Map<String, Object> _createColumnTemplateContext(List<String> ddmFormFiledNames, int size) {
        return HashMapBuilder.put((Object)"fields", this._createFieldsTemplateContext(ddmFormFiledNames)).put((Object)"size", (Object)size).build();
    }

    private List<Object> _createFieldsTemplateContext(List<String> ddmFormFieldNames) {
        ArrayList<Object> fieldsTemplateContext = new ArrayList<Object>();
        for (String ddmFormFieldName : ddmFormFieldNames) {
            List<Object> fieldTemplateContexts = this._createFieldTemplateContext(ddmFormFieldName);
            if (!ListUtil.isNotEmpty(fieldTemplateContexts)) continue;
            fieldsTemplateContext.addAll(fieldTemplateContexts);
        }
        return fieldsTemplateContext;
    }

    private List<Object> _createFieldTemplateContext(String ddmFormFieldName) {
        DDMFormFieldTemplateContextFactory ddmFormFieldTemplateContextFactory = new DDMFormFieldTemplateContextFactory(this._ddmFormEvaluator, ddmFormFieldName, this._ddmFormFieldsMap, this._ddmFormEvaluatorEvaluateResponse.getDDMFormFieldsPropertyChanges(), this._ddmFormFieldValuesMap.get(ddmFormFieldName), this._ddmFormRenderingContext, this._ddmStructureLayoutLocalService, this._ddmStructureLocalService, this._groupLocalService, this._htmlParser, this._jsonFactory, this._pageEnabled, this._ddmFormLayout);
        ddmFormFieldTemplateContextFactory.setDDMFormFieldTypeServicesRegistry(this._ddmFormFieldTypeServicesRegistry);
        return ddmFormFieldTemplateContextFactory.create();
    }

    private List<Object> _createPagesTemplateContext(List<DDMFormLayoutPage> ddmFormLayoutPages) {
        ArrayList<Object> pagesTemplateContext = new ArrayList<Object>();
        int i = 0;
        for (DDMFormLayoutPage ddmFormLayoutPage : ddmFormLayoutPages) {
            pagesTemplateContext.add(this._createPageTemplateContext(ddmFormLayoutPage, i++));
        }
        return pagesTemplateContext;
    }

    private Map<String, Object> _createPageTemplateContext(DDMFormLayoutPage ddmFormLayoutPage, int pageIndex) {
        HashMap<String, Object> pageTemplateContext = new HashMap<String, Object>();
        LocalizedValue description = ddmFormLayoutPage.getDescription();
        pageTemplateContext.put("description", description.getString(this._locale));
        this._pageEnabled = this._isPageEnabled(pageIndex);
        pageTemplateContext.put("enabled", this._pageEnabled);
        pageTemplateContext.put("localizedDescription", this._getLocalizedValueMap(description, this._ddmFormRenderingContext));
        LocalizedValue title = ddmFormLayoutPage.getTitle();
        pageTemplateContext.put("localizedTitle", this._getLocalizedValueMap(title, this._ddmFormRenderingContext));
        pageTemplateContext.put("rows", this._createRowsTemplateContext(ddmFormLayoutPage.getDDMFormLayoutRows()));
        boolean showRequiredFieldsWarning = this.isShowRequiredFieldsWarning(ddmFormLayoutPage.getDDMFormLayoutRows());
        pageTemplateContext.put("showRequiredFieldsWarning", showRequiredFieldsWarning);
        pageTemplateContext.put("title", title.getString(this._locale));
        return pageTemplateContext;
    }

    private List<Object> _createRowsTemplateContext(List<DDMFormLayoutRow> ddmFormLayoutRows) {
        return TransformUtil.transform(ddmFormLayoutRows, ddmFormLayoutRow -> this._createRowTemplateContext((DDMFormLayoutRow)ddmFormLayoutRow));
    }

    private Map<String, Object> _createRowTemplateContext(DDMFormLayoutRow ddmFormLayoutRow) {
        return HashMapBuilder.put((Object)"columns", this._createColumnsTemplateContext(ddmFormLayoutRow.getDDMFormLayoutColumns())).build();
    }

    private void _evaluate() {
        try {
            HttpServletRequest httpServletRequest = this._ddmFormRenderingContext.getHttpServletRequest();
            long companyId = PortalUtil.getCompanyId((HttpServletRequest)httpServletRequest);
            DDMFormEvaluatorEvaluateRequest.Builder ddmFormEvaluatorEvaluateRequestBuilder = DDMFormEvaluatorEvaluateRequest.Builder.newBuilder((DDMForm)this._ddmForm, (DDMFormValues)this._ddmFormValues, (Locale)this._locale);
            ddmFormEvaluatorEvaluateRequestBuilder.withCompanyId(companyId).withDDMFormInstanceId(this._ddmFormRenderingContext.getDDMFormInstanceId()).withDDMFormLayout(this._ddmFormLayout).withEditingFieldValue(Validator.isNotNull((String)httpServletRequest.getParameter("trigger"))).withGooglePlacesAPIKey(GooglePlacesUtil.getGooglePlacesAPIKey((long)companyId, (long)this._ddmFormRenderingContext.getGroupId(), (GroupLocalService)this._groupLocalService)).withGroupId(this._ddmFormRenderingContext.getGroupId()).withObjectFieldsJSONArray(this._ddmForm.getObjectFieldsJSONArray()).withTimeZoneId(this._getTimeZoneId(httpServletRequest)).withUserId(PortalUtil.getUserId((HttpServletRequest)httpServletRequest)).withViewMode(this._isViewMode());
            this._ddmFormEvaluatorEvaluateResponse = this._ddmFormEvaluator.evaluate(ddmFormEvaluatorEvaluateRequestBuilder.build());
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to evaluate the form", (Throwable)exception);
            throw new IllegalStateException("Unexpected error occurred during form evaluation", exception);
        }
    }

    private Map<String, String> _getLocalizedValueMap(LocalizedValue localizedValue, DDMFormRenderingContext ddmFormRenderingContext) {
        HashMap<String, String> map = new HashMap<String, String>();
        Map values = localizedValue.getValues();
        for (Map.Entry entry : values.entrySet()) {
            String languageId = LocaleUtil.toLanguageId((Locale)((Locale)entry.getKey()));
            String keyValue = this.getValue(ddmFormRenderingContext, (String)entry.getValue());
            map.put(languageId, keyValue);
        }
        return map;
    }

    private String _getTimeZoneId(HttpServletRequest httpServletRequest) {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay == null) {
            return "";
        }
        User user = themeDisplay.getUser();
        return user.getTimeZoneId();
    }

    private boolean _isPageEnabled(int pageIndex) {
        Set disabledPagesIndexes = this._ddmFormEvaluatorEvaluateResponse.getDisabledPagesIndexes();
        return !disabledPagesIndexes.contains(pageIndex);
    }

    private boolean _isViewMode() {
        Boolean viewMode = (Boolean)this._ddmFormRenderingContext.getProperty("viewMode");
        if (viewMode != null) {
            return viewMode;
        }
        String portletNamespace = this._ddmFormRenderingContext.getPortletNamespace();
        return portletNamespace != null && !StringUtil.equals((String)portletNamespace, (String)PortalUtil.getPortletNamespace((String)"com_liferay_dynamic_data_mapping_form_web_portlet_DDMFormAdminPortlet"));
    }

    private void _removeStaleDDMFormFieldValues(Map<String, DDMFormField> ddmFormFieldsMap, List<DDMFormFieldValue> ddmFormFieldValues) {
        Iterator<DDMFormFieldValue> iterator = ddmFormFieldValues.iterator();
        while (iterator.hasNext()) {
            DDMFormFieldValue ddmFormFieldValue = iterator.next();
            if (!ddmFormFieldsMap.containsKey(ddmFormFieldValue.getName())) {
                iterator.remove();
            }
            this._removeStaleDDMFormFieldValues(ddmFormFieldsMap, ddmFormFieldValue.getNestedDDMFormFieldValues());
        }
    }
}

