Liferay.Loader.define("dynamic-data-mapping-form-renderer@5.0.74/js/thunks/formValidate.es", ['module', 'exports', 'require', '../actions/eventTypes.es', '../util/evaluation.es', '../util/visitors.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = formValidate;

    var _eventTypes = require("../actions/eventTypes.es");

    var _evaluation = require("../util/evaluation.es");

    var _visitors = require("../util/visitors.es");

    /**
     * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
     * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
     */
    function formValidate(_ref) {
      var activePage = _ref.activePage,
          defaultLanguageId = _ref.defaultLanguageId,
          editingLanguageId = _ref.editingLanguageId,
          groupId = _ref.groupId,
          pages = _ref.pages,
          portletNamespace = _ref.portletNamespace,
          rules = _ref.rules;
      return function (dispatch) {
        var ddmFormSubmitButton = document.getElementById('ddm-form-submit');

        if (ddmFormSubmitButton) {
          ddmFormSubmitButton.disabled = true;
        }

        return (0, _evaluation.evaluate)(null, {
          defaultLanguageId: defaultLanguageId,
          editingLanguageId: editingLanguageId,
          groupId: groupId,
          pages: pages,
          portletNamespace: portletNamespace,
          rules: rules
        }).then(function (evaluatedPages) {
          var validForm = true;
          var visitor = new _visitors.PagesVisitor(evaluatedPages);
          visitor.mapFields(function (_ref2) {
            var valid = _ref2.valid;

            if (!valid) {
              validForm = false;
            }
          }, true, true);

          if (!validForm) {
            if (ddmFormSubmitButton) {
              ddmFormSubmitButton.disabled = false;
            }

            dispatch({
              payload: {
                newPages: evaluatedPages,
                pageIndex: activePage
              },
              type: _eventTypes.EVENT_TYPES.PAGE_VALIDATION_FAILED
            });
          }

          return Promise.resolve(validForm);
        });
      };
    }
    //# sourceMappingURL=formValidate.es.js.map
  }
});
//# sourceMappingURL=formValidate.es.js.map