Liferay.Loader.define("dynamic-data-mapping-form-renderer@5.0.74/js/components/PaginationControls.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/icon', 'frontend-js-react-web$react', '../hooks/useEvaluate.es', '../hooks/useForm.es', '../hooks/usePage.es', '../thunks/nextPage.es', '../thunks/previousPage.es', '../util/formId.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.PaginationControls = void 0;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    var _useEvaluate = require("../hooks/useEvaluate.es");

    var _useForm = require("../hooks/useForm.es");

    var _usePage2 = require("../hooks/usePage.es");

    var _nextPage = _interopRequireDefault(require("../thunks/nextPage.es"));

    var _previousPage = _interopRequireDefault(require("../thunks/previousPage.es"));

    var _formId = require("../util/formId.es");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
     * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
     */
    var PaginationControls = function PaginationControls(_ref) {
      var activePage = _ref.activePage,
          readOnly = _ref.readOnly,
          showSubmitButton = _ref.showSubmitButton,
          _ref$strings = _ref.strings,
          strings = _ref$strings === void 0 ? null : _ref$strings,
          submitLabel = _ref.submitLabel,
          total = _ref.total;

      var _usePage = (0, _usePage2.usePage)(),
          cancelLabel = _usePage.cancelLabel,
          containerElement = _usePage.containerElement,
          redirectURL = _usePage.redirectURL,
          showCancelButton = _usePage.showCancelButton;

      var createPreviousPage = (0, _useEvaluate.useEvaluate)(_previousPage.default);
      var createNextPage = (0, _useEvaluate.useEvaluate)(_nextPage.default);
      var dispatch = (0, _useForm.useForm)();
      return (/*#__PURE__*/_react.default.createElement("div", {
          className: "lfr-ddm-form-pagination-controls"
        }, activePage > 0 && /*#__PURE__*/_react.default.createElement(_button.default, {
          className: "lfr-ddm-form-pagination-prev",
          onClick: function onClick() {
            return dispatch(createPreviousPage({
              activePage: activePage,
              formId: (0, _formId.getFormId)((0, _formId.getFormNode)(containerElement.current))
            }));
          },
          type: "button"
        }, /*#__PURE__*/_react.default.createElement(_icon.default, {
          symbol: "angle-left"
        }), strings !== null ? strings['previous'] : Liferay.Language.get('previous')), activePage < total - 1 && /*#__PURE__*/_react.default.createElement(_button.default, {
          className: "float-right lfr-ddm-form-pagination-next",
          onClick: function onClick() {
            return dispatch(createNextPage({
              activePage: activePage,
              formId: (0, _formId.getFormId)((0, _formId.getFormNode)(containerElement.current))
            }));
          },
          type: "button"
        }, strings !== null ? strings['next'] : Liferay.Language.get('next'), /*#__PURE__*/_react.default.createElement(_icon.default, {
          symbol: "angle-right"
        })), activePage === total - 1 && !readOnly && showSubmitButton && /*#__PURE__*/_react.default.createElement(_button.default, {
          className: "float-right lfr-ddm-form-submit",
          id: "ddm-form-submit",
          type: "submit"
        }, submitLabel), showCancelButton && !readOnly && /*#__PURE__*/_react.default.createElement("div", {
          className: "ddm-btn-cancel float-right"
        }, /*#__PURE__*/_react.default.createElement("a", {
          className: "btn btn-cancel btn-secondary",
          href: redirectURL
        }, cancelLabel)))
      );
    };

    exports.PaginationControls = PaginationControls;
    //# sourceMappingURL=PaginationControls.es.js.map
  }
});
//# sourceMappingURL=PaginationControls.es.js.map