Liferay.Loader.define("dynamic-data-mapping-form-renderer@5.0.73/js/reducers/pageReducer.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-field-type/util/strings.es', '../actions/eventTypes.es', '../util/visitors.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _strings = require("dynamic-data-mapping-form-field-type/util/strings.es");

    var _eventTypes = require("../actions/eventTypes.es");

    var _visitors = require("../util/visitors.es");

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    var _default = function _default(state, action) {
      switch (action.type) {
        case _eventTypes.EVENT_TYPES.UPDATE_PAGES:
          return {
            pages: action.payload
          };

        case _eventTypes.EVENT_TYPES.CHANGE_ACTIVE_PAGE:
          return {
            activePage: action.payload
          };

        case _eventTypes.EVENT_TYPES.PAGE_VALIDATION_FAILED:
          {
            var _action$payload = action.payload,
                newPages = _action$payload.newPages,
                pageIndex = _action$payload.pageIndex;
            var visitor = new _visitors.PagesVisitor(newPages !== null && newPages !== void 0 ? newPages : state.pages);

            var firstInvalidFieldLabel = null;
            var firstInvalidFieldInput = null;
            var firstInvalidFieldName = null;
            var pages = visitor.mapFields(function (field, fieldIndex, columnIndex, rowIndex, currentPageIndex) {
              var displayErrors = currentPageIndex === pageIndex;

              if (displayErrors && field.errorMessage !== undefined && field.errorMessage !== '' && !field.valid && firstInvalidFieldLabel == null) {
                firstInvalidFieldLabel = field.label;
                firstInvalidFieldInput = document.querySelector("[name='".concat(field.name, "']"));
                firstInvalidFieldName = field.name;
              }

              return _objectSpread(_objectSpread({}, field), {}, {
                displayErrors: displayErrors
              });
            }, true, true);

            if (firstInvalidFieldInput) {
              if (!['select-multiple', 'radio', 'checkbox', 'text', 'hidden'].includes(firstInvalidFieldInput.type)) {
                firstInvalidFieldInput.focus();
              } else {
                var _document$getElements, _document$getElements2;

                (_document$getElements = document.getElementsByName(firstInvalidFieldName)[0]) === null || _document$getElements === void 0 ? void 0 : (_document$getElements2 = _document$getElements.parentElement) === null || _document$getElements2 === void 0 ? void 0 : _document$getElements2.scrollIntoView();
              }
            }

            return {
              forceAriaUpdate: Date.now(),
              invalidFormMessage: (0, _strings.sub)(Liferay.Language.get('this-form-is-invalid-check-field-x'), [firstInvalidFieldLabel]),
              pages: pages
            };
          }

        default:
          return state;
      }
    };

    exports.default = _default;
    //# sourceMappingURL=pageReducer.es.js.map
  }
});
//# sourceMappingURL=pageReducer.es.js.map