Liferay.Loader.define("dynamic-data-mapping-form-renderer@4.0.75/js/store/actions/handlePaginationPreviousClicked.es", ['module', 'exports', 'require', '../../util/evaluation.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _evaluation = require("../../util/evaluation.es");

  /**
   * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
   * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
   */
  var _default = function _default(evaluatorContext, dispatch) {
    var activePage = evaluatorContext.activePage,
        formId = evaluatorContext.formId,
        pages = evaluatorContext.pages;
    return (0, _evaluation.evaluate)(null, evaluatorContext).then(function (evaluatedPages) {
      var previousActivePageIndex = activePage;

      for (var i = activePage - 1; i > -1; i--) {
        if (evaluatedPages[i].enabled) {
          previousActivePageIndex = i;
          break;
        }
      }

      var activePageUpdated = Math.max(previousActivePageIndex, 0);
      dispatch('activePageUpdated', activePageUpdated);
      Liferay.fire('ddmFormPageShow', {
        formId: formId,
        page: activePageUpdated,
        title: pages[activePageUpdated].title
      });
    });
  };

  exports["default"] = _default;
  //# sourceMappingURL=handlePaginationPreviousClicked.es.js.map
});
//# sourceMappingURL=handlePaginationPreviousClicked.es.js.map