/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import {getField, isFieldSet, isFieldSetChild} from './fieldSupport.es';

export const disableFieldDropTargets = (element) => {
	const dropTargets = element.querySelectorAll('.ddm-target');

	for (let i = 0; i < dropTargets.length; i++) {
		const target = dropTargets[i];

		const parentFieldNode = target.closest('.ddm-field-container');

		if (parentFieldNode) {
			target.setAttribute('data-drop-disabled', true);
		}
	}
};

export const disableFieldSetDragSources = (element, pages) => {
	const dragSources = element.querySelectorAll('.ddm-drag');

	for (let i = 0; i < dragSources.length; i++) {
		const source = dragSources[i];

		const {fieldName} = source.parentElement.dataset;

		if (isFieldSetChild(pages, fieldName)) {
			source.setAttribute('data-drag-disabled', true);
		}
	}
};

export const disableFieldSetDropTargets = (element, pages) => {
	const dropTargets = element.querySelectorAll('.ddm-target');

	for (let i = 0; i < dropTargets.length; i++) {
		const target = dropTargets[i];

		const parentFieldNode = target.closest('.ddm-field-container');

		if (parentFieldNode) {
			const {fieldName} = parentFieldNode.dataset;

			const parentField = getField(pages, fieldName);

			if (
				(parentField && isFieldSet(parentField)) ||
				isFieldSetChild(pages, fieldName)
			) {
				target.setAttribute('data-drop-disabled', true);
			}
		}
	}
};
