/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import {PagesVisitor} from 'data-engine-js-components-web';

import RulesSupport from '../../RuleBuilder/RulesSupport.es';
import {getField} from '../util/fields.es';
import handleFieldEdited from './fieldEditedHandler.es';

const handleFocusedFieldEvaluationEnded = (
	props,
	state,
	changedEditingLanguage = false,
	changedFieldType = false,
	instanceId,
	settingsContext
) => {
	if (changedEditingLanguage) {
		return state;
	}

	const fieldName = getField(settingsContext.pages, 'name');
	const {focusedField} = state;
	const focusedFieldName = getField(
		focusedField.settingsContext.pages,
		'name'
	);

	if (
		fieldName.instanceId !== focusedFieldName.instanceId &&
		!changedFieldType
	) {
		return state;
	}

	const {pages} = state;

	const visitor = new PagesVisitor(pages);

	let newState = {
		...state,
		focusedField: {
			...focusedField,
			instanceId: instanceId || focusedField.instanceId,
			settingsContext,
		},
		pages: visitor.mapFields((field) => {
			if (field.fieldName !== fieldName.value) {
				return field;
			}

			return {
				...field,
				settingsContext,
			};
		}),
	};

	const settingsContextVisitor = new PagesVisitor(settingsContext.pages);

	settingsContextVisitor.mapFields(({fieldName, value}) => {
		newState = handleFieldEdited(props, newState, {
			propertyName: fieldName,
			propertyValue: value,
		});
	});

	return {
		...newState,
		rules: changedFieldType
			? RulesSupport.formatRules(newState.pages, state.rules)
			: state.rules,
	};
};

export default handleFocusedFieldEvaluationEnded;
