/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import {FormSupport, PagesVisitor} from 'data-engine-js-components-web';

import {createDuplicatedField} from '../util/fields.es';
import {updateField} from '../util/settingsContext.es';

export const duplicateField = (
	activePage,
	props,
	pages,
	originalField,
	duplicatedField
) => {
	const visitor = new PagesVisitor(pages);

	const parentField = FormSupport.getParentField(
		pages,
		originalField.fieldName
	);

	if (parentField) {
		return visitor.mapFields(
			(field) => {
				if (field.fieldName === parentField.fieldName) {
					const nestedFields = field.nestedFields
						? [...field.nestedFields, duplicatedField]
						: [duplicatedField];

					field = updateField(
						props,
						field,
						'nestedFields',
						nestedFields
					);

					let {rows} = field;

					if (typeof rows === 'string') {
						rows = JSON.parse(rows);
					}

					let pages = [{rows}];

					const {rowIndex} = FormSupport.getFieldIndexes(
						pages,
						originalField.fieldName
					);

					const newRow = FormSupport.implAddRow(12, [
						duplicatedField.fieldName,
					]);

					pages = FormSupport.addRow(
						pages,
						rowIndex + 1,
						activePage,
						newRow
					);

					return updateField(props, field, 'rows', pages[0].rows);
				}

				return field;
			},
			true,
			true
		);
	}

	const {rowIndex} = FormSupport.getFieldIndexes(
		pages,
		originalField.fieldName
	);

	const newRow = FormSupport.implAddRow(12, [duplicatedField]);

	return FormSupport.addRow(pages, rowIndex + 1, activePage, newRow);
};

const handleFieldDuplicated = (props, state, {activePage, fieldName}) => {
	const {pages} = state;

	if (activePage === undefined) {
		activePage = state.activePage;
	}

	const originalField = JSON.parse(
		JSON.stringify(FormSupport.findFieldByFieldName(pages, fieldName))
	);

	const duplicatedField = createDuplicatedField(originalField, props);

	return {
		focusedField: {
			...duplicatedField,
		},
		pages: duplicateField(
			activePage,
			props,
			pages,
			originalField,
			duplicatedField
		),
	};
};

export default handleFieldDuplicated;
