/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import {PagesVisitor} from 'data-engine-js-components-web';

import {localizeField} from '../../../util/fieldSupport.es';

const handleFieldClicked = (props, state, event) => {
	const {defaultLanguageId, editingLanguageId} = props;
	const {activePage, field} = event;

	const visitor = new PagesVisitor(field.settingsContext.pages);

	const focusedField = {
		...field,
		settingsContext: {
			...field.settingsContext,
			currentPage: activePage,
			pages: visitor.mapFields((field) => {
				const {fieldName} = field;

				if (fieldName === 'validation') {
					field = {
						...field,
						validation: {
							...field.validation,
							fieldName: field.fieldName,
						},
					};
				}

				return localizeField(
					field,
					defaultLanguageId,
					editingLanguageId
				);
			}),
		},
	};

	return {
		activePage,
		focusedField,
		previousFocusedField: focusedField,
	};
};

export default handleFieldClicked;
