/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import {addField, createField} from '../../../util/fieldSupport.es';

const handleFieldAdded = (props, state, event) => {
	const {
		data: {parentFieldName},
		indexes,
		newField,
	} = event;
	const {pages} = state;

	return addField({
		...props,
		indexes,
		newField: newField ?? createField(props, event),
		pages,
		parentFieldName,
	});
};

export default handleFieldAdded;
