/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.builder.internal.settings;

import com.liferay.dynamic.data.mapping.expression.DDMExpressionFunction;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFunctionRegistry;
import com.liferay.dynamic.data.mapping.form.builder.internal.util.DDMExpressionFunctionMetadata;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureService;
import com.liferay.dynamic.data.mapping.spi.converter.SPIDDMFormRuleConverter;
import com.liferay.dynamic.data.mapping.spi.form.builder.settings.DDMFormBuilderSettingsRetrieverHelper;
import com.liferay.dynamic.data.mapping.util.comparator.StructureNameComparator;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONSerializer;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.AggregateResourceBundle;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DDMFormBuilderSettingsRetrieverHelper.class})
public class DDMFormBuilderSettingsRetrieverHelperImpl
implements DDMFormBuilderSettingsRetrieverHelper {
    private static final String _TYPE_BOOLEAN = "boolean";
    private static final String _TYPE_LIST = "list";
    private static final String _TYPE_NUMBER = "number";
    private static final String _TYPE_TEXT = "text";
    private static final String _TYPE_USER = "user";
    private static final Map<String, String> _binaryFunctions = LinkedHashMapBuilder.put((Object)"equals-to", (Object)"is-equal-to").put((Object)"not-equals-to", (Object)"is-not-equal-to").build();
    private static final Map<String, String> _numberBinaryFunctions = LinkedHashMapBuilder.put((Object)"greater-than", (Object)"is-greater-than").put((Object)"greater-than-equals", (Object)"is-greater-than-or-equal-to").put((Object)"less-than", (Object)"is-less-than").put((Object)"less-than-equals", (Object)"is-less-than-or-equal-to").build();
    private static final Map<String, String> _textBinaryFunctions = LinkedHashMapBuilder.put((Object)"contains", (Object)"contains").put((Object)"not-contains", (Object)"does-not-contain").build();
    private static final Map<String, String> _unaryFunctions = LinkedHashMapBuilder.put((Object)"is-empty", (Object)"is-empty").put((Object)"not-is-empty", (Object)"is-not-empty").build();
    @Reference(target="(osgi.http.whiteboard.servlet.name=com.liferay.dynamic.data.mapping.form.builder.internal.servlet.DDMDataProviderInstanceParameterSettingsServlet)")
    private Servlet _ddmDataProviderInstanceParameterSettingsServlet;
    @Reference(target="(osgi.http.whiteboard.servlet.name=com.liferay.dynamic.data.mapping.form.builder.internal.servlet.DDMDataProviderInstancesServlet)")
    private Servlet _ddmDataProviderInstancesServlet;
    @Reference
    private DDMExpressionFunctionRegistry _ddmExpressionFunctionRegistry;
    @Reference(target="(osgi.http.whiteboard.servlet.name=com.liferay.dynamic.data.mapping.form.builder.internal.servlet.DDMFieldSetDefinitionServlet)")
    private Servlet _ddmFieldSetDefinitionServlet;
    @Reference(target="(osgi.http.whiteboard.servlet.name=com.liferay.dynamic.data.mapping.form.builder.internal.servlet.DDMFieldSettingsDDMFormContextServlet)")
    private Servlet _ddmFieldSettingsDDMFormContextServlet;
    @Reference(target="(osgi.http.whiteboard.servlet.name=com.liferay.dynamic.data.mapping.form.renderer.internal.servlet.DDMFormContextProviderServlet)")
    private Servlet _ddmFormContextProviderServlet;
    @Reference(target="(osgi.http.whiteboard.servlet.name=com.liferay.dynamic.data.mapping.form.builder.internal.servlet.DDMFormFunctionsServlet)")
    private Servlet _ddmFormFunctionsServlet;
    @Reference
    private DDMStructureService _ddmStructureService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;
    @Reference
    private Portal _portal;
    @Reference(target="(osgi.http.whiteboard.servlet.name=com.liferay.dynamic.data.mapping.form.builder.internal.servlet.RolesServlet)")
    private Servlet _rolesServlet;
    @Reference
    private SPIDDMFormRuleConverter _spiDDMFormRuleConverter;

    public String getDDMDataProviderInstanceParameterSettingsURL() {
        String servletContextPath = this._getServletContextPath(this._ddmDataProviderInstanceParameterSettingsServlet);
        return servletContextPath.concat("/dynamic-data-mapping-form-builder-provider-instance-parameter-settings/");
    }

    public String getDDMDataProviderInstancesURL() {
        String servletContextPath = this._getServletContextPath(this._ddmDataProviderInstancesServlet);
        return servletContextPath.concat("/dynamic-data-mapping-form-builder-data-provider-instances/");
    }

    public String getDDMFieldSetDefinitionURL() {
        String servletContextPath = this._getServletContextPath(this._ddmFieldSetDefinitionServlet);
        return servletContextPath.concat("/dynamic-data-mapping-form-builder-fieldset-definition/");
    }

    public String getDDMFieldSettingsDDMFormContextURL() {
        String servletContextPath = this._getServletContextPath(this._ddmFieldSettingsDDMFormContextServlet);
        return servletContextPath.concat("/dynamic-data-mapping-form-builder-field-settings-form-context/");
    }

    public String getDDMFormContextProviderURL() {
        String servletContextPath = this._getServletContextPath(this._ddmFormContextProviderServlet);
        return servletContextPath.concat("/dynamic-data-mapping-form-context-provider/");
    }

    public String getDDMFunctionsURL() {
        String servletContextPath = this._getServletContextPath(this._ddmFormFunctionsServlet);
        return servletContextPath.concat("/dynamic-data-mapping-form-builder-functions/");
    }

    public JSONArray getFieldSetsMetadataJSONArray(long companyId, long scopeGroupId, long fieldSetClassNameId, Locale locale) {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        if (fieldSetClassNameId == 0L) {
            return jsonArray;
        }
        List ddmStructures = this._ddmStructureService.search(companyId, new long[]{scopeGroupId}, fieldSetClassNameId, "", 2, -1, -1, -1, (OrderByComparator)new StructureNameComparator(true));
        for (DDMStructure ddmStructure : ddmStructures) {
            JSONObject jsonObject = this._jsonFactory.createJSONObject();
            jsonObject.put("description", ddmStructure.getDescription(locale, true)).put("icon", "forms").put("id", ddmStructure.getStructureId()).put("name", ddmStructure.getName(locale, true));
            jsonArray.put(jsonObject);
        }
        return jsonArray;
    }

    public String getRolesURL() {
        String servletContextPath = this._getServletContextPath(this._rolesServlet);
        return servletContextPath.concat("/dynamic-data-mapping-form-builder-roles/");
    }

    public String getSerializedDDMExpressionFunctionsMetadata(Locale locale) {
        JSONSerializer jsonSerializer = this._jsonFactory.createJSONSerializer();
        return jsonSerializer.serializeDeep(this._getDDMExpressionFunctionsMetadata(locale));
    }

    public String getSerializedDDMFormRules(DDMForm ddmForm) {
        JSONSerializer jsonSerializer = this._jsonFactory.createJSONSerializer();
        return jsonSerializer.serializeDeep((Object)this._spiDDMFormRuleConverter.convert(ddmForm.getDDMFormRules()));
    }

    protected void populateCustomDDMExpressionFunctionsMetadata(Map<String, List<DDMExpressionFunctionMetadata>> ddmExpressionFunctionMetadatasMap, Locale locale) {
        Map customDDMExpressionFunctions = this._ddmExpressionFunctionRegistry.getCustomDDMExpressionFunctions();
        for (Map.Entry entry : customDDMExpressionFunctions.entrySet()) {
            int parameterCount;
            Method method = null;
            DDMExpressionFunction ddmExpressionFunction = (DDMExpressionFunction)entry.getValue();
            Class clazz = ddmExpressionFunction.getClass();
            for (Method curMethod : clazz.getMethods()) {
                if (!Objects.equals(curMethod.getName(), "apply") || !Objects.equals(curMethod.getReturnType(), Boolean.class)) continue;
                method = curMethod;
                break;
            }
            if (method == null || (parameterCount = method.getParameterCount()) > 2) continue;
            String label = ddmExpressionFunction.getLabel(locale);
            if (Validator.isNull((String)label)) {
                label = (String)entry.getKey();
            }
            this._addDDMExpressionFunctionMetadata(ddmExpressionFunctionMetadatasMap, new DDMExpressionFunctionMetadata((String)entry.getKey(), label, _TYPE_BOOLEAN, this._getParameterClassNames(parameterCount, _TYPE_NUMBER)));
            this._addDDMExpressionFunctionMetadata(ddmExpressionFunctionMetadatasMap, new DDMExpressionFunctionMetadata((String)entry.getKey(), label, _TYPE_BOOLEAN, this._getParameterClassNames(parameterCount, _TYPE_TEXT)));
        }
    }

    protected void populateDDMExpressionFunctionsMetadata(Map<String, List<DDMExpressionFunctionMetadata>> ddmExpressionFunctionMetadatasMap, ResourceBundle resourceBundle) {
        this._addDDMExpressionFunctionMetadata(ddmExpressionFunctionMetadatasMap, new DDMExpressionFunctionMetadata("belongs-to", this._language.get(resourceBundle, "belongs-to"), _TYPE_BOOLEAN, new String[]{_TYPE_USER, _TYPE_LIST}));
        this._addDDMExpressionFunctionMetadata(ddmExpressionFunctionMetadatasMap, new DDMExpressionFunctionMetadata("equals-to", this._language.get(resourceBundle, "is-equal-to"), _TYPE_BOOLEAN, new String[]{_TYPE_BOOLEAN, _TYPE_BOOLEAN}));
        for (Map.Entry<String, String> entry : _binaryFunctions.entrySet()) {
            this._addDDMExpressionFunctionMetadata(ddmExpressionFunctionMetadatasMap, new DDMExpressionFunctionMetadata(entry.getKey(), this._language.get(resourceBundle, entry.getValue()), _TYPE_BOOLEAN, new String[]{_TYPE_NUMBER, _TYPE_NUMBER}));
            this._addDDMExpressionFunctionMetadata(ddmExpressionFunctionMetadatasMap, new DDMExpressionFunctionMetadata(entry.getKey(), this._language.get(resourceBundle, entry.getValue()), _TYPE_BOOLEAN, new String[]{_TYPE_TEXT, _TYPE_TEXT}));
        }
        for (Map.Entry<String, String> entry : _numberBinaryFunctions.entrySet()) {
            this._addDDMExpressionFunctionMetadata(ddmExpressionFunctionMetadatasMap, new DDMExpressionFunctionMetadata(entry.getKey(), this._language.get(resourceBundle, entry.getValue()), _TYPE_BOOLEAN, new String[]{_TYPE_NUMBER, _TYPE_NUMBER}));
        }
        for (Map.Entry<String, String> entry : _textBinaryFunctions.entrySet()) {
            this._addDDMExpressionFunctionMetadata(ddmExpressionFunctionMetadatasMap, new DDMExpressionFunctionMetadata(entry.getKey(), this._language.get(resourceBundle, entry.getValue()), _TYPE_BOOLEAN, new String[]{_TYPE_TEXT, _TYPE_TEXT}));
        }
        for (Map.Entry<String, String> entry : _unaryFunctions.entrySet()) {
            this._addDDMExpressionFunctionMetadata(ddmExpressionFunctionMetadatasMap, new DDMExpressionFunctionMetadata(entry.getKey(), this._language.get(resourceBundle, entry.getValue()), _TYPE_BOOLEAN, new String[]{_TYPE_NUMBER}));
            this._addDDMExpressionFunctionMetadata(ddmExpressionFunctionMetadatasMap, new DDMExpressionFunctionMetadata(entry.getKey(), this._language.get(resourceBundle, entry.getValue()), _TYPE_BOOLEAN, new String[]{_TYPE_TEXT}));
        }
    }

    private void _addDDMExpressionFunctionMetadata(Map<String, List<DDMExpressionFunctionMetadata>> ddmExpressionFunctionMetadatasMap, DDMExpressionFunctionMetadata ddmExpressionFunctionMetadata) {
        String firstParameterClassName = ddmExpressionFunctionMetadata.getParameterClassNames()[0];
        List<DDMExpressionFunctionMetadata> ddmExpressionFunctionMetadatas = ddmExpressionFunctionMetadatasMap.get(firstParameterClassName);
        if (ddmExpressionFunctionMetadatas == null) {
            ddmExpressionFunctionMetadatas = new ArrayList<DDMExpressionFunctionMetadata>();
            ddmExpressionFunctionMetadatasMap.put(firstParameterClassName, ddmExpressionFunctionMetadatas);
        }
        ddmExpressionFunctionMetadatas.add(ddmExpressionFunctionMetadata);
    }

    private Map<String, List<DDMExpressionFunctionMetadata>> _getDDMExpressionFunctionsMetadata(Locale locale) {
        HashMap<String, List<DDMExpressionFunctionMetadata>> ddmExpressionFunctionMetadatasMap = new HashMap<String, List<DDMExpressionFunctionMetadata>>();
        this.populateCustomDDMExpressionFunctionsMetadata(ddmExpressionFunctionMetadatasMap, locale);
        this.populateDDMExpressionFunctionsMetadata(ddmExpressionFunctionMetadatasMap, this._getResourceBundle(locale));
        return ddmExpressionFunctionMetadatasMap;
    }

    private String[] _getParameterClassNames(int parameterCount, String parameterClassName) {
        Object[] parameterClassNames = new String[parameterCount];
        Arrays.fill(parameterClassNames, parameterClassName);
        return parameterClassNames;
    }

    private ResourceBundle _getResourceBundle(Locale locale) {
        ResourceBundle portalResourceBundle = this._portal.getResourceBundle(locale);
        ResourceBundle portletResourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        return new AggregateResourceBundle(new ResourceBundle[]{portletResourceBundle, portalResourceBundle});
    }

    private String _getServletContextPath(Servlet servlet) {
        String proxyPath = this._portal.getPathProxy();
        ServletConfig servletConfig = servlet.getServletConfig();
        ServletContext servletContext = servletConfig.getServletContext();
        return proxyPath.concat(servletContext.getContextPath());
    }
}

